/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.Instance;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.Transaction;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionImpl
implements Transaction {
    public static final long DEFAULT_TXN_TIMEOUT = 30000L;
    private final long id;
    private final FactoryImpl factory;
    private final List<TransactionRecord> transactionRecords = new CopyOnWriteArrayList<TransactionRecord>();
    private int status = 0;
    private final ILogger logger;

    public TransactionImpl(FactoryImpl factory, long txnId) {
        this.id = txnId;
        this.factory = factory;
        this.logger = factory.getLoggingService().getLogger(this.getClass().getName());
    }

    public Data attachPutOp(String name, Object key, Data value, boolean newRecord) {
        return this.attachPutOp(name, key, value, 0L, -1L, newRecord, -1);
    }

    public void attachPutMultiOp(String name, Object key, Data value) {
        this.transactionRecords.add(new TransactionRecord(name, key, value, true));
    }

    public Data attachPutOp(String name, Object key, Data value, int timeout, long ttl, boolean newRecord) {
        return this.attachPutOp(name, key, value, timeout, ttl, newRecord, -1);
    }

    public Data attachPutOp(String name, Object key, Data value, long timeout, boolean newRecord, int index) {
        return this.attachPutOp(name, key, value, timeout, -1L, newRecord, index);
    }

    public Data attachPutOp(String name, Object key, Data value, long timeout, long ttl, boolean newRecord, int index) {
        Instance.InstanceType instanceType = ConcurrentMapManager.getInstanceType(name);
        Object matchValue = instanceType.isMultiMap() ? IOUtil.toObject(value) : null;
        TransactionRecord rec = this.findTransactionRecord(name, key, matchValue);
        if (rec == null) {
            rec = new TransactionRecord(name, key, value, newRecord);
            rec.timeout = timeout;
            rec.ttl = ttl;
            rec.index = index;
            this.transactionRecords.add(rec);
            return null;
        }
        Data old = rec.value;
        rec.value = value;
        rec.removed = false;
        rec.index = index;
        return old;
    }

    public Data attachRemoveOp(String name, Object key, Data value, boolean newRecord) {
        return this.attachRemoveOp(name, key, value, newRecord, 1);
    }

    public Data attachRemoveOp(String name, Object key, Data value, boolean newRecord, int valueCount) {
        Instance.InstanceType instanceType = ConcurrentMapManager.getInstanceType(name);
        Object matchValue = instanceType.isMultiMap() ? IOUtil.toObject(value) : null;
        TransactionRecord rec = this.findTransactionRecord(name, key, matchValue);
        Data oldValue = null;
        if (rec == null) {
            rec = new TransactionRecord(name, key, value, newRecord);
            this.transactionRecords.add(rec);
        } else {
            oldValue = rec.value;
            rec.value = value;
        }
        rec.valueCount = valueCount;
        rec.removed = true;
        return oldValue;
    }

    @Override
    public void begin() throws IllegalStateException {
        if (this.status == 1) {
            throw new IllegalStateException("Transaction is already active");
        }
        this.status = 1;
    }

    @Override
    public void commit() throws IllegalStateException {
        if (this.status != 1) {
            throw new IllegalStateException("Transaction is not active");
        }
        this.status = 6;
        try {
            ThreadContext.get().setCurrentFactory(this.factory);
            for (TransactionRecord transactionRecord : this.transactionRecords) {
                transactionRecord.commit();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.finalizeTxn();
            this.status = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws IllegalStateException {
        if (this.status == 0 || this.status == 8 || this.status == 3 || this.status == 4) {
            throw new IllegalStateException("Transaction is not ready to rollback. Status= " + this.status);
        }
        this.status = 7;
        try {
            ThreadContext.get().setCurrentFactory(this.factory);
            int size = this.transactionRecords.size();
            ListIterator<TransactionRecord> iter = this.transactionRecords.listIterator(size);
            while (iter.hasPrevious()) {
                TransactionRecord record = iter.previous();
                if (record.instanceType.isQueue()) {
                    this.rollbackMapTransactionRecordOfQueue(iter, record);
                }
                record.rollback();
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        finally {
            this.finalizeTxn();
            this.status = 4;
        }
    }

    private void rollbackMapTransactionRecordOfQueue(ListIterator<TransactionRecord> iter, TransactionRecord queueTxRecord) {
        if (iter.hasPrevious()) {
            TransactionRecord prevRecord = iter.previous();
            if (prevRecord.instanceType != Instance.InstanceType.MAP) {
                this.logger.log(Level.WARNING, "Map#TransactionRecord is expected before a Queue#TransactionRecord, but got " + (Object)((Object)prevRecord.instanceType));
            } else if (!prevRecord.name.equals("c:" + queueTxRecord.name)) {
                this.logger.log(Level.WARNING, "Expecting a record of c:" + queueTxRecord.name + " but got " + prevRecord.name);
            }
            prevRecord.rollback();
        }
    }

    public boolean containsValue(String name, Object value) {
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            if (!transactionRecord.name.equals(name) || transactionRecord.removed || !value.equals(IOUtil.toObject(transactionRecord.value))) continue;
            return true;
        }
        return false;
    }

    public boolean containsEntry(String name, Object key, Object value) {
        TransactionRecord transactionRecord = this.findTransactionRecord(name, key, value);
        return transactionRecord != null && !transactionRecord.removed;
    }

    private TransactionRecord findTransactionRecord(String name, Object key) {
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            if (!transactionRecord.name.equals(name) || transactionRecord.key == null || !transactionRecord.key.equals(key)) continue;
            return transactionRecord;
        }
        return null;
    }

    private TransactionRecord findTransactionRecord(String name, Object key, Object value) {
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            if (!transactionRecord.name.equals(name) || transactionRecord.key == null || !transactionRecord.key.equals(key)) continue;
            Object txValue = IOUtil.toObject(transactionRecord.value);
            if (transactionRecord.instanceType.isMultiMap()) {
                if (value == null && txValue == null) {
                    return transactionRecord;
                }
                if (value == null || !value.equals(txValue)) continue;
                return transactionRecord;
            }
            if (value == null) {
                return transactionRecord;
            }
            if (!value.equals(txValue)) continue;
            return transactionRecord;
        }
        return null;
    }

    public Data get(String name, Object key) {
        TransactionRecord rec = this.findTransactionRecord(name, key);
        if (rec == null) {
            return null;
        }
        if (rec.removed) {
            return null;
        }
        rec.lastAccess = Clock.currentTimeMillis();
        return rec.value;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public boolean has(String name, Object key) {
        return this.findTransactionRecord(name, key) != null;
    }

    public boolean has(String name, Object key, Object value) {
        return this.findTransactionRecord(name, key, value) != null;
    }

    public boolean isNew(String name, Object key) {
        TransactionRecord rec = this.findTransactionRecord(name, key);
        return rec != null && !rec.removed && rec.newRecord;
    }

    public boolean isRemoved(String name, Object key) {
        TransactionRecord rec = this.findTransactionRecord(name, key);
        return rec != null && rec.removed;
    }

    public int size(String name) {
        int size = 0;
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            if (!transactionRecord.name.equals(name)) continue;
            if (transactionRecord.removed) {
                if (transactionRecord.instanceType.isSet()) {
                    --size;
                    continue;
                }
                if (transactionRecord.newRecord || transactionRecord.instanceType.isQueue()) continue;
                size -= transactionRecord.valueCount;
                continue;
            }
            if (!transactionRecord.newRecord) continue;
            if (transactionRecord.instanceType.isList()) {
                size += ((Integer)IOUtil.toObject(transactionRecord.value)).intValue();
                continue;
            }
            ++size;
        }
        return size;
    }

    public List<Map.Entry> newEntries(String name) {
        ArrayList<MapEntry> lsEntries = null;
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            if (!transactionRecord.name.equals(name) || transactionRecord.removed || transactionRecord.value == null || !transactionRecord.newRecord) continue;
            if (lsEntries == null) {
                lsEntries = new ArrayList<MapEntry>(2);
            }
            lsEntries.add(BaseManager.createSimpleMapEntry(this.factory, name, transactionRecord.key, transactionRecord.value));
        }
        return lsEntries;
    }

    public void getMulti(String name, Object key, Collection col) {
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            if (!transactionRecord.name.equals(name) || !key.equals(transactionRecord.key)) continue;
            if (!transactionRecord.removed && transactionRecord.newRecord) {
                col.add(IOUtil.toObject(transactionRecord.value));
                continue;
            }
            if (!transactionRecord.removed) continue;
            if (transactionRecord.value == null) {
                col.clear();
                return;
            }
            col.remove(IOUtil.toObject(transactionRecord.value));
        }
    }

    public Map newKeys(String name) {
        HashMap<Object, Data> newEntries = null;
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            if (!transactionRecord.name.equals(name) || transactionRecord.removed || transactionRecord.value == null || !transactionRecord.newRecord) continue;
            if (newEntries == null) {
                newEntries = new HashMap<Object, Data>();
            }
            newEntries.put(transactionRecord.key, transactionRecord.value);
        }
        return newEntries;
    }

    public String toString() {
        return "TransactionImpl [" + this.id + "] status: " + this.status;
    }

    private void finalizeTxn() {
        this.transactionRecords.clear();
        this.status = 0;
        ThreadContext.get().finalizeTxn();
    }

    private class TransactionRecord {
        public String name;
        public Object key;
        public Data value;
        public boolean removed = false;
        public boolean newRecord = false;
        public Instance.InstanceType instanceType = null;
        public long lastAccess = -1L;
        public int valueCount = 1;
        public long timeout = 0L;
        public long ttl = -1L;
        public int index = -1;

        public TransactionRecord(String name, Object key, Data value, boolean newRecord) {
            this.name = name;
            this.key = key;
            this.value = value;
            this.newRecord = newRecord;
            this.instanceType = ConcurrentMapManager.getInstanceType(name);
        }

        public TransactionRecord(String name, Object key, Data value, int index, boolean newRecord) {
            this.name = name;
            this.key = key;
            this.value = value;
            this.newRecord = newRecord;
            this.index = index;
            this.instanceType = ConcurrentMapManager.getInstanceType(name);
        }

        public void commit() {
            if (this.instanceType == Instance.InstanceType.QUEUE) {
                this.commitQueue();
            } else {
                this.commitMap();
            }
        }

        public void commitMap() {
            if (this.removed) {
                if (this.instanceType.isSet()) {
                    ConcurrentMapManager.MRemoveItem mRemoveItem = ((TransactionImpl)TransactionImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MRemoveItem();
                    mRemoveItem.removeItem(this.name, this.key);
                } else if (!this.newRecord) {
                    if (this.instanceType.isMap()) {
                        ((TransactionImpl)TransactionImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MRemove().remove(this.name, this.key, -1L);
                    } else if (this.instanceType.isMultiMap()) {
                        if (this.value == null) {
                            ((TransactionImpl)TransactionImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MRemove().remove(this.name, this.key, -1L);
                        } else {
                            ((TransactionImpl)TransactionImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MRemoveMulti().remove(this.name, this.key, this.value);
                        }
                    }
                } else {
                    ((TransactionImpl)TransactionImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MLock().unlock(this.name, this.key, -1L);
                }
            } else if (this.instanceType.isMultiMap()) {
                ((TransactionImpl)TransactionImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MPutMulti().put(this.name, this.key, this.value);
            } else {
                ((TransactionImpl)TransactionImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MPut().putAfterCommit(this.name, this.key, this.value, -1L, this.ttl, TransactionImpl.this.id);
            }
        }

        public void commitQueue() {
            if (!this.removed) {
                ((TransactionImpl)TransactionImpl.this).factory.node.blockingQueueManager.offerCommit(this.name, this.key, this.value, this.index);
            }
        }

        public void rollback() {
            if (this.instanceType == Instance.InstanceType.QUEUE) {
                this.rollbackQueue();
            } else {
                this.rollbackMap();
            }
        }

        public void rollbackMap() {
            MProxy mapProxy = null;
            Object proxy = TransactionImpl.this.factory.getOrCreateProxyByName(this.name);
            if (proxy instanceof MProxy) {
                mapProxy = (MProxy)proxy;
            }
            if (mapProxy != null) {
                mapProxy.unlock(this.key);
            }
        }

        public void rollbackQueue() {
            if (this.removed) {
                ((TransactionImpl)TransactionImpl.this).factory.node.blockingQueueManager.rollbackPoll(this.name, this.key, this.value);
            }
        }

        public String toString() {
            return "TransactionRecord{instanceType=" + (Object)((Object)this.instanceType) + ", name='" + this.name + '\'' + ", key=" + this.key + ", value=" + this.value + ", removed=" + this.removed + ", newRecord=" + this.newRecord + ", lastAccess=" + this.lastAccess + ", valueCount=" + this.valueCount + '}';
        }
    }
}

