/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.cluster.RemotelyProcessable;
import com.hazelcast.config.Config;
import com.hazelcast.config.Interfaces;
import com.hazelcast.config.Join;
import com.hazelcast.core.Member;
import com.hazelcast.impl.AbstractJoiner;
import com.hazelcast.impl.AddressPicker;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.SplitBrainHandler;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.util.AddressUtil;
import com.hazelcast.util.Clock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class TcpIpJoiner
extends AbstractJoiner {
    private static final int MAX_ADDRESS_TRIES = 3;
    volatile boolean approved = true;
    final AtomicInteger responseCounter = new AtomicInteger();
    volatile boolean askingForApproval = false;

    public TcpIpJoiner(Node node) {
        super(node);
    }

    private void joinViaRequiredMember(AtomicBoolean joined) {
        try {
            Address requiredAddress = this.getAddressFor(this.config.getNetworkConfig().getJoin().getTcpIpConfig().getRequiredMember());
            this.logger.log(Level.FINEST, "Joining over required member " + requiredAddress);
            if (requiredAddress == null) {
                throw new RuntimeException("Invalid required member " + this.config.getNetworkConfig().getJoin().getTcpIpConfig().getRequiredMember());
            }
            if (requiredAddress.equals(this.node.address)) {
                this.node.setAsMaster();
                return;
            }
            this.node.connectionManager.getOrConnect(requiredAddress);
            Connection conn = null;
            while (conn == null) {
                conn = this.node.connectionManager.getOrConnect(requiredAddress);
                Thread.sleep(2000L);
            }
            long joinStartTime = Clock.currentTimeMillis();
            long maxJoinMillis = this.node.getGroupProperties().MAX_JOIN_SECONDS.getInteger() * 1000;
            while (this.node.isActive() && !joined.get() && Clock.currentTimeMillis() - joinStartTime < maxJoinMillis) {
                Connection connection = this.node.connectionManager.getOrConnect(requiredAddress);
                if (connection == null) {
                    this.joinViaRequiredMember(joined);
                }
                this.logger.log(Level.FINEST, "Sending joinRequest " + requiredAddress);
                this.node.clusterManager.sendJoinRequest(requiredAddress, true);
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void joinViaPossibleMembers(AtomicBoolean joined) {
        try {
            this.node.getFailedConnections().clear();
            Collection<Address> colPossibleAddresses = this.getPossibleAddresses();
            colPossibleAddresses.remove(this.node.address);
            for (Address possibleAddress : colPossibleAddresses) {
                this.logger.log(Level.INFO, "connecting to " + possibleAddress);
                this.node.connectionManager.getOrConnect(possibleAddress);
            }
            boolean foundConnection = false;
            int numberOfSeconds = 0;
            int connectionTimeoutSeconds = this.config.getNetworkConfig().getJoin().getTcpIpConfig().getConnectionTimeoutSeconds();
            while (!foundConnection && numberOfSeconds < connectionTimeoutSeconds) {
                this.logger.log(Level.FINEST, "Removing failedConnections: " + this.node.getFailedConnections());
                colPossibleAddresses.removeAll(this.node.getFailedConnections());
                if (colPossibleAddresses.size() == 0) break;
                Thread.sleep(1000L);
                ++numberOfSeconds;
                this.logger.log(Level.FINEST, "We are going to try to connect to each address" + colPossibleAddresses);
                for (Address possibleAddress : colPossibleAddresses) {
                    Connection conn = this.node.connectionManager.getOrConnect(possibleAddress);
                    if (conn == null) continue;
                    foundConnection = true;
                    this.logger.log(Level.FINEST, "Found and sending join request for " + possibleAddress);
                    this.node.clusterManager.sendJoinRequest(possibleAddress, true);
                }
            }
            this.logger.log(Level.FINEST, "FOUND " + foundConnection);
            if (!foundConnection) {
                this.logger.log(Level.FINEST, "This node will assume master role since no possible member where connected to");
                this.node.setAsMaster();
            } else if (!this.node.joined()) {
                if (connectionTimeoutSeconds - numberOfSeconds > 0) {
                    this.logger.log(Level.FINEST, "Sleeping for " + (connectionTimeoutSeconds - numberOfSeconds) + " seconds.");
                    Thread.sleep((long)(connectionTimeoutSeconds - numberOfSeconds) * 1000L);
                }
                colPossibleAddresses.removeAll(this.node.getFailedConnections());
                if (colPossibleAddresses.size() == 0) {
                    this.logger.log(Level.FINEST, "This node will assume master role since all possible members didn't accept join request");
                    this.node.setAsMaster();
                } else {
                    boolean masterCandidate = true;
                    for (Address address : colPossibleAddresses) {
                        if (this.node.connectionManager.getConnection(address) == null || this.node.address.hashCode() <= address.hashCode()) continue;
                        masterCandidate = false;
                    }
                    if (masterCandidate) {
                        this.askingForApproval = true;
                        for (Address address : colPossibleAddresses) {
                            Connection conn = this.node.getConnectionManager().getConnection(address);
                            if (conn == null) continue;
                            this.responseCounter.incrementAndGet();
                            this.node.clusterManager.sendProcessableTo((RemotelyProcessable)new MasterQuestion(), conn);
                        }
                        int waitCount = 0;
                        while (this.node.isActive() && waitCount++ < 10) {
                            Thread.sleep(1000L);
                            if (this.responseCounter.get() != 0) continue;
                            if (this.approved) {
                                this.logger.log(Level.FINEST, this.node.getThisAddress() + " Setting myself as master! group " + this.node.getConfig().getGroupConfig().getName() + " possible addresses " + colPossibleAddresses.size() + "" + colPossibleAddresses);
                                this.node.setAsMaster();
                                return;
                            }
                            this.lookForMaster(colPossibleAddresses);
                            break;
                        }
                    } else {
                        this.lookForMaster(colPossibleAddresses);
                    }
                }
            }
            colPossibleAddresses.clear();
            this.node.getFailedConnections().clear();
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    private void lookForMaster(Collection<Address> colPossibleAddresses) throws InterruptedException {
        int tryCount = 0;
        while (!this.node.joined() && tryCount++ < 20 && this.node.getMasterAddress() == null) {
            this.connectAndSendJoinRequest(colPossibleAddresses);
            Thread.sleep(1000L);
        }
        int requestCount = 0;
        colPossibleAddresses.removeAll(this.node.getFailedConnections());
        if (colPossibleAddresses.size() == 0) {
            this.node.setAsMaster();
            this.logger.log(Level.FINEST, this.node.getThisAddress() + " Setting myself as master! group " + this.node.getConfig().getGroupConfig().getName() + " no possible addresses without failed connection");
            return;
        }
        this.logger.log(Level.FINEST, this.node.getThisAddress() + " joining to master " + this.node.getMasterAddress() + ", group " + this.node.getConfig().getGroupConfig().getName());
        while (this.node.isActive() && !this.node.joined()) {
            Thread.sleep(1000L);
            Address master = this.node.getMasterAddress();
            if (master != null) {
                this.node.clusterManager.sendJoinRequest(master, true);
                if (requestCount++ <= this.node.getGroupProperties().MAX_WAIT_SECONDS_BEFORE_JOIN.getInteger() + 10) continue;
                this.logger.log(Level.WARNING, "Couldn't join to the master : " + master);
                return;
            }
            this.logger.log(Level.FINEST, this.node.getThisAddress() + " couldn't find a master! but there was connections available: " + colPossibleAddresses);
            return;
        }
    }

    private Address getAddressFor(String host) {
        try {
            AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder(host, this.config.getPort());
            if (AddressUtil.isIpAddress(addressHolder.address)) {
                return new Address(addressHolder.address, addressHolder.port);
            }
            InetAddress[] allAddresses = InetAddress.getAllByName(addressHolder.address);
            Interfaces interfaces = this.config.getNetworkConfig().getInterfaces();
            for (InetAddress inetAddress : allAddresses) {
                boolean matchingAddress = true;
                if (interfaces.isEnabled()) {
                    matchingAddress = AddressPicker.matchAddress(inetAddress.getHostAddress(), interfaces.getInterfaces());
                }
                if (!matchingAddress) continue;
                return new Address(inetAddress, addressHolder.port);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        return null;
    }

    @Override
    public void doJoin(AtomicBoolean joined) {
        if (this.config.getNetworkConfig().getJoin().getTcpIpConfig().getRequiredMember() != null) {
            this.joinViaRequiredMember(joined);
        } else {
            this.joinViaPossibleMembers(joined);
        }
    }

    private Collection<Address> getPossibleAddresses() {
        Collection<String> possibleMembers = this.getMembers();
        HashSet<Address> setPossibleAddresses = new HashSet<Address>();
        Address thisAddress = this.node.address;
        for (String host : possibleMembers) {
            try {
                InetAddress[] allAddresses;
                AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder(host);
                boolean portIsDefined = addressHolder.port != -1 || !this.config.isPortAutoIncrement();
                int maxAddressTries = portIsDefined ? 1 : 3;
                int port = addressHolder.port != -1 ? addressHolder.port : this.config.getPort();
                AddressUtil.AddressMatcher addressMatcher = null;
                try {
                    addressMatcher = AddressUtil.getAddressMatcher(addressHolder.address);
                }
                catch (AddressUtil.InvalidAddressException ignore) {
                    // empty catch block
                }
                if (addressMatcher != null) {
                    Collection<String> matchedAddresses = addressMatcher.isIPv4() ? AddressUtil.getMatchingIpv4Addresses(addressMatcher) : Collections.singleton(addressHolder.address);
                    for (String matchedAddress : matchedAddresses) {
                        for (int i = 0; i < maxAddressTries; ++i) {
                            Address addressProper = new Address(matchedAddress, port + i);
                            if (addressProper.equals(thisAddress)) continue;
                            setPossibleAddresses.add(addressProper);
                        }
                    }
                    continue;
                }
                for (InetAddress inetAddress : allAddresses = InetAddress.getAllByName(addressHolder.address)) {
                    boolean matchingAddress = true;
                    Interfaces interfaces = this.config.getNetworkConfig().getInterfaces();
                    if (interfaces.isEnabled()) {
                        matchingAddress = AddressPicker.matchAddress(inetAddress.getHostAddress(), interfaces.getInterfaces());
                    }
                    if (!matchingAddress) continue;
                    for (int i = 0; i < maxAddressTries; ++i) {
                        Address addressProper = new Address(inetAddress, port + i);
                        if (addressProper.equals(thisAddress)) continue;
                        setPossibleAddresses.add(addressProper);
                    }
                }
            }
            catch (UnknownHostException e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        setPossibleAddresses.addAll(this.config.getNetworkConfig().getJoin().getTcpIpConfig().getAddresses());
        return setPossibleAddresses;
    }

    protected Collection<String> getMembers() {
        return TcpIpJoiner.getConfigurationMembers(this.config);
    }

    public static Collection<String> getConfigurationMembers(Config config) {
        Join join = config.getNetworkConfig().getJoin();
        List<String> configMembers = join.getTcpIpConfig().getMembers();
        HashSet<String> possibleMembers = new HashSet<String>();
        for (String member : configMembers) {
            String[] members;
            for (String address : members = member.split("[,; ]")) {
                possibleMembers.add(address);
            }
        }
        return possibleMembers;
    }

    @Override
    public void searchForOtherClusters(SplitBrainHandler splitBrainHandler) {
        Collection<Address> colPossibleAddresses;
        try {
            colPossibleAddresses = this.getPossibleAddresses();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        colPossibleAddresses.remove(this.node.getThisAddress());
        for (Member member : this.node.getClusterImpl().getMembers()) {
            colPossibleAddresses.remove(((MemberImpl)member).getAddress());
        }
        if (colPossibleAddresses.size() == 0) {
            return;
        }
        for (Address possibleAddress : colPossibleAddresses) {
            this.logger.log(Level.FINEST, this.node.getThisAddress() + " is connecting to " + possibleAddress);
            this.node.connectionManager.getOrConnect(possibleAddress, true);
        }
        for (Address possibleAddress : colPossibleAddresses) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return;
            }
            Connection conn = this.node.connectionManager.getConnection(possibleAddress);
            if (conn == null) continue;
            JoinInfo response = this.node.clusterManager.checkJoin(conn);
            if (response != null && this.shouldMerge(response)) {
                this.logger.log(Level.WARNING, this.node.address + " is merging [tcp/ip] to " + possibleAddress);
                splitBrainHandler.restart();
            }
            return;
        }
    }

    public static class MasterAnswer
    extends AbstractRemotelyProcessable {
        Address respondingAddress = null;
        boolean approved = false;

        public MasterAnswer(Address respondingAddress, boolean approved) {
            this.respondingAddress = respondingAddress;
            this.approved = approved;
        }

        public MasterAnswer() {
        }

        @Override
        public void process() {
            TcpIpJoiner tcpIpJoiner = (TcpIpJoiner)this.getNode().getJoiner();
            if (!this.approved) {
                tcpIpJoiner.approved = false;
            }
            tcpIpJoiner.responseCounter.decrementAndGet();
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            super.writeData(out);
            out.writeBoolean(this.approved);
            this.respondingAddress.writeData(out);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            super.readData(in);
            this.approved = in.readBoolean();
            this.respondingAddress = new Address();
            this.respondingAddress.readData(in);
        }
    }

    public static class MasterQuestion
    extends AbstractRemotelyProcessable {
        @Override
        public void process() {
            TcpIpJoiner tcpIpJoiner = (TcpIpJoiner)this.getNode().getJoiner();
            boolean shouldApprove = !tcpIpJoiner.askingForApproval && !this.node.isMaster();
            this.getNode().clusterManager.sendProcessableTo((RemotelyProcessable)new MasterAnswer(this.node.getThisAddress(), shouldApprove), this.getConnection());
        }
    }
}

