/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemListener;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.HazelcastInstanceAwareInstance;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MProxyImpl;
import com.hazelcast.impl.SetProxy;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.Iterator;

public class SetProxyImpl
extends AbstractCollection
implements SetProxy,
DataSerializable,
HazelcastInstanceAwareInstance {
    String name = null;
    private transient SetProxy base = null;
    private transient FactoryImpl factory = null;

    public SetProxyImpl() {
    }

    SetProxyImpl(String name, FactoryImpl factory) {
        this.name = name;
        this.factory = factory;
        this.base = new SetProxyReal();
    }

    public SetProxy getBase() {
        return this.base;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.factory = (FactoryImpl)hazelcastInstance;
    }

    private void ensure() {
        this.factory.initialChecks();
        if (this.base == null) {
            this.base = (SetProxy)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    public Object getId() {
        this.ensure();
        return this.base.getId();
    }

    public String toString() {
        return "Set [" + this.getName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetProxyImpl that = (SetProxyImpl)o;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public int size() {
        this.ensure();
        return this.base.size();
    }

    public boolean contains(Object o) {
        this.ensure();
        return this.base.contains(o);
    }

    public Iterator iterator() {
        this.ensure();
        return this.base.iterator();
    }

    public boolean add(Object o) {
        this.ensure();
        return this.base.add(o);
    }

    public boolean remove(Object o) {
        this.ensure();
        return this.base.remove(o);
    }

    public void clear() {
        this.ensure();
        this.base.clear();
    }

    public Instance.InstanceType getInstanceType() {
        this.ensure();
        return this.base.getInstanceType();
    }

    public void destroy() {
        this.factory.destroyInstanceClusterWide(this.name, null);
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
    }

    public void readData(DataInput in) throws IOException {
        this.name = in.readUTF();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeData(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readData(in);
    }

    public String getName() {
        return this.name.substring("m:s:".length());
    }

    public void addItemListener(ItemListener itemListener, boolean includeValue) {
        this.ensure();
        this.base.addItemListener(itemListener, includeValue);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.ensure();
        this.base.removeItemListener(itemListener);
    }

    public MProxy getMProxy() {
        this.ensure();
        return this.base.getMProxy();
    }

    class SetProxyReal
    extends AbstractCollection
    implements SetProxy {
        final MProxy mapProxy;

        public SetProxyReal() {
            this.mapProxy = new MProxyImpl(SetProxyImpl.this.name, SetProxyImpl.this.factory);
        }

        public Object getId() {
            return SetProxyImpl.this.name;
        }

        public boolean equals(Object o) {
            return SetProxyImpl.this.equals(o);
        }

        public int hashCode() {
            return SetProxyImpl.this.hashCode();
        }

        public Instance.InstanceType getInstanceType() {
            return BaseManager.getInstanceType(SetProxyImpl.this.name);
        }

        public void addItemListener(ItemListener listener, boolean includeValue) {
            this.mapProxy.addGenericListener(listener, null, includeValue, this.getInstanceType());
        }

        public void removeItemListener(ItemListener listener) {
            this.mapProxy.removeGenericListener(listener, null);
        }

        public String getName() {
            return SetProxyImpl.this.getName();
        }

        public boolean add(Object obj) {
            return this.mapProxy.add(obj);
        }

        public boolean remove(Object obj) {
            return this.mapProxy.removeKey(obj);
        }

        public boolean contains(Object obj) {
            return this.mapProxy.containsKey(obj);
        }

        public Iterator iterator() {
            return this.mapProxy.keySet().iterator();
        }

        public int size() {
            return this.mapProxy.size();
        }

        public void clear() {
            this.mapProxy.clear();
        }

        public void destroy() {
            SetProxyImpl.this.factory.destroyInstanceClusterWide(SetProxyImpl.this.name, null);
        }

        public MProxy getMProxy() {
            return this.mapProxy;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        }
    }
}

