/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AsymmetricEncryptionConfig;
import com.hazelcast.config.Interfaces;
import com.hazelcast.config.Join;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.ByteUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class NetworkConfig
implements DataSerializable {
    private Interfaces interfaces = new Interfaces();
    private Join join = new Join();
    private SymmetricEncryptionConfig symmetricEncryptionConfig = null;
    private AsymmetricEncryptionConfig asymmetricEncryptionConfig = null;
    private SocketInterceptorConfig socketInterceptorConfig = null;
    private SSLConfig sslConfig = null;

    public Interfaces getInterfaces() {
        return this.interfaces;
    }

    public NetworkConfig setInterfaces(Interfaces interfaces) {
        this.interfaces = interfaces;
        return this;
    }

    public Join getJoin() {
        return this.join;
    }

    public NetworkConfig setJoin(Join join) {
        this.join = join;
        return this;
    }

    public NetworkConfig setSocketInterceptorConfig(SocketInterceptorConfig socketInterceptorConfig) {
        this.socketInterceptorConfig = socketInterceptorConfig;
        return this;
    }

    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.socketInterceptorConfig;
    }

    public SymmetricEncryptionConfig getSymmetricEncryptionConfig() {
        return this.symmetricEncryptionConfig;
    }

    public NetworkConfig setSymmetricEncryptionConfig(SymmetricEncryptionConfig symmetricEncryptionConfig) {
        this.symmetricEncryptionConfig = symmetricEncryptionConfig;
        return this;
    }

    public AsymmetricEncryptionConfig getAsymmetricEncryptionConfig() {
        return this.asymmetricEncryptionConfig;
    }

    public NetworkConfig setAsymmetricEncryptionConfig(AsymmetricEncryptionConfig asymmetricEncryptionConfig) {
        this.asymmetricEncryptionConfig = asymmetricEncryptionConfig;
        return this;
    }

    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public NetworkConfig setSSLConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    public void writeData(DataOutput out) throws IOException {
        this.interfaces.writeData(out);
        this.join.writeData(out);
        boolean hasSymmetricEncryptionConfig = this.symmetricEncryptionConfig != null;
        boolean hasAsymmetricEncryptionConfig = this.asymmetricEncryptionConfig != null;
        out.writeByte(ByteUtil.toByte(hasSymmetricEncryptionConfig, hasAsymmetricEncryptionConfig));
        if (hasSymmetricEncryptionConfig) {
            this.symmetricEncryptionConfig.writeData(out);
        }
        if (hasAsymmetricEncryptionConfig) {
            this.asymmetricEncryptionConfig.writeData(out);
        }
    }

    public void readData(DataInput in) throws IOException {
        this.interfaces = new Interfaces();
        this.interfaces.readData(in);
        this.join = new Join();
        this.join.readData(in);
        boolean[] b = ByteUtil.fromByte(in.readByte());
        boolean hasSymmetricEncryptionConfig = b[0];
        boolean hasAsymmetricEncryptionConfig = b[1];
        if (hasSymmetricEncryptionConfig) {
            this.symmetricEncryptionConfig = new SymmetricEncryptionConfig();
            this.symmetricEncryptionConfig.readData(in);
        }
        if (hasAsymmetricEncryptionConfig) {
            this.asymmetricEncryptionConfig = new AsymmetricEncryptionConfig();
            this.asymmetricEncryptionConfig.readData(in);
        }
    }

    public String toString() {
        return "NetworkConfig [join=" + this.join + ", interfaces=" + this.interfaces + ", symmetricEncryptionConfig=" + this.symmetricEncryptionConfig + ", asymmetricEncryptionConfig=" + this.asymmetricEncryptionConfig + "]";
    }
}

