/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IOUtil;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.DataAwareItemEvent;
import com.hazelcast.nio.Data;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class QueueItemListenerManager {
    private final ConcurrentHashMap<String, List<ItemListenerHolder>> queueItemListeners = new ConcurrentHashMap();

    public Collection<? extends Call> calls(HazelcastClient client) {
        ArrayList<Call> calls = new ArrayList<Call>();
        for (String name : this.queueItemListeners.keySet()) {
            ProxyHelper proxyHelper = new ProxyHelper(name, client);
            calls.add(this.createNewAddItemListenerCall(proxyHelper, true));
        }
        return calls;
    }

    public Call createNewAddItemListenerCall(ProxyHelper proxyHelper, boolean includeValue) {
        Packet request = proxyHelper.createRequestPacket(ClusterOperation.ADD_LISTENER, null, null);
        request.setLongValue(includeValue ? 1L : 0L);
        return proxyHelper.createCall(request);
    }

    public void notifyListeners(Packet packet) {
        List<ItemListenerHolder> list = this.queueItemListeners.get(packet.getName());
        if (list != null) {
            for (ItemListenerHolder listenerHolder : list) {
                ItemListener listener = listenerHolder.listener;
                Boolean added = (Boolean)IOUtil.toObject(packet.getValue());
                if (added.booleanValue()) {
                    listener.itemAdded(new DataAwareItemEvent(packet.getName(), ItemEventType.ADDED, listenerHolder.includeValue ? new Data(packet.getKey()) : null));
                    continue;
                }
                listener.itemRemoved(new DataAwareItemEvent(packet.getName(), ItemEventType.REMOVED, listenerHolder.includeValue ? new Data(packet.getKey()) : null));
            }
        }
    }

    public <E> void removeListener(String name, ItemListener<E> listener) {
        if (!this.queueItemListeners.containsKey(name)) {
            return;
        }
        this.queueItemListeners.get(name).remove(listener);
        if (this.queueItemListeners.get(name).isEmpty()) {
            this.queueItemListeners.remove(name);
        }
    }

    public <E> void registerListener(String name, ItemListener<E> listener, boolean includeValue) {
        CopyOnWriteArrayList<ItemListenerHolder> newListenersList = new CopyOnWriteArrayList<ItemListenerHolder>();
        CopyOnWriteArrayList<ItemListenerHolder> listeners = this.queueItemListeners.putIfAbsent(name, newListenersList);
        if (listeners == null) {
            listeners = newListenersList;
        }
        listeners.add(new ItemListenerHolder(listener, includeValue));
    }

    public boolean noListenerRegistered(String name) {
        if (!this.queueItemListeners.containsKey(name)) {
            return true;
        }
        return this.queueItemListeners.get(name).isEmpty();
    }

    private static class ItemListenerHolder {
        private final ItemListener listener;
        private boolean includeValue;

        public ItemListenerHolder(ItemListener listener, boolean includeValue) {
            this.listener = listener;
            this.includeValue = includeValue;
        }
    }
}

