/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.nio.Address;
import java.io.Serializable;

public class DistributedLock
implements Serializable {
    Address lockAddress = null;
    int lockThreadId = -1;
    int lockCount;

    public DistributedLock() {
    }

    public DistributedLock(DistributedLock copy) {
        this.lockAddress = copy.lockAddress;
        this.lockCount = copy.lockCount;
        this.lockThreadId = copy.lockThreadId;
    }

    public DistributedLock(Address address, int threadId) {
        this.lockAddress = address;
        this.lockThreadId = threadId;
        this.lockCount = 1;
    }

    public DistributedLock(Address lockAddress, int lockThreadId, int lockCount) {
        this.lockAddress = lockAddress;
        this.lockThreadId = lockThreadId;
        this.lockCount = lockCount;
    }

    public boolean isLocked() {
        return this.lockCount > 0;
    }

    public boolean isLockedBy(Address address, int threadId) {
        return this.lockThreadId == threadId && address != null && address.equals(this.lockAddress);
    }

    public boolean lock(Address address, int threadId) {
        if (this.lockCount == 0) {
            this.lockAddress = address;
            this.lockThreadId = threadId;
            this.lockCount = 1;
            return true;
        }
        if (this.isLockedBy(address, threadId)) {
            this.lockCount = 1;
            return true;
        }
        return false;
    }

    public boolean unlock(Address address, int threadId) {
        if (this.lockCount == 0) {
            return false;
        }
        if (this.isLockedBy(address, threadId)) {
            --this.lockCount;
            if (this.lockCount == 0) {
                this.lockAddress = null;
                this.lockThreadId = -1;
            }
            return true;
        }
        return false;
    }

    public boolean testLock(int threadId, Address address) {
        return this.lockCount == 0 || this.getLockThreadId() == threadId && this.getLockAddress().equals(address);
    }

    public void clear() {
        this.lockThreadId = -1;
        this.lockCount = 0;
        this.lockAddress = null;
    }

    public Address getLockAddress() {
        return this.lockAddress;
    }

    public int getLockThreadId() {
        return this.lockThreadId;
    }

    public int getLockCount() {
        return this.lockCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributedLock that = (DistributedLock)o;
        if (this.lockCount != that.lockCount) {
            return false;
        }
        if (this.lockThreadId != that.lockThreadId) {
            return false;
        }
        return !(this.lockAddress != null ? !this.lockAddress.equals(that.lockAddress) : that.lockAddress != null);
    }

    public int hashCode() {
        int result = this.lockAddress != null ? this.lockAddress.hashCode() : 0;
        result = 31 * result + this.lockThreadId;
        result = 31 * result + this.lockCount;
        return result;
    }

    public String toString() {
        return "Lock{lockAddress=" + this.lockAddress + ", lockThreadId=" + this.lockThreadId + ", lockCount=" + this.lockCount + '}';
    }
}

