/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.SocketChannelWrapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class SocketConnector
implements Runnable {
    private final ConnectionManager connectionManager;
    private final Address address;
    private final ILogger logger;
    private final boolean silent;

    public SocketConnector(ConnectionManager connectionManager, Address address, boolean silent) {
        this.connectionManager = connectionManager;
        this.address = address;
        this.silent = silent;
        this.logger = connectionManager.ioService.getLogger(this.getClass().getName());
    }

    public void run() {
        SocketChannel socketChannel = null;
        try {
            this.connectionManager.ioService.onIOThreadStart();
            socketChannel = SocketChannel.open();
            Address thisAddress = this.connectionManager.ioService.getThisAddress();
            socketChannel.socket().bind(new InetSocketAddress(thisAddress.getInetAddress(), 0));
            this.logger.log(Level.FINEST, "connecting to " + this.address);
            boolean connected = socketChannel.connect(new InetSocketAddress(this.address.getInetAddress(), this.address.getPort()));
            this.logger.log(Level.FINEST, "connection check. connected: " + connected + ", " + this.address);
            MemberSocketInterceptor memberSocketInterceptor = this.connectionManager.getMemberSocketInterceptor();
            if (memberSocketInterceptor != null) {
                memberSocketInterceptor.onConnect(socketChannel.socket());
            }
            socketChannel.configureBlocking(false);
            this.logger.log(Level.FINEST, "connected to " + this.address);
            SocketChannelWrapper socketChannelWrapper = this.connectionManager.wrapSocketChannel(socketChannel, true);
            Connection connection = this.connectionManager.assignSocketChannel(socketChannelWrapper);
            this.connectionManager.bind(this.address, connection, false);
        }
        catch (Throwable e) {
            this.logger.log(Level.FINEST, e.getMessage(), e);
            if (socketChannel != null) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.connectionManager.failedConnection(this.address, e, this.silent);
        }
    }
}

