/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor;

import com.hazelcast.impl.monitor.MemberStateImpl;
import com.hazelcast.monitor.MemberState;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedMemberState
implements DataSerializable {
    long time;
    MemberState memberState = null;
    Set<String> instanceNames = null;
    List<String> memberList;
    Boolean master;
    String clusterName;

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeLong(this.time);
        out.writeBoolean(this.master);
        this.memberState.writeData(out);
        out.writeUTF(this.clusterName);
        int nameCount = this.instanceNames == null ? 0 : this.instanceNames.size();
        out.writeInt(nameCount);
        if (this.instanceNames != null) {
            for (String name : this.instanceNames) {
                out.writeUTF(name);
            }
        }
        int memberCount = this.memberList == null ? 0 : this.memberList.size();
        out.writeInt(memberCount);
        if (this.memberList != null) {
            for (String address : this.memberList) {
                out.writeUTF(address);
            }
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.time = in.readLong();
        this.master = in.readBoolean();
        this.memberState = new MemberStateImpl();
        this.memberState.readData(in);
        this.clusterName = in.readUTF();
        int nameCount = in.readInt();
        this.instanceNames = new HashSet<String>(nameCount);
        for (int i = 0; i < nameCount; ++i) {
            this.instanceNames.add(in.readUTF());
        }
        int memberCount = in.readInt();
        this.memberList = new ArrayList<String>();
        for (int i = 0; i < memberCount; ++i) {
            this.memberList.add(in.readUTF());
        }
    }

    public List<String> getMemberList() {
        return this.memberList;
    }

    public void setMemberList(List<String> memberList) {
        this.memberList = memberList;
    }

    public Boolean getMaster() {
        return this.master;
    }

    public void setMaster(Boolean master) {
        this.master = master;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public Set<String> getInstanceNames() {
        return this.instanceNames;
    }

    public void setInstanceNames(Set<String> longInstanceNames) {
        this.instanceNames = longInstanceNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TimedMemberState{\n");
        sb.append("\t");
        sb.append(this.memberState);
        sb.append("\n");
        sb.append("}\n");
        sb.append("Instances : ");
        sb.append(this.instanceNames);
        return sb.toString();
    }

    public MemberState getMemberState() {
        return this.memberState;
    }

    public void setMemberState(MemberState memberState) {
        this.memberState = memberState;
    }
}

