/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MultiTask;
import com.hazelcast.impl.AtomicNumberProxy;
import com.hazelcast.impl.CountDownLatchProxy;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.HazelcastInstanceAwareInstance;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.QProxy;
import com.hazelcast.impl.SemaphoreProxy;
import com.hazelcast.impl.TopicProxy;
import com.hazelcast.impl.management.ConsoleCommandHandler;
import com.hazelcast.impl.management.ConsoleCommandRequest;
import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.DetectDeadlockRequest;
import com.hazelcast.impl.management.EvictLocalMapRequest;
import com.hazelcast.impl.management.ExecuteScriptRequest;
import com.hazelcast.impl.management.GetClusterStateRequest;
import com.hazelcast.impl.management.LockInformationCallable;
import com.hazelcast.impl.management.LoginRequest;
import com.hazelcast.impl.management.MapConfigRequest;
import com.hazelcast.impl.management.ThreadDumpRequest;
import com.hazelcast.impl.monitor.LocalAtomicNumberStatsImpl;
import com.hazelcast.impl.monitor.LocalCountDownLatchStatsImpl;
import com.hazelcast.impl.monitor.LocalMapStatsImpl;
import com.hazelcast.impl.monitor.LocalQueueStatsImpl;
import com.hazelcast.impl.monitor.LocalSemaphoreStatsImpl;
import com.hazelcast.impl.monitor.LocalTopicStatsImpl;
import com.hazelcast.impl.monitor.MemberStateImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.monitor.MemberState;
import com.hazelcast.monitor.TimedClusterState;
import com.hazelcast.monitor.TimedMemberState;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.PipedZipBufferFactory;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementCenterService
implements MembershipListener,
LifecycleListener {
    private static final int DATAGRAM_BUFFER_SIZE = 65536;
    private final Queue<ClientHandler> qClientHandlers = new LinkedBlockingQueue<ClientHandler>(100);
    private final FactoryImpl factory;
    private volatile boolean running = true;
    private DatagramSocket datagramSocket;
    private SocketReadyServerSocket serverSocket;
    private UDPListener udpListener;
    private UDPSender udpSender;
    private TCPListener tcpListener;
    private TaskPoller taskPoller;
    private StateSender stateSender;
    private final List<ClientHandler> lsClientHandlers = new CopyOnWriteArrayList<ClientHandler>();
    private final ILogger logger;
    private final ConcurrentMap<Address, MemberState> memberStates = new ConcurrentHashMap<Address, MemberState>(1000);
    private final ConcurrentMap<Address, SocketAddress> socketAddresses = new ConcurrentHashMap<Address, SocketAddress>(1000);
    private final Set<Address> addresses = new CopyOnWriteArraySet<Address>();
    private volatile MemberStateImpl latestThisMemberState = null;
    private final Address thisAddress;
    private final ConsoleCommandHandler commandHandler;
    private final StatsInstanceFilter instanceFilterMap;
    private final StatsInstanceFilter instanceFilterQueue;
    private final StatsInstanceFilter instanceFilterTopic;
    private final StatsInstanceFilter instanceFilterAtomicNumber;
    private final StatsInstanceFilter instanceFilterCountDownLatch;
    private final StatsInstanceFilter instanceFilterSemaphore;
    private final int maxVisibleInstanceCount;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final String webServerUrl;
    private final int updateIntervalMs;

    public ManagementCenterService(FactoryImpl factoryImpl) throws Exception {
        String tmpWebServerUrl;
        this.factory = factoryImpl;
        ManagementCenterConfig config = this.factory.node.config.getManagementCenterConfig();
        this.instanceFilterMap = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_MAP_EXCLUDES.getString());
        this.instanceFilterQueue = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_QUEUE_EXCLUDES.getString());
        this.instanceFilterTopic = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_TOPIC_EXCLUDES.getString());
        this.instanceFilterAtomicNumber = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_ATOMIC_NUMBER_EXCLUDES.getString());
        this.instanceFilterCountDownLatch = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_COUNT_DOWN_LATCH_EXCLUDES.getString());
        this.instanceFilterSemaphore = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_SEMAPHORE_EXCLUDES.getString());
        this.updateMemberOrder();
        this.logger = this.factory.node.getLogger(ManagementCenterService.class.getName());
        this.maxVisibleInstanceCount = this.factory.node.groupProperties.MC_MAX_INSTANCE_COUNT.getInteger();
        this.commandHandler = new ConsoleCommandHandler(this.factory);
        String string = tmpWebServerUrl = config != null ? config.getUrl() : null;
        this.webServerUrl = tmpWebServerUrl != null ? (!tmpWebServerUrl.endsWith("/") ? tmpWebServerUrl + '/' : tmpWebServerUrl) : tmpWebServerUrl;
        this.updateIntervalMs = config != null && config.getUpdateInterval() > 0 ? config.getUpdateInterval() * 1000 : 4000;
        this.factory.getCluster().addMembershipListener(this);
        this.factory.getLifecycleService().addLifecycleListener(this);
        MemberImpl memberLocal = (MemberImpl)this.factory.getCluster().getLocalMember();
        this.thisAddress = memberLocal.getAddress();
        if (this.factory.node.groupProperties.MANCENTER_ENABLED.getBoolean()) {
            int port = this.calculatePort(this.thisAddress);
            this.datagramSocket = new DatagramSocket(port);
            this.serverSocket = new SocketReadyServerSocket(port, 1000, this.factory.node.config.isReuseAddress());
            this.udpListener = new UDPListener(this.datagramSocket, 1000, this.factory.node.config.isReuseAddress());
            this.udpSender = new UDPSender(this.datagramSocket);
            this.tcpListener = new TCPListener(this.serverSocket);
            for (int i = 0; i < 100; ++i) {
                this.qClientHandlers.offer(new ClientHandler(i));
            }
            this.udpSender.start();
            this.tcpListener.start();
            this.udpListener.start();
            this.logger.log(Level.INFO, "Hazelcast Management Center started at port " + port + ".");
        }
        if (config != null && config.isEnabled()) {
            if (config.getUrl() != null) {
                this.taskPoller = new TaskPoller();
                this.stateSender = new StateSender();
                this.taskPoller.start();
                this.stateSender.start();
                this.logger.log(Level.INFO, "Hazelcast Management Center is listening from " + config.getUrl());
            } else {
                this.logger.log(Level.WARNING, "Hazelcast Management Center Web server url is null!");
            }
        }
        this.running = true;
    }

    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.logger.log(Level.INFO, "Shutting down Hazelcast Management Center");
        this.running = false;
        try {
            if (this.datagramSocket != null) {
                this.datagramSocket.close();
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        try {
            this.interruptThread(this.udpSender);
            this.interruptThread(this.stateSender);
            this.interruptThread(this.taskPoller);
            for (ClientHandler clientHandler : this.lsClientHandlers) {
                clientHandler.shutdown();
            }
            this.lsClientHandlers.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void interruptThread(Thread t) {
        if (t != null) {
            t.interrupt();
        }
    }

    @Override
    public void memberAdded(MembershipEvent membershipEvent) {
        this.updateMemberOrder();
    }

    @Override
    public void memberRemoved(MembershipEvent membershipEvent) {
        Address address = ((MemberImpl)membershipEvent.getMember()).getAddress();
        this.memberStates.remove(address);
        this.socketAddresses.remove(address);
        this.addresses.remove(address);
    }

    private void updateMemberOrder() {
        block6: {
            try {
                Set<Member> memberSet = this.factory.getCluster().getMembers();
                for (Member member : memberSet) {
                    MemberImpl memberImpl = (MemberImpl)member;
                    Address address = memberImpl.getAddress();
                    try {
                        if (!this.socketAddresses.containsKey(address)) {
                            InetSocketAddress socketAddress = new InetSocketAddress(address.getInetAddress(), this.calculatePort(address));
                            this.socketAddresses.putIfAbsent(address, socketAddress);
                        }
                        this.addresses.add(address);
                    }
                    catch (UnknownHostException e) {
                        this.logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
            catch (Throwable e) {
                if (!this.running || !this.factory.node.isActive()) break block6;
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private int calculatePort(Address address) {
        int port = address.getPort() - this.factory.node.config.getPort() + this.factory.node.getGroupProperties().MC_PORT.getInteger();
        return port;
    }

    boolean login(String groupName, String password) {
        this.logger.log(Level.INFO, "Management Center Client is trying to login.");
        GroupConfig groupConfig = this.factory.getConfig().getGroupConfig();
        return groupConfig.getName().equals(groupName) && groupConfig.getPassword().equals(password);
    }

    List<DetectDeadlockRequest.Edge> detectDeadlock() {
        Collection collection = this.callOnAllMembers(new LockInformationCallable());
        ArrayList<DetectDeadlockRequest.Vertex> graph = new ArrayList<DetectDeadlockRequest.Vertex>();
        for (Map mapLockStateMap : collection) {
            for (LockInformationCallable.MapLockState map : mapLockStateMap.values()) {
                for (Object key : map.getLockOwners().keySet()) {
                    DetectDeadlockRequest.Vertex owner = new DetectDeadlockRequest.Vertex(map.getLockOwners().get(key));
                    DetectDeadlockRequest.Vertex requester = new DetectDeadlockRequest.Vertex(map.getLockRequested().get(key));
                    int index = graph.indexOf(owner);
                    if (index >= 0) {
                        owner = (DetectDeadlockRequest.Vertex)graph.get(index);
                    } else {
                        graph.add(owner);
                    }
                    index = graph.indexOf(requester);
                    if (index >= 0) {
                        requester = (DetectDeadlockRequest.Vertex)graph.get(index);
                    } else {
                        graph.add(requester);
                    }
                    DetectDeadlockRequest.Edge edge = new DetectDeadlockRequest.Edge();
                    edge.from = requester;
                    edge.to = owner;
                    edge.key = key;
                    edge.mapName = map.getMapName();
                    edge.globalLock = map.isGlobalLock();
                    owner.addIncoming(edge);
                    requester.addOutgoing(edge);
                }
            }
        }
        ArrayList<DetectDeadlockRequest.Edge> list = new ArrayList<DetectDeadlockRequest.Edge>();
        if (graph != null && graph.size() > 0) {
            try {
                ((DetectDeadlockRequest.Vertex)graph.get(0)).visit(list);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return list;
    }

    private void updateLocalState() {
        if (this.started.get()) {
            this.latestThisMemberState = this.createMemberState();
            this.memberStates.put(this.latestThisMemberState.getAddress(), this.latestThisMemberState);
        }
    }

    private MemberStateImpl createMemberState() {
        if (this.started.get()) {
            MemberStateImpl memberState = new MemberStateImpl();
            this.createMemberState(memberState);
            return memberState;
        }
        return null;
    }

    private void createMemberState(MemberStateImpl memberState) {
        Node node = this.factory.node;
        memberState.setAddress(this.thisAddress);
        memberState.getMemberHealthStats().setOutOfMemory(node.isOutOfMemory());
        memberState.getMemberHealthStats().setActive(node.isActive());
        memberState.getMemberHealthStats().setServiceThreadStats(node.getCpuUtilization().serviceThread);
        memberState.getMemberHealthStats().setOutThreadStats(node.getCpuUtilization().outThread);
        memberState.getMemberHealthStats().setInThreadStats(node.getCpuUtilization().inThread);
        PartitionService partitionService = this.factory.getPartitionService();
        Set<Partition> partitions = partitionService.getPartitions();
        memberState.clearPartitions();
        for (Partition partition : partitions) {
            if (partition.getOwner() == null || !partition.getOwner().localMember()) continue;
            memberState.addPartition(partition.getPartitionId());
        }
        ArrayList<HazelcastInstanceAwareInstance> proxyObjects = new ArrayList<HazelcastInstanceAwareInstance>(this.factory.getProxies());
        this.createMemState(memberState, proxyObjects.iterator(), Instance.InstanceType.MAP);
        this.createMemState(memberState, proxyObjects.iterator(), Instance.InstanceType.QUEUE);
        this.createMemState(memberState, proxyObjects.iterator(), Instance.InstanceType.TOPIC);
        this.createRuntimeProps(memberState);
    }

    private void createRuntimeProps(MemberStateImpl memberState) {
        Runtime runtime = Runtime.getRuntime();
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        ClassLoadingMXBean clMxBean = ManagementFactory.getClassLoadingMXBean();
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemory = memoryMxBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemory = memoryMxBean.getNonHeapMemoryUsage();
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("runtime.availableProcessors", Integer.valueOf(runtime.availableProcessors()).longValue());
        map.put("date.startTime", runtimeMxBean.getStartTime());
        map.put("seconds.upTime", runtimeMxBean.getUptime());
        map.put("memory.maxMemory", runtime.maxMemory());
        map.put("memory.freeMemory", runtime.freeMemory());
        map.put("memory.totalMemory", runtime.totalMemory());
        map.put("memory.heapMemoryMax", heapMemory.getMax());
        map.put("memory.heapMemoryUsed", heapMemory.getUsed());
        map.put("memory.nonHeapMemoryMax", nonHeapMemory.getMax());
        map.put("memory.nonHeapMemoryUsed", nonHeapMemory.getUsed());
        map.put("runtime.totalLoadedClassCount", clMxBean.getTotalLoadedClassCount());
        map.put("runtime.loadedClassCount", Integer.valueOf(clMxBean.getLoadedClassCount()).longValue());
        map.put("runtime.unloadedClassCount", clMxBean.getUnloadedClassCount());
        map.put("runtime.totalStartedThreadCount", threadMxBean.getTotalStartedThreadCount());
        map.put("runtime.threadCount", Integer.valueOf(threadMxBean.getThreadCount()).longValue());
        map.put("runtime.peakThreadCount", Integer.valueOf(threadMxBean.getPeakThreadCount()).longValue());
        map.put("runtime.daemonThreadCount", Integer.valueOf(threadMxBean.getDaemonThreadCount()).longValue());
        memberState.setRuntimeProps(map);
    }

    private void createMemState(MemberStateImpl memberState, Iterator<HazelcastInstanceAwareInstance> it, Instance.InstanceType type) {
        int count = 0;
        while (it.hasNext()) {
            HazelcastInstanceAwareInstance proxyObject = it.next();
            if (proxyObject.getInstanceType() != type) continue;
            if (count < this.maxVisibleInstanceCount) {
                SemaphoreProxy semaphoreProxy;
                if (type.isMap()) {
                    MProxy mapProxy = (MProxy)proxyObject;
                    if (this.instanceFilterMap.visible(mapProxy.getName())) {
                        memberState.putLocalMapStats(mapProxy.getName(), (LocalMapStatsImpl)mapProxy.getLocalMapStats());
                        ++count;
                    }
                } else if (type.isQueue()) {
                    QProxy qProxy = (QProxy)proxyObject;
                    if (this.instanceFilterQueue.visible(qProxy.getName())) {
                        memberState.putLocalQueueStats(qProxy.getName(), (LocalQueueStatsImpl)qProxy.getLocalQueueStats());
                        ++count;
                    }
                } else if (type.isTopic()) {
                    TopicProxy topicProxy = (TopicProxy)proxyObject;
                    if (this.instanceFilterTopic.visible(topicProxy.getName())) {
                        memberState.putLocalTopicStats(topicProxy.getName(), (LocalTopicStatsImpl)topicProxy.getLocalTopicStats());
                        ++count;
                    }
                } else if (type.isAtomicNumber()) {
                    AtomicNumberProxy atomicLongProxy = (AtomicNumberProxy)proxyObject;
                    if (this.instanceFilterAtomicNumber.visible(atomicLongProxy.getName())) {
                        memberState.putLocalAtomicNumberStats(atomicLongProxy.getName(), (LocalAtomicNumberStatsImpl)atomicLongProxy.getLocalAtomicNumberStats());
                        ++count;
                    }
                } else if (type.isCountDownLatch()) {
                    CountDownLatchProxy cdlProxy = (CountDownLatchProxy)proxyObject;
                    if (this.instanceFilterCountDownLatch.visible(cdlProxy.getName())) {
                        memberState.putLocalCountDownLatchStats(cdlProxy.getName(), (LocalCountDownLatchStatsImpl)cdlProxy.getLocalCountDownLatchStats());
                        ++count;
                    }
                } else if (type.isSemaphore() && this.instanceFilterSemaphore.visible((semaphoreProxy = (SemaphoreProxy)proxyObject).getName())) {
                    memberState.putLocalSemaphoreStats(semaphoreProxy.getName(), (LocalSemaphoreStatsImpl)semaphoreProxy.getLocalSemaphoreStats());
                    ++count;
                }
            }
            it.remove();
        }
    }

    private Set<String> getLongInstanceNames() {
        HashSet<String> setLongInstanceNames = new HashSet<String>(this.maxVisibleInstanceCount);
        ArrayList<HazelcastInstanceAwareInstance> proxyObjects = new ArrayList<HazelcastInstanceAwareInstance>(this.factory.getProxies());
        this.collectInstanceNames(setLongInstanceNames, proxyObjects.iterator(), Instance.InstanceType.MAP);
        this.collectInstanceNames(setLongInstanceNames, proxyObjects.iterator(), Instance.InstanceType.QUEUE);
        this.collectInstanceNames(setLongInstanceNames, proxyObjects.iterator(), Instance.InstanceType.TOPIC);
        return setLongInstanceNames;
    }

    private void collectInstanceNames(Set<String> setLongInstanceNames, Iterator<HazelcastInstanceAwareInstance> it, Instance.InstanceType type) {
        int count = 0;
        while (it.hasNext()) {
            HazelcastInstanceAwareInstance proxyObject = it.next();
            if (proxyObject.getInstanceType() != type) continue;
            if (count < this.maxVisibleInstanceCount) {
                SemaphoreProxy semaphoreProxy;
                if (type.isMap()) {
                    MProxy mapProxy = (MProxy)proxyObject;
                    if (this.instanceFilterMap.visible(mapProxy.getName())) {
                        setLongInstanceNames.add(mapProxy.getLongName());
                        ++count;
                    }
                } else if (type.isQueue()) {
                    QProxy qProxy = (QProxy)proxyObject;
                    if (this.instanceFilterQueue.visible(qProxy.getName())) {
                        setLongInstanceNames.add(qProxy.getLongName());
                        ++count;
                    }
                } else if (type.isTopic()) {
                    TopicProxy topicProxy = (TopicProxy)proxyObject;
                    if (this.instanceFilterTopic.visible(topicProxy.getName())) {
                        setLongInstanceNames.add(topicProxy.getLongName());
                        ++count;
                    }
                } else if (type.isAtomicNumber()) {
                    AtomicNumberProxy atomicLongProxy = (AtomicNumberProxy)proxyObject;
                    if (this.instanceFilterAtomicNumber.visible(atomicLongProxy.getName())) {
                        setLongInstanceNames.add(atomicLongProxy.getLongName());
                        ++count;
                    }
                } else if (type.isCountDownLatch()) {
                    CountDownLatchProxy cdlProxy = (CountDownLatchProxy)proxyObject;
                    if (this.instanceFilterCountDownLatch.visible(cdlProxy.getName())) {
                        setLongInstanceNames.add(cdlProxy.getLongName());
                        ++count;
                    }
                } else if (type.isSemaphore() && this.instanceFilterSemaphore.visible((semaphoreProxy = (SemaphoreProxy)proxyObject).getName())) {
                    setLongInstanceNames.add(semaphoreProxy.getLongName());
                    ++count;
                }
            }
            it.remove();
        }
    }

    Object call(Address address, Callable callable) {
        Set<Member> members = this.factory.getCluster().getMembers();
        for (Member member : members) {
            if (!address.equals(((MemberImpl)member).getAddress())) continue;
            DistributedTask task = new DistributedTask(callable, member);
            return this.executeTaskAndGet(task);
        }
        return null;
    }

    Object call(Callable callable) {
        DistributedTask task = new DistributedTask(callable);
        return this.executeTaskAndGet(task);
    }

    Collection callOnMembers(Set<Address> addresses, Callable callable) {
        Set<Member> allMembers = this.factory.getCluster().getMembers();
        HashSet<Member> selectedMembers = new HashSet<Member>(addresses.size());
        for (Member member : allMembers) {
            if (!addresses.contains(((MemberImpl)member).getAddress())) continue;
            selectedMembers.add(member);
        }
        return this.callOnMembers0(selectedMembers, callable);
    }

    Collection callOnAllMembers(Callable callable) {
        Set<Member> members = this.factory.getCluster().getMembers();
        return this.callOnMembers0(members, callable);
    }

    private Collection callOnMembers0(Set<Member> members, Callable callable) {
        MultiTask task = new MultiTask(callable, members);
        return (Collection)this.executeTaskAndGet(task);
    }

    private Object executeTaskAndGet(DistributedTask task) {
        try {
            this.factory.getExecutorService().execute(task);
            try {
                return task.get(3L, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                this.logger.log(Level.FINEST, e.getMessage(), e);
                return null;
            }
        }
        catch (Throwable e) {
            if (this.running && this.factory.node.isActive()) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
            return null;
        }
    }

    public TimedMemberState getTimedMemberState() {
        if (this.latestThisMemberState == null) {
            this.updateLocalState();
        }
        GroupConfig groupConfig = this.factory.getConfig().getGroupConfig();
        TimedMemberState timedMemberState = new TimedMemberState();
        timedMemberState.setMaster(this.factory.node.isMaster());
        if (timedMemberState.getMaster().booleanValue()) {
            timedMemberState.setMemberList(new ArrayList<String>());
            for (Address addr : this.addresses) {
                timedMemberState.getMemberList().add(addr.getHost() + ":" + addr.getPort());
            }
        }
        timedMemberState.setMemberState(this.latestThisMemberState);
        timedMemberState.setClusterName(groupConfig.getName());
        timedMemberState.setInstanceNames(this.getLongInstanceNames());
        return timedMemberState;
    }

    TimedClusterState getState() {
        if (this.latestThisMemberState == null) {
            this.updateLocalState();
        }
        TimedClusterState timedClusterState = new TimedClusterState();
        for (Address address : this.addresses) {
            MemberState memberState = (MemberState)this.memberStates.get(address);
            if (memberState == null) continue;
            timedClusterState.addMemberState(memberState);
        }
        timedClusterState.setInstanceNames(this.getLongInstanceNames());
        return timedClusterState;
    }

    HazelcastInstance getHazelcastInstance() {
        return this.factory;
    }

    ConsoleCommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    @Override
    public void stateChanged(LifecycleEvent event) {
        this.started.set(event.getState() == LifecycleEvent.LifecycleState.STARTED);
        this.logger.log(Level.FINEST, "Hazelcast Management Center enabled: " + this.started.get());
    }

    class StatsInstanceFilter {
        final Set<Pattern> setExcludes;
        final Set<String> setIncludeCache;
        final Set<String> setExcludeCache;

        StatsInstanceFilter(String excludes) {
            if (excludes != null) {
                this.setExcludes = new HashSet<Pattern>();
                this.setIncludeCache = new HashSet<String>();
                this.setExcludeCache = new HashSet<String>();
                StringTokenizer st = new StringTokenizer(excludes, ",");
                while (st.hasMoreTokens()) {
                    this.setExcludes.add(Pattern.compile(st.nextToken().trim()));
                }
            } else {
                this.setExcludes = null;
                this.setIncludeCache = null;
                this.setExcludeCache = null;
            }
        }

        boolean visible(String instanceName) {
            if (this.setExcludes == null) {
                return true;
            }
            if (this.setIncludeCache.contains(instanceName)) {
                return true;
            }
            if (this.setExcludeCache.contains(instanceName)) {
                return false;
            }
            for (Pattern pattern : this.setExcludes) {
                if (!pattern.matcher(instanceName).matches()) continue;
                this.setExcludeCache.add(instanceName);
                return false;
            }
            this.setIncludeCache.add(instanceName);
            return true;
        }
    }

    public static class SocketReadyServerSocket
    extends ServerSocket {
        public SocketReadyServerSocket(int port, int timeout, boolean reuseAddress) throws IOException {
            super(port);
            this.setSoTimeout(timeout);
            this.setReuseAddress(reuseAddress);
        }

        public void doAccept(Socket socket) throws IOException {
            super.implAccept(socket);
        }
    }

    class ClientHandler
    extends Thread {
        final ConsoleRequest[] consoleRequests;
        final Socket socket;
        final LazyDataInputStream socketIn;
        final LazyDataOutputStream socketOut;

        public ClientHandler(int id) {
            super(((ManagementCenterService)ManagementCenterService.this).factory.node.threadGroup, ((ManagementCenterService)ManagementCenterService.this).factory.node.getThreadPoolNamePrefix("MC.Client.Handler") + id);
            this.consoleRequests = new ConsoleRequest[10];
            this.socket = new Socket();
            this.socketIn = new LazyDataInputStream();
            this.socketOut = new LazyDataOutputStream();
            this.register(new LoginRequest());
            this.register(new GetClusterStateRequest());
            this.register(new ThreadDumpRequest());
            this.register(new ExecuteScriptRequest());
            this.register(new EvictLocalMapRequest());
            this.register(new ConsoleCommandRequest());
            this.register(new MapConfigRequest());
            this.register(new DetectDeadlockRequest());
        }

        private void register(ConsoleRequest consoleRequest) {
            this.consoleRequests[consoleRequest.getType()] = consoleRequest;
        }

        public Socket getSocket() {
            return this.socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.socketIn.setInputStream(this.socket.getInputStream());
                this.socketOut.setOutputStream(this.socket.getOutputStream());
                while (ManagementCenterService.this.running) {
                    int requestType = this.socketIn.read();
                    if (requestType == -1) {
                        ManagementCenterService.this.logger.log(Level.WARNING, "Management Center Client connection [" + this.socket.getInetAddress() + "] is closed!");
                        return;
                    }
                    ConsoleRequest consoleRequest = this.consoleRequests[requestType];
                    consoleRequest.readData(this.socketIn);
                    boolean isOutOfMemory = ((ManagementCenterService)ManagementCenterService.this).factory.node.isOutOfMemory();
                    if (isOutOfMemory) {
                        this.socketOut.writeByte(0);
                        continue;
                    }
                    this.socketOut.writeByte(1);
                    consoleRequest.writeResponse(ManagementCenterService.this, this.socketOut);
                }
            }
            catch (Throwable e) {
                if (ManagementCenterService.this.running && ((ManagementCenterService)ManagementCenterService.this).factory.node.isActive()) {
                    ManagementCenterService.this.logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            finally {
                this.shutdown();
            }
        }

        private void shutdown() {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class LazyDataOutputStream
    extends DataOutputStream {
        LazyDataOutputStream() {
            super(null);
        }

        void setOutputStream(OutputStream out) {
            this.out = out;
        }
    }

    class LazyDataInputStream
    extends DataInputStream {
        LazyDataInputStream() {
            super(null);
        }

        void setInputStream(InputStream in) {
            this.in = in;
        }
    }

    private class UDPSender
    extends Thread {
        final DatagramSocket socket;
        final DatagramPacket packet;
        final PipedZipBufferFactory.DeflatingPipedBuffer buffer;

        public UDPSender(DatagramSocket socket) throws SocketException {
            super(((ManagementCenterService)ManagementCenterService.this).factory.node.threadGroup, ((ManagementCenterService)ManagementCenterService.this).factory.node.getThreadNamePrefix("MC.UDP.Sender"));
            this.packet = new DatagramPacket(new byte[0], 0);
            this.buffer = PipedZipBufferFactory.createDeflatingBuffer(65536, 1);
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (ManagementCenterService.this.running) {
                    if (ManagementCenterService.this.started.get()) {
                        ManagementCenterService.this.updateLocalState();
                        this.sendState();
                    }
                    Thread.sleep(5000L);
                }
            }
            catch (Throwable e) {
                if (ManagementCenterService.this.running && ((ManagementCenterService)ManagementCenterService.this).factory.node.isActive()) {
                    ManagementCenterService.this.logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            finally {
                this.buffer.destroy();
                this.packet.setData(new byte[0]);
            }
        }

        private void sendState() {
            boolean preparedStateData = false;
            int compressedCount = 0;
            for (Address address : ManagementCenterService.this.socketAddresses.keySet()) {
                SocketAddress socketAddress;
                if (ManagementCenterService.this.thisAddress.equals(address) || (socketAddress = (SocketAddress)ManagementCenterService.this.socketAddresses.get(address)) == null) continue;
                try {
                    if (!preparedStateData) {
                        compressedCount = this.prepareStateData();
                        preparedStateData = true;
                    }
                    this.packet.setData(this.buffer.getOutputBuffer().array(), 0, compressedCount);
                    this.packet.setSocketAddress(socketAddress);
                    this.socket.send(this.packet);
                }
                catch (IOException e) {
                    if (!ManagementCenterService.this.running || !((ManagementCenterService)ManagementCenterService.this).factory.node.isActive()) continue;
                    ManagementCenterService.this.logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }

        private int prepareStateData() throws IOException {
            MemberStateImpl latestState = ManagementCenterService.this.latestThisMemberState;
            this.buffer.reset();
            if (latestState != null) {
                latestState.writeData(this.buffer.getDataOutput());
                return this.buffer.deflate();
            }
            return 0;
        }
    }

    class UDPListener
    extends Thread {
        final DatagramSocket socket;
        final PipedZipBufferFactory.InflatingPipedBuffer buffer;
        final DatagramPacket packet;

        public UDPListener(DatagramSocket socket, int timeout, boolean reuseAddress) throws SocketException {
            super(((ManagementCenterService)ManagementCenterService.this).factory.node.threadGroup, ((ManagementCenterService)ManagementCenterService.this).factory.node.getThreadNamePrefix("MC.UDP.Listener"));
            this.buffer = PipedZipBufferFactory.createInflatingBuffer(65536);
            this.packet = new DatagramPacket(this.buffer.getInputBuffer().array(), 65536);
            this.socket = socket;
            this.socket.setSoTimeout(timeout);
            this.socket.setReuseAddress(reuseAddress);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (ManagementCenterService.this.running) {
                    try {
                        this.buffer.reset();
                        this.socket.receive(this.packet);
                        this.buffer.inflate(this.packet.getLength());
                        MemberStateImpl memberState = new MemberStateImpl();
                        memberState.readData(this.buffer.getDataInput());
                        ManagementCenterService.this.memberStates.put(memberState.getAddress(), memberState);
                    }
                    catch (SocketTimeoutException ignored) {}
                }
            }
            catch (Throwable e) {
                if (ManagementCenterService.this.running && ((ManagementCenterService)ManagementCenterService.this).factory.node.isActive()) {
                    ManagementCenterService.this.logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            finally {
                this.buffer.destroy();
                this.packet.setData(new byte[0]);
            }
        }
    }

    class TaskPoller
    extends Thread {
        final ConsoleRequest[] consoleRequests;
        final String host;

        TaskPoller() {
            super(((ManagementCenterService)ManagementCenterService.this).factory.node.threadGroup, ((ManagementCenterService)ManagementCenterService.this).factory.node.getThreadNamePrefix("MC.Task.Poller"));
            this.consoleRequests = new ConsoleRequest[10];
            this.host = ManagementCenterService.this.webServerUrl;
            this.register(new LoginRequest());
            this.register(new GetClusterStateRequest());
            this.register(new ThreadDumpRequest());
            this.register(new ExecuteScriptRequest());
            this.register(new EvictLocalMapRequest());
            this.register(new ConsoleCommandRequest());
            this.register(new MapConfigRequest());
        }

        public void register(ConsoleRequest consoleRequest) {
            this.consoleRequests[consoleRequest.getType()] = consoleRequest;
        }

        public void sendResponse(int taskId, ConsoleRequest request) {
            try {
                URL url = new URL(this.host + "putResponse.do");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setConnectTimeout(1000);
                connection.setReadTimeout(1000);
                OutputStream outputStream = connection.getOutputStream();
                DataOutputStream output = new DataOutputStream(outputStream);
                output.writeInt(taskId);
                output.writeInt(request.getType());
                request.writeResponse(ManagementCenterService.this, output);
                connection.getInputStream();
            }
            catch (Exception e) {
                ManagementCenterService.this.logger.log(Level.FINEST, e.getMessage(), e);
            }
        }

        public void run() {
            if (this.host == null) {
                ManagementCenterService.this.logger.log(Level.WARNING, "Web server url is null!");
                return;
            }
            try {
                Random rand = new Random();
                Address address = ((MemberImpl)((ManagementCenterService)ManagementCenterService.this).factory.node.getClusterImpl().getLocalMember()).getAddress();
                GroupConfig groupConfig = ManagementCenterService.this.factory.getConfig().getGroupConfig();
                while (ManagementCenterService.this.running) {
                    try {
                        URL url = new URL(this.host + "getTask.do?member=" + address.getHost() + ":" + address.getPort() + "&cluster=" + groupConfig.getName());
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestProperty("Connection", "keep-alive");
                        InputStream inputStream = connection.getInputStream();
                        DataInputStream input = new DataInputStream(inputStream);
                        int taskId = input.readInt();
                        if (taskId > 0) {
                            int requestType = input.readInt();
                            ConsoleRequest request = this.consoleRequests[requestType];
                            request.readData(input);
                            this.sendResponse(taskId, request);
                        }
                    }
                    catch (Exception e) {
                        ManagementCenterService.this.logger.log(Level.FINEST, e.getMessage(), e);
                    }
                    Thread.sleep(700 + rand.nextInt(300));
                }
            }
            catch (Throwable throwable) {
                ManagementCenterService.this.logger.log(Level.FINEST, "Web Management Center will be closed due to exception.", throwable);
            }
        }
    }

    class StateSender
    extends Thread {
        final String host;

        StateSender() {
            super(((ManagementCenterService)ManagementCenterService.this).factory.node.threadGroup, ((ManagementCenterService)ManagementCenterService.this).factory.node.getThreadNamePrefix("MC.State.Sender"));
            this.host = ManagementCenterService.this.webServerUrl;
        }

        public void run() {
            if (this.host == null) {
                ManagementCenterService.this.logger.log(Level.WARNING, "Web server url is null!");
                return;
            }
            try {
                while (ManagementCenterService.this.running) {
                    if (ManagementCenterService.this.started.get()) {
                        try {
                            URL url = new URL(this.host + "collector.do");
                            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                            connection.setDoOutput(true);
                            connection.setRequestMethod("POST");
                            connection.setConnectTimeout(1000);
                            connection.setReadTimeout(1000);
                            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                            TimedMemberState ts = ManagementCenterService.this.getTimedMemberState();
                            ts.writeData(out);
                            out.flush();
                            connection.getInputStream();
                        }
                        catch (Exception e) {
                            ManagementCenterService.this.logger.log(Level.FINEST, e.getMessage(), e);
                        }
                    }
                    Thread.sleep(ManagementCenterService.this.updateIntervalMs);
                }
            }
            catch (Throwable throwable) {
                ManagementCenterService.this.logger.log(Level.FINEST, "Web Management Center will be closed due to exception.", throwable);
                ManagementCenterService.this.shutdown();
            }
        }
    }

    class TCPListener
    extends Thread {
        final SocketReadyServerSocket serverSocket;

        TCPListener(SocketReadyServerSocket serverSocket) {
            super(((ManagementCenterService)ManagementCenterService.this).factory.node.threadGroup, ((ManagementCenterService)ManagementCenterService.this).factory.node.getThreadNamePrefix("MC.TCP.Listener"));
            this.serverSocket = serverSocket;
        }

        public void run() {
            try {
                while (ManagementCenterService.this.running) {
                    ClientHandler clientHandler = (ClientHandler)ManagementCenterService.this.qClientHandlers.poll();
                    if (clientHandler == null) {
                        ManagementCenterService.this.logger.log(Level.SEVERE, "ClientHandler pool exhausted! Try to connect another node...");
                        break;
                    }
                    try {
                        this.serverSocket.doAccept(clientHandler.getSocket());
                    }
                    catch (SocketTimeoutException e) {
                        ManagementCenterService.this.qClientHandlers.offer(clientHandler);
                        continue;
                    }
                    clientHandler.start();
                }
            }
            catch (Throwable throwable) {
                if (ManagementCenterService.this.running) {
                    ManagementCenterService.this.logger.log(Level.FINEST, "ManagementCenter will be closed due to exception.", throwable);
                }
                ManagementCenterService.this.shutdown();
            }
        }
    }
}

