/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.instance;

import com.hazelcast.config.Config;
import com.hazelcast.config.UrlXmlConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.DuplicateInstanceNameException;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.instance.ConfigLoader;
import com.hazelcast.hibernate.instance.HazelcastInstanceFactory;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.hibernate.cache.CacheException;
import org.hibernate.util.StringHelper;

class HazelcastInstanceLoader
implements IHazelcastInstanceLoader {
    private static final ILogger logger = Logger.getLogger(HazelcastInstanceFactory.class.getName());
    private final Properties props = new Properties();
    private boolean useLiteMember = false;
    private boolean staticInstance = false;
    private String instanceName = null;
    private HazelcastInstance instance;
    private Config config = null;

    HazelcastInstanceLoader() {
    }

    public void configure(Properties props) {
        this.props.putAll((Map<?, ?>)props);
    }

    public HazelcastInstance loadInstance() throws CacheException {
        if (this.instance != null && this.instance.getLifecycleService().isRunning()) {
            logger.log(Level.WARNING, "Current HazelcastInstance is already loaded and running! Returning current instance...");
            return this.instance;
        }
        String configResourcePath = null;
        if (this.props != null) {
            this.instanceName = CacheEnvironment.getInstanceName(this.props);
            this.useLiteMember = CacheEnvironment.isLiteMember(this.props);
            if (!this.useLiteMember && this.props.contains("hibernate.cache.hazelcast.use_super_client")) {
                this.useLiteMember = CacheEnvironment.isSuperClient(this.props);
                logger.log(Level.WARNING, "'hibernate.cache.hazelcast.use_super_client' property is deprecated! Please use 'hibernate.cache.hazelcast.use_lite_member' instead...");
            }
            configResourcePath = CacheEnvironment.getConfigFilePath(this.props);
        }
        if (this.useLiteMember) {
            logger.log(Level.WARNING, "Creating Hazelcast node as Lite-Member. Be sure this node has access to an already running cluster...");
        }
        if (StringHelper.isEmpty(configResourcePath)) {
            if (!this.useLiteMember && this.instanceName == null) {
                this.staticInstance = true;
            }
        } else {
            URL url = ConfigLoader.locateConfig(configResourcePath);
            try {
                this.config = new UrlXmlConfig(url);
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
        if (this.instanceName != null) {
            this.instance = Hazelcast.getHazelcastInstanceByName(this.instanceName);
            if (this.instance == null) {
                try {
                    this.createOrGetInstance();
                }
                catch (DuplicateInstanceNameException ignored) {
                    this.instance = Hazelcast.getHazelcastInstanceByName(this.instanceName);
                }
            }
        } else {
            this.createOrGetInstance();
        }
        return this.instance;
    }

    private void createOrGetInstance() throws DuplicateInstanceNameException {
        if (this.staticInstance) {
            this.instance = Hazelcast.getDefaultInstance();
        } else {
            if (this.config == null) {
                this.config = new XmlConfigBuilder().build();
            }
            this.config.setInstanceName(this.instanceName);
            this.config.setLiteMember(this.useLiteMember);
            this.instance = Hazelcast.newHazelcastInstance(this.config);
        }
    }

    public void unloadInstance() throws CacheException {
        if (this.instance == null) {
            return;
        }
        boolean shutDown = CacheEnvironment.shutdownOnStop(this.props, this.instanceName == null);
        if (!shutDown) {
            logger.log(Level.WARNING, "hibernate.cache.hazelcast.shutdown_on_session_factory_close property is set to 'false'. Leaving current HazelcastInstance active! (Warning: Do not disable Hazelcast hazelcast.shutdownhook.enabled property!)");
            return;
        }
        try {
            this.instance.getLifecycleService().shutdown();
            this.instance = null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

