/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

public class CounterService {
    public static final Counter userCounter = new Counter("user");
    public static final Counter serviceCounter = new Counter("serviceThread");

    public static void print() {
        System.out.println(userCounter);
        System.out.println("=======================");
        System.out.println(serviceCounter);
        System.out.println("=======================");
    }

    public static class Counter {
        final String name;
        long totalCount;
        long totalElapsedTime;

        public Counter(String name) {
            this.name = name;
        }

        public void add(long elapsedTime) {
            ++this.totalCount;
            this.totalElapsedTime += elapsedTime / 1000L;
        }

        public String toString() {
            double ave = (double)this.totalElapsedTime / (double)this.totalCount;
            return "Counter{name='" + this.name + '\'' + ", totalCount=" + this.totalCount + ", totalElapsedTime=" + this.totalElapsedTime + ", ave=" + ave + '}';
        }
    }
}

