/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.impl.Node;
import com.hazelcast.impl.base.CallKey;
import com.hazelcast.impl.base.CallState;
import com.hazelcast.impl.base.CallStateAware;
import com.hazelcast.impl.base.SystemArgsLog;
import com.hazelcast.impl.base.SystemLog;
import com.hazelcast.impl.base.SystemObjectLog;
import com.hazelcast.nio.Address;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;

public class SystemLogService {
    private final ConcurrentMap<CallKey, CallState> mapCallStates = new ConcurrentHashMap<CallKey, CallState>(100, 0.75f, 32);
    private final Queue<SystemLog> joinLogs = new LinkedBlockingQueue<SystemLog>(10000);
    private final Queue<SystemLog> connectionLogs = new LinkedBlockingQueue<SystemLog>(10000);
    private final Queue<SystemLog> migrationLogs = new LinkedBlockingQueue<SystemLog>(10000);
    private final Queue<SystemLog> nodeLogs = new LinkedBlockingQueue<SystemLog>(10000);
    private volatile Level currentLevel = Level.CS_NONE;
    private final Node node;

    public SystemLogService(Node node) {
        this.node = node;
    }

    public CallState getOrCreateCallState(long callId, Address callerAddress, int callerThreadId) {
        if (this.currentLevel == Level.CS_NONE) {
            return null;
        }
        CallKey callKey = new CallKey(callerAddress, callerThreadId);
        CallState callBefore = (CallState)this.mapCallStates.get(callKey);
        if (callBefore == null) {
            CallState callStateNew = new CallState(callId, callerAddress, callerThreadId);
            this.mapCallStates.put(callKey, callStateNew);
            int callStatesCount = this.mapCallStates.size();
            if (callStatesCount > 10000) {
                String msg = " CallStates created! You might have too many threads accessing Hazelcast!";
                this.logNode(callStatesCount + msg);
            }
            return callStateNew;
        }
        if (callBefore.getCallId() != callId) {
            callBefore.reset(callId);
        }
        return callBefore;
    }

    public CallState getCallState(Address callerAddress, int callerThreadId) {
        if (this.currentLevel == Level.CS_NONE) {
            return null;
        }
        return (CallState)this.mapCallStates.get(new CallKey(callerAddress, callerThreadId));
    }

    public CallState getCallStateForCallId(long callId, Address callerAddress, int callerThreadId) {
        if (this.currentLevel == Level.CS_NONE) {
            return null;
        }
        CallState callState = (CallState)this.mapCallStates.get(new CallKey(callerAddress, callerThreadId));
        if (callState != null && callState.getCallId() == callId) {
            return callState;
        }
        return null;
    }

    public void shutdown() {
        this.mapCallStates.clear();
        this.connectionLogs.clear();
        this.nodeLogs.clear();
        this.joinLogs.clear();
        this.migrationLogs.clear();
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        TreeSet<SystemLog> sorted = new TreeSet<SystemLog>(new Comparator<SystemLog>(){

            @Override
            public int compare(SystemLog o1, SystemLog o2) {
                long thisVal = o1.date;
                long anotherVal = o2.date;
                return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
            }
        });
        sorted.addAll(this.joinLogs);
        sorted.addAll(this.nodeLogs);
        sorted.addAll(this.connectionLogs);
        sorted.addAll(this.migrationLogs);
        for (SystemLog systemLog : sorted) {
            sb.append(systemLog.getType().toString());
            sb.append(" - ");
            sb.append(new Date(systemLog.getDate()).toString());
            sb.append(" - ");
            sb.append(systemLog.toString());
            sb.append("\n");
        }
        for (CallState callState : this.mapCallStates.values()) {
            sb.append(callState.toString());
            sb.append("\n");
            for (Object log : callState.getLogs()) {
                SystemLog systemLog = (SystemLog)log;
                sb.append(systemLog.getType().toString());
                sb.append(" - ");
                sb.append(new Date(systemLog.getDate()).toString());
                sb.append(" - ");
                sb.append(systemLog.toString());
                sb.append("\n");
            }
        }
        sb.append(this.node.concurrentMapManager.getPartitionManager().toString());
        sb.append("\n");
        return sb.toString();
    }

    private void dumpToFile(String log) throws IOException {
        String fileName = "hazelcast-" + this.node.getThisAddress() + ".dump.txt";
        File file = new File(fileName);
        FileWriter fileWriter = new FileWriter(file);
        BufferedWriter out = new BufferedWriter(fileWriter);
        out.write(log);
        out.close();
    }

    public void logConnection(String str) {
        if (this.currentLevel != Level.CS_NONE) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.CONNECTION);
            this.joinLogs.offer(systemLog);
        }
    }

    public void logPartition(String str) {
        if (this.currentLevel != Level.CS_NONE) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.PARTITION);
            this.joinLogs.offer(systemLog);
        }
    }

    public void logNode(String str) {
        if (this.currentLevel != Level.CS_NONE) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.NODE);
            this.joinLogs.offer(systemLog);
        }
    }

    public void logJoin(String str) {
        if (this.currentLevel != Level.CS_NONE) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.JOIN);
            this.joinLogs.offer(systemLog);
        }
    }

    public void setLogLevel(Level level) {
        this.currentLevel = level;
    }

    public boolean shouldLog(Level level) {
        return this.currentLevel != Level.CS_NONE && this.currentLevel.ordinal() >= level.ordinal();
    }

    public boolean shouldTrace() {
        return this.currentLevel != Level.CS_NONE && this.currentLevel.ordinal() >= Level.CS_TRACE.ordinal();
    }

    public boolean shouldInfo() {
        return this.currentLevel != Level.CS_NONE && this.currentLevel.ordinal() >= Level.CS_INFO.ordinal();
    }

    public void info(CallStateAware callStateAware, SystemLog callStateLog) {
        this.logState(callStateAware, Level.CS_INFO, callStateLog);
    }

    public void trace(CallStateAware callStateAware, SystemLog callStateLog) {
        this.logState(callStateAware, Level.CS_TRACE, callStateLog);
    }

    public void info(CallStateAware callStateAware, String msg) {
        this.logObject(callStateAware, Level.CS_INFO, msg);
    }

    public void trace(CallStateAware callStateAware, String msg) {
        this.logObject(callStateAware, Level.CS_TRACE, msg);
    }

    public void info(CallStateAware callStateAware, String msg, Object arg1) {
        this.logState(callStateAware, Level.CS_INFO, new SystemArgsLog(msg, arg1));
    }

    public void info(CallStateAware callStateAware, String msg, Object arg1, Object arg2) {
        this.logState(callStateAware, Level.CS_INFO, new SystemArgsLog(msg, arg1, arg2));
    }

    public void trace(CallStateAware callStateAware, String msg, Object arg1) {
        this.logState(callStateAware, Level.CS_TRACE, new SystemArgsLog(msg, arg1));
    }

    public void trace(CallStateAware callStateAware, String msg, Object arg1, Object arg2) {
        this.logState(callStateAware, Level.CS_TRACE, new SystemArgsLog(msg, arg1, arg2));
    }

    public void logObject(CallStateAware callStateAware, Level level, Object obj) {
        CallState callState;
        if (this.currentLevel.ordinal() >= level.ordinal() && callStateAware != null && (callState = callStateAware.getCallState()) != null) {
            callState.logObject(obj);
        }
    }

    public void logState(CallStateAware callStateAware, Level level, SystemLog callStateLog) {
        CallState callState;
        if (this.currentLevel.ordinal() >= level.ordinal() && callStateAware != null && (callState = callStateAware.getCallState()) != null) {
            callState.log(callStateLog);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        CS_NONE,
        CS_EMPTY,
        CS_INFO,
        CS_TRACE;

    }
}

