/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.DefaultRecord;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.partition.PartitionInfo;
import com.hazelcast.impl.partition.PartitionListener;
import com.hazelcast.impl.partition.PartitionReplicaChangeEvent;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.partition.MigrationEvent;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.junit.Ignore;
import org.mockito.Mockito;

@Ignore
public class TestUtil {
    public static boolean migrateKey(Object key, HazelcastInstance oldest, HazelcastInstance to, final int replicaIndex) throws Exception {
        MemberImpl toMember;
        final int partitionId = oldest.getPartitionService().getPartition(key).getPartitionId();
        final ConcurrentMapManager concurrentMapManagerOldest = TestUtil.getConcurrentMapManager(oldest);
        ConcurrentMapManager concurrentMapManagerTo = TestUtil.getConcurrentMapManager(to);
        PartitionInfo partitionInfoOldest = concurrentMapManagerOldest.getPartitionInfo(partitionId);
        PartitionInfo partitionInfoTo = concurrentMapManagerTo.getPartitionInfo(partitionId);
        MemberImpl currentOwnerMember = concurrentMapManagerOldest.getMember(partitionInfoOldest.getReplicaAddress(replicaIndex));
        if (!currentOwnerMember.equals(toMember = (MemberImpl)to.getCluster().getLocalMember())) {
            final Address addressCurrentOwner = currentOwnerMember.getAddress();
            final Address addressNewOwner = toMember.getAddress();
            PartitionListenerLatch latchOldest = new PartitionListenerLatch(toMember.getAddress(), partitionId, replicaIndex);
            PartitionListenerLatch latchTo = new PartitionListenerLatch(toMember.getAddress(), partitionId, replicaIndex);
            concurrentMapManagerOldest.getPartitionManager().addPartitionListener(latchOldest);
            concurrentMapManagerTo.getPartitionManager().addPartitionListener(latchTo);
            concurrentMapManagerOldest.enqueueAndReturn(new Processable(){

                public void process() {
                    concurrentMapManagerOldest.partitionManager.forcePartitionOwnerMigration(partitionId, replicaIndex, addressCurrentOwner, addressNewOwner);
                }
            });
            Assert.assertTrue((String)"Migration should get completed in 20 seconds!!", (boolean)latchOldest.await(20, TimeUnit.SECONDS));
            Assert.assertTrue((String)"Migration should get completed in 20 seconds!!", (boolean)latchTo.await(20, TimeUnit.SECONDS));
        }
        Assert.assertEquals((Object)toMember.getAddress(), (Object)partitionInfoOldest.getReplicaAddress(replicaIndex));
        Assert.assertEquals((Object)toMember.getAddress(), (Object)partitionInfoTo.getReplicaAddress(replicaIndex));
        return true;
    }

    public static Node getNode(HazelcastInstance h) {
        FactoryImpl.HazelcastInstanceProxy hiProxy = (FactoryImpl.HazelcastInstanceProxy)h;
        return hiProxy.getFactory().node;
    }

    public static ConcurrentMapManager getConcurrentMapManager(HazelcastInstance h) {
        return TestUtil.getNode((HazelcastInstance)h).concurrentMapManager;
    }

    public static CMap mockCMap(String name) {
        FactoryImpl mockFactory = (FactoryImpl)Mockito.mock(FactoryImpl.class);
        Node node = new Node(mockFactory, new Config());
        node.serviceThread = Thread.currentThread();
        return new CMap(node.concurrentMapManager, "c:" + name);
    }

    public static CMap getCMap(HazelcastInstance h, String name) {
        ConcurrentMapManager concurrentMapManager = TestUtil.getConcurrentMapManager(h);
        String fullName = "c:" + name;
        return concurrentMapManager.getMap(fullName);
    }

    public static CMap getCMapForMultiMap(HazelcastInstance h, String name) {
        ConcurrentMapManager concurrentMapManager = TestUtil.getConcurrentMapManager(h);
        String fullName = "m:u:" + name;
        return concurrentMapManager.getMap(fullName);
    }

    public static Partition getPartitionById(PartitionService partitionService, int partitionId) {
        for (Partition partition : partitionService.getPartitions()) {
            if (partition.getPartitionId() != partitionId) continue;
            return partition;
        }
        return null;
    }

    public static Record newRecord(CMap cmap, long recordId, Data key, Data value) {
        return new DefaultRecord(cmap, 1, key, value, 0L, 0L, recordId);
    }

    public static Record newRecord(long recordId, Data key, Data value) {
        CMap cmap = (CMap)Mockito.mock(CMap.class);
        return TestUtil.newRecord(cmap, recordId, key, value);
    }

    public static Record newRecord(CMap cmap, long recordId, Object key, Object value) {
        return TestUtil.newRecord(cmap, recordId, IOUtil.toData(key), IOUtil.toData(value));
    }

    public static Record newRecord(long recordId, Object key, Object value) {
        return TestUtil.newRecord(recordId, IOUtil.toData(key), IOUtil.toData(value));
    }

    public static Record newRecord(long recordId) {
        return TestUtil.newRecord(recordId, null, null);
    }

    public static Request newPutRequest(Data key, Data value) {
        return TestUtil.newPutRequest(key, value, -1L);
    }

    public static Request newPutRequest(Data key, Data value, long ttl) {
        return TestUtil.newRequest(ClusterOperation.CONCURRENT_MAP_PUT, key, value, ttl);
    }

    public static Request newRequest(ClusterOperation operation, Data key, Data value, long ttl) {
        Request request = new Request();
        request.setLocal(operation, null, key, value, -1, -1L, ttl, null);
        return request;
    }

    public static Request newRemoveRequest(Data key) {
        return TestUtil.newRequest(ClusterOperation.CONCURRENT_MAP_REMOVE, key, null, -1L);
    }

    public static Request newEvictRequest(Data key) {
        return TestUtil.newRequest(ClusterOperation.CONCURRENT_MAP_EVICT, key, null, -1L);
    }

    public static Request newGetRequest(Data key) {
        return TestUtil.newRequest(ClusterOperation.CONCURRENT_MAP_GET, key, null, -1L);
    }

    public static Request newContainsRequest(Data key, Data value) {
        if (value == null) {
            return TestUtil.newRequest(ClusterOperation.CONCURRENT_MAP_CONTAINS_KEY, key, value, -1L);
        }
        return TestUtil.newRequest(ClusterOperation.CONCURRENT_MAP_CONTAINS_ENTRY, key, value, -1L);
    }

    @Ignore
    public static class Employee
    implements Serializable {
        long id;
        String name;
        String city;
        int age;
        boolean active;
        double salary;
        Timestamp date;
        java.util.Date createDate;
        Date sqlDate;
        State state;

        public Employee(long id, String name, int age, boolean live, double price, State state) {
            this.state = state;
        }

        public Employee(long id, String name, int age, boolean live, double price) {
            this(id, name, null, age, live, price);
        }

        public Employee(String name, int age, boolean live, double price) {
            this(-1L, name, age, live, price);
        }

        public Employee(long id, String name, String city, int age, boolean live, double price) {
            this.id = id;
            this.name = name;
            this.city = city;
            this.age = age;
            this.active = live;
            this.salary = price;
            this.createDate = new java.util.Date();
            this.date = new Timestamp(this.createDate.getTime());
            this.sqlDate = new Date(this.createDate.getTime());
        }

        public Employee() {
        }

        public Timestamp getDate() {
            return this.date;
        }

        public String getName() {
            return this.name;
        }

        public String getCity() {
            return this.city;
        }

        public int getAge() {
            return this.age;
        }

        public double getSalary() {
            return this.salary;
        }

        public boolean isActive() {
            return this.active;
        }

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            this.state = state;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Employee employee = (Employee)o;
            if (this.active != employee.active) {
                return false;
            }
            if (this.age != employee.age) {
                return false;
            }
            if (Double.compare(employee.salary, this.salary) != 0) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(employee.name) : employee.name != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + this.age;
            result = 31 * result + (this.active ? 1 : 0);
            long temp = this.salary != 0.0 ? Double.doubleToLongBits(this.salary) : 0L;
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Employee");
            sb.append("{name='").append(this.name).append('\'');
            sb.append(", city=").append(this.city);
            sb.append(", age=").append(this.age);
            sb.append(", active=").append(this.active);
            sb.append(", salary=").append(this.salary);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        STATE1,
        STATE2;

    }

    @Ignore
    public static class OrderKey
    implements Serializable,
    PartitionAware {
        int customerId;
        int orderId;

        public OrderKey(int orderId, int customerId) {
            this.customerId = customerId;
            this.orderId = orderId;
        }

        public int getCustomerId() {
            return this.customerId;
        }

        public int getOrderId() {
            return this.orderId;
        }

        public Object getPartitionKey() {
            return this.customerId;
        }

        public String toString() {
            return "OrderKey{customerId=" + this.customerId + ", orderId=" + this.orderId + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Ignore
    public static class OrderUpdateCallable
    implements Serializable,
    Callable<Boolean>,
    PartitionAware,
    HazelcastInstanceAware {
        int customerId;
        int orderId;
        transient HazelcastInstance hazelcastInstance;

        public OrderUpdateCallable(int orderId, int customerId) {
            this.customerId = customerId;
            this.orderId = orderId;
        }

        @Override
        public Boolean call() throws Exception {
            return this.hazelcastInstance.getPartitionService().getPartition(this.customerId).getOwner().localMember();
        }

        public int getCustomerId() {
            return this.customerId;
        }

        public int getOrderId() {
            return this.orderId;
        }

        public Object getPartitionKey() {
            return this.customerId;
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.hazelcastInstance = hazelcastInstance;
        }

        public String toString() {
            return "OrderUpdateCallable{customerId=" + this.customerId + ", orderId=" + this.orderId + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Ignore
    public static class OrderUpdateRunnable
    implements Serializable,
    Runnable,
    PartitionAware<Integer>,
    HazelcastInstanceAware {
        int customerId;
        int orderId;
        transient HazelcastInstance hazelcastInstance;

        public OrderUpdateRunnable(int orderId, int customerId) {
            this.customerId = customerId;
            this.orderId = orderId;
        }

        @Override
        public void run() {
            if (!this.hazelcastInstance.getPartitionService().getPartition(this.customerId).getOwner().localMember()) {
                throw new RuntimeException("Not local member");
            }
        }

        public int getCustomerId() {
            return this.customerId;
        }

        public int getOrderId() {
            return this.orderId;
        }

        @Override
        public Integer getPartitionKey() {
            return this.customerId;
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.hazelcastInstance = hazelcastInstance;
        }

        public String toString() {
            return "OrderUpdateRunnable{customerId=" + this.customerId + ", orderId=" + this.orderId + '}';
        }
    }

    @Ignore
    public static class EmptyMapEntry
    implements MapEntry {
        private long cost;
        private long creationTime;
        private long expirationTime;
        private int hits;
        private long lastAccessTime;
        private long lastUpdateTime;
        private long lastStoredTime;
        private int version;
        private boolean valid;
        private Object key;
        private Object value;
        private long id;

        public EmptyMapEntry(long id) {
            this.id = id;
        }

        public long getCost() {
            return this.cost;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }

        public int getHits() {
            return this.hits;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public long getLastStoredTime() {
            return this.lastStoredTime;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public long getVersion() {
            return this.version;
        }

        public boolean isValid() {
            return this.valid;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public void setCost(long cost) {
            this.cost = cost;
        }

        public void setCreationTime(long creationTime) {
            this.creationTime = creationTime;
        }

        public void setExpirationTime(long expirationTime) {
            this.expirationTime = expirationTime;
        }

        public void setHits(int hits) {
            this.hits = hits;
        }

        public void setKey(Object key) {
            this.key = key;
        }

        public void setLastAccessTime(long lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
        }

        public void setLastUpdateTime(long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public long getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EmptyMapEntry that = (EmptyMapEntry)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }

        public String toString() {
            return "EmptyMapEntry{id=" + this.id + ", expirationTime=" + this.expirationTime + ", hits=" + this.hits + ", lastAccessTime=" + this.lastAccessTime + ", lastUpdateTime=" + this.lastUpdateTime + ", key=" + this.key + ", value=" + this.value + ", valid=" + this.valid + ", creationTime=" + this.creationTime + ", cost=" + this.cost + ", version=" + this.version + '}';
        }
    }

    @Ignore
    public static class Value
    extends AbstractValue
    implements Serializable {
        ValueType type;
        int index;

        public Value(String name, ValueType type, int index) {
            super(name);
            this.type = type;
            this.index = index;
        }

        public Value(String name) {
            this(name, null, 0);
        }

        public Value() {
            super("unknown");
        }

        public ValueType getType() {
            return this.type;
        }

        public int getIndex() {
            return this.index;
        }
    }

    @Ignore
    public static abstract class AbstractValue
    implements Serializable {
        public String name;

        public AbstractValue(String name) {
            this.name = name;
        }

        protected AbstractValue() {
        }
    }

    @Ignore
    public static class ValueType
    implements Serializable {
        String typeName;

        public ValueType(String typeName) {
            this.typeName = typeName;
        }

        public ValueType() {
        }

        public String getTypeName() {
            return this.typeName;
        }
    }

    static class PartitionListenerLatch
    implements PartitionListener {
        final CountDownLatch migrationLatch = new CountDownLatch(1);
        final Address toAddress;
        final int partitionId;
        final int replicaIndex;

        PartitionListenerLatch(Address toAddress, int partitionId, int replicaIndex) {
            this.toAddress = toAddress;
            this.partitionId = partitionId;
            this.replicaIndex = replicaIndex;
        }

        public void replicaChanged(PartitionReplicaChangeEvent event) {
            if (event.getReplicaIndex() == this.replicaIndex && event.getPartitionId() == this.partitionId && this.toAddress != null && this.toAddress.equals(event.getNewAddress())) {
                this.migrationLatch.countDown();
            }
        }

        public boolean await(int time, TimeUnit timeUnit) throws InterruptedException {
            return this.migrationLatch.await(time, timeUnit);
        }
    }

    public static class MigrationCompletionLatch
    implements MigrationListener {
        final int partitionId;
        final CountDownLatch latch;

        public MigrationCompletionLatch(Object key, HazelcastInstance ... h) {
            this.partitionId = h[0].getPartitionService().getPartition(key).getPartitionId();
            this.latch = new CountDownLatch(h.length);
            for (HazelcastInstance hazelcastInstance : h) {
                hazelcastInstance.getPartitionService().addMigrationListener(this);
            }
        }

        public void migrationStarted(MigrationEvent migrationEvent) {
        }

        public void migrationCompleted(MigrationEvent migrationEvent) {
            if (migrationEvent.getPartitionId() == this.partitionId) {
                this.latch.countDown();
            }
        }

        public boolean await(int time, TimeUnit timeUnit) throws InterruptedException {
            return this.latch.await(time, timeUnit);
        }
    }
}

