/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.SocketChannelWrapper;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.util.logging.Level;

public class SocketAcceptor
implements Runnable {
    private final ServerSocketChannel serverSocketChannel;
    private final ConnectionManager connectionManager;
    private final ILogger logger;

    public SocketAcceptor(ServerSocketChannel serverSocketChannel, ConnectionManager connectionManager) {
        this.serverSocketChannel = serverSocketChannel;
        this.connectionManager = connectionManager;
        this.logger = connectionManager.ioService.getLogger(this.getClass().getName());
    }

    public void run() {
        try {
            this.connectionManager.ioService.onIOThreadStart();
            this.serverSocketChannel.configureBlocking(true);
            while (this.connectionManager.isLive()) {
                SocketChannelWrapper socketChannelWrapper = null;
                try {
                    socketChannelWrapper = this.connectionManager.wrapSocketChannel(this.serverSocketChannel.accept(), false);
                }
                catch (Exception e) {
                    if (e instanceof ClosedChannelException && !this.connectionManager.isLive()) {
                        this.logger.log(Level.FINEST, "Terminating socket acceptor thread...", e);
                    }
                    this.logger.log(Level.WARNING, "Unexpected error while accepting connection!", e);
                    try {
                        this.serverSocketChannel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connectionManager.ioService.onFatalError(e);
                }
                if (socketChannelWrapper == null) continue;
                final SocketChannelWrapper socketChannel = socketChannelWrapper;
                this.connectionManager.executeAsync(new Runnable(){

                    public void run() {
                        block5: {
                            SocketAcceptor.this.logger.log(Level.INFO, socketChannel.socket().getLocalPort() + " is accepting socket connection from " + socketChannel.socket().getRemoteSocketAddress());
                            try {
                                MemberSocketInterceptor memberSocketInterceptor = SocketAcceptor.this.connectionManager.getMemberSocketInterceptor();
                                if (memberSocketInterceptor != null) {
                                    memberSocketInterceptor.onAccept(socketChannel.socket());
                                }
                                socketChannel.configureBlocking(false);
                                SocketAcceptor.this.connectionManager.initSocket(socketChannel.socket());
                                SocketAcceptor.this.connectionManager.assignSocketChannel(socketChannel);
                            }
                            catch (Exception e) {
                                SocketAcceptor.this.logger.log(Level.WARNING, e.getMessage(), e);
                                if (socketChannel == null) break block5;
                                try {
                                    socketChannel.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                });
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

