/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.cluster.AddOrRemoveConnection;
import com.hazelcast.config.AsymmetricEncryptionConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.Packet;

public class NodeIOService
implements IOService {
    final Node node;

    public NodeIOService(Node node) {
        this.node = node;
    }

    public boolean isActive() {
        return this.node.isActive();
    }

    public ILogger getLogger(String name) {
        return this.node.getLogger(name);
    }

    public void onOutOfMemory(OutOfMemoryError oom) {
        this.node.onOutOfMemory(oom);
    }

    public void handleInterruptedException(Thread thread, RuntimeException e) {
        this.node.handleInterruptedException(thread, e);
    }

    public void onIOThreadStart() {
        ThreadContext.get().setCurrentFactory(this.node.factory);
    }

    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    public void onFatalError(Exception e) {
        this.node.shutdown(false, false);
    }

    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.node.getConfig().getNetworkConfig().getSocketInterceptorConfig();
    }

    public SymmetricEncryptionConfig getSymmetricEncryptionConfig() {
        return this.node.getConfig().getNetworkConfig().getSymmetricEncryptionConfig();
    }

    public AsymmetricEncryptionConfig getAsymmetricEncryptionConfig() {
        return this.node.getConfig().getNetworkConfig().getAsymmetricEncryptionConfig();
    }

    public void handleClientPacket(Packet p) {
        this.node.clientService.handle(p);
    }

    public void handleMemberPacket(Packet p) {
        this.node.clusterService.enqueuePacket(p);
    }

    public TextCommandService getTextCommandService() {
        return this.node.getTextCommandService();
    }

    public boolean isMemcacheEnabled() {
        return this.node.groupProperties.MEMCACHE_ENABLED.getBoolean();
    }

    public boolean isRestEnabled() {
        return this.node.groupProperties.REST_ENABLED.getBoolean();
    }

    public void removeEndpoint(Address endPoint) {
        AddOrRemoveConnection addOrRemoveConnection = new AddOrRemoveConnection(endPoint, false);
        addOrRemoveConnection.setNode(this.node);
        this.node.clusterManager.enqueueAndReturn(addOrRemoveConnection);
    }

    public String getThreadPrefix() {
        return this.node.getThreadPoolNamePrefix("IO");
    }

    public ThreadGroup getThreadGroup() {
        return this.node.threadGroup;
    }

    public void onFailedConnection(Address address) {
        if (!this.node.joined()) {
            this.node.failedConnection(address);
        }
    }

    public void shouldConnectTo(Address address) {
        if (this.node.getThisAddress().equals(address)) {
            throw new RuntimeException("Connecting to self! " + address);
        }
    }

    public int getSocketReceiveBufferSize() {
        return this.node.getGroupProperties().SOCKET_RECEIVE_BUFFER_SIZE.getInteger();
    }

    public int getSocketSendBufferSize() {
        return this.node.getGroupProperties().SOCKET_SEND_BUFFER_SIZE.getInteger();
    }

    public int getSocketLingerSeconds() {
        return this.node.getGroupProperties().SOCKET_LINGER_SECONDS.getInteger();
    }

    public boolean getSocketKeepAlive() {
        return this.node.getGroupProperties().SOCKET_KEEP_ALIVE.getBoolean();
    }

    public boolean getSocketNoDelay() {
        return this.node.getGroupProperties().SOCKET_NO_DELAY.getBoolean();
    }

    public int getSocketTimeoutSeconds() {
        return this.node.getGroupProperties().SOCKET_TIMEOUT_SECONDS.getInteger();
    }

    public int getSelectorThreadCount() {
        return this.node.groupProperties.IO_THREAD_COUNT.getInteger();
    }

    public void disconnectExistingCalls(final Address deadEndpoint) {
        if (deadEndpoint != null) {
            this.node.clusterManager.enqueueAndReturn(new Processable(){

                public void process() {
                    NodeIOService.this.node.clusterManager.disconnectExistingCalls(deadEndpoint);
                }
            });
        }
    }

    public boolean isClient() {
        return false;
    }

    public long getConnectionMonitorInterval() {
        return this.node.groupProperties.CONNECTION_MONITOR_INTERVAL.getLong();
    }

    public int getConnectionMonitorMaxFaults() {
        return this.node.groupProperties.CONNECTION_MONITOR_MAX_FAULTS.getInteger();
    }
}

