/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.Config;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.TcpIpJoiner;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressPicker {
    final Node node;
    final ServerSocketChannel serverSocketChannel;
    final ILogger logger;

    public AddressPicker(Node node, ServerSocketChannel serverSocketChannel) {
        this.node = node;
        this.logger = Logger.getLogger(AddressPicker.class.getName());
        this.serverSocketChannel = serverSocketChannel;
    }

    public static boolean matchAddress(String address, Collection<String> interfaces) {
        if (interfaces == null || interfaces.size() == 0) {
            return false;
        }
        int[] ip = new int[4];
        int i = 0;
        StringTokenizer st = new StringTokenizer(address, ".");
        while (st.hasMoreTokens()) {
            ip[i++] = Integer.parseInt(st.nextToken());
        }
        for (String ipmask : interfaces) {
            if (!AddressPicker.matchAddress(ipmask, ip)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchAddress(String ipmask, int[] ip) {
        String[] ips = new String[4];
        StringTokenizer st = new StringTokenizer(ipmask, ".");
        int i = 0;
        while (st.hasMoreTokens()) {
            ips[i++] = st.nextToken();
        }
        for (int a = 0; a < 4; ++a) {
            String mask = ips[a];
            int ipa = ip[a];
            int dashIndex = mask.indexOf(45);
            if (mask.equals("*")) continue;
            if (dashIndex != -1) {
                int start = Integer.parseInt(mask.substring(0, dashIndex).trim());
                int end = Integer.parseInt(mask.substring(dashIndex + 1).trim());
                if (ipa >= start && ipa <= end) continue;
                return false;
            }
            int x = Integer.parseInt(mask);
            if (x == ipa) continue;
            return false;
        }
        return true;
    }

    public Address pickAddress() throws Exception {
        String currentAddress = null;
        try {
            Config config = this.node.getConfig();
            String localAddress = System.getProperty("hazelcast.local.localAddress");
            if (localAddress != null) {
                currentAddress = InetAddress.getByName(localAddress.trim()).getHostAddress();
            }
            if (currentAddress == null) {
                HashSet<String> interfaces = new HashSet<String>();
                if (config.getNetworkConfig().getJoin().getTcpIpConfig().isEnabled()) {
                    Collection<Address> possibleAddresses = new TcpIpJoiner(this.node).getPossibleMembers(config, null, this.logger);
                    for (Address possibleAddress : possibleAddresses) {
                        interfaces.add(possibleAddress.getHost());
                    }
                }
                if (config.getNetworkConfig().getInterfaces().isEnabled()) {
                    interfaces.addAll(config.getNetworkConfig().getInterfaces().getInterfaces());
                }
                if (interfaces.contains("127.0.0.1") || interfaces.contains("localhost")) {
                    currentAddress = "127.0.0.1";
                } else {
                    InetAddress inetAddress;
                    Enumeration<InetAddress> e;
                    NetworkInterface ni;
                    Enumeration<NetworkInterface> enums;
                    if (interfaces.size() > 0) {
                        enums = NetworkInterface.getNetworkInterfaces();
                        block5: while (enums.hasMoreElements()) {
                            ni = enums.nextElement();
                            e = ni.getInetAddresses();
                            while (e.hasMoreElements()) {
                                String address;
                                inetAddress = e.nextElement();
                                if (!(inetAddress instanceof Inet4Address) || !AddressPicker.matchAddress(address = inetAddress.getHostAddress(), interfaces)) continue;
                                currentAddress = address;
                                break block5;
                            }
                        }
                    }
                    if (currentAddress == null) {
                        if (config.getNetworkConfig().getInterfaces().isEnabled()) {
                            String msg = "Hazelcast CANNOT start on this node. No matching network interface found. ";
                            msg = msg + "\nInterface matching must be either disabled or updated in the hazelcast.xml config file.";
                            this.logger.log(Level.SEVERE, msg);
                            throw new RuntimeException(msg);
                        }
                        enums = NetworkInterface.getNetworkInterfaces();
                        block7: while (enums.hasMoreElements()) {
                            ni = enums.nextElement();
                            e = ni.getInetAddresses();
                            while (e.hasMoreElements()) {
                                inetAddress = e.nextElement();
                                if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                                currentAddress = inetAddress.getHostAddress();
                                break block7;
                            }
                        }
                    }
                }
            }
            if (currentAddress == null) {
                currentAddress = "127.0.0.1";
            }
            InetAddress inetAddress = InetAddress.getByName(currentAddress);
            boolean reuseAddress = config.isReuseAddress();
            ServerSocket serverSocket = this.serverSocketChannel.socket();
            this.logger.log(Level.FINEST, "inet reuseAddress:" + reuseAddress);
            serverSocket.setReuseAddress(reuseAddress);
            serverSocket.setSoTimeout(1000);
            int port = config.getPort();
            for (int i = 0; i < 100; ++i) {
                try {
                    boolean bindAny = this.node.getGroupProperties().SOCKET_BIND_ANY.getBoolean();
                    InetSocketAddress isa = bindAny ? new InetSocketAddress(port) : new InetSocketAddress(inetAddress, port);
                    this.logger.log(Level.FINEST, "inet socket address:" + isa);
                    serverSocket.bind(isa, 100);
                    break;
                }
                catch (Exception e) {
                    if (config.isPortAutoIncrement()) {
                        serverSocket = this.serverSocketChannel.socket();
                        serverSocket.setReuseAddress(reuseAddress);
                        ++port;
                        continue;
                    }
                    String msg = "Port [" + port + "] is already in use and auto-increment is " + "disabled. Hazelcast cannot start.";
                    this.logger.log(Level.SEVERE, msg, e);
                    throw e;
                }
            }
            this.serverSocketChannel.configureBlocking(false);
            return new Address(currentAddress, port);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
    }
}

