/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.AbstractSelectionHandler;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.SocketPacketReader;
import com.hazelcast.nio.SocketReader;
import com.hazelcast.nio.WriteHandler;
import com.hazelcast.nio.ascii.SocketTextReader;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.logging.Level;

class ReadHandler
extends AbstractSelectionHandler
implements Runnable {
    final ByteBuffer inBuffer;
    final ByteBuffer protocolBuffer = ByteBuffer.allocate(3);
    SocketReader socketReader = null;
    volatile long lastRegistration = 0L;
    volatile long lastHandle;

    public ReadHandler(Connection connection) {
        super(connection, connection.getInOutSelector());
        this.inBuffer = ByteBuffer.allocate(this.connectionManager.SOCKET_RECEIVE_BUFFER_SIZE);
    }

    public final void handle() {
        this.lastHandle = System.currentTimeMillis();
        if (!this.connection.live()) {
            this.logger.log(Level.FINEST, ">>>> We are being to asked to read, but connection is not live so we won't");
            return;
        }
        try {
            int readBytes;
            if (this.socketReader == null) {
                readBytes = this.socketChannel.read(this.protocolBuffer);
                if (readBytes == -1) {
                    throw new EOFException();
                }
                if (!this.protocolBuffer.hasRemaining()) {
                    String protocol = new String(this.protocolBuffer.array());
                    WriteHandler writeHandler = this.connection.getWriteHandler();
                    if ("HZC".equals(protocol)) {
                        writeHandler.setProtocol("HZC");
                        this.socketReader = new SocketPacketReader(this.socketChannel, this.connection);
                    } else {
                        writeHandler.setProtocol("TEXT");
                        this.inBuffer.put(this.protocolBuffer.array());
                        this.socketReader = new SocketTextReader(this.connection);
                        this.connection.getConnectionManager().incrementTextConnections();
                    }
                }
            }
            if (this.socketReader == null) {
                return;
            }
            readBytes = this.socketChannel.read(this.inBuffer);
            if (readBytes == -1) {
                throw new EOFException();
            }
        }
        catch (Throwable e) {
            this.handleSocketException(e);
            return;
        }
        try {
            if (this.inBuffer.position() == 0) {
                return;
            }
            this.inBuffer.flip();
            this.socketReader.read(this.inBuffer);
            if (this.inBuffer.hasRemaining()) {
                this.inBuffer.compact();
            } else {
                this.inBuffer.clear();
            }
        }
        catch (Throwable t) {
            this.handleSocketException(t);
        }
    }

    public final void run() {
        this.lastRegistration = System.currentTimeMillis();
        this.registerOp(this.inOutSelector.selector, 1);
    }
}

