/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.GroupProperties;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.base.CallState;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataHolder;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.util.ByteUtil;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Packet
implements SocketWritable {
    public String name;
    public ClusterOperation operation = ClusterOperation.NONE;
    public final ByteBuffer bbSizes = ByteBuffer.allocate(13);
    public final ByteBuffer bbHeader = ByteBuffer.allocate(500);
    private DataHolder key = null;
    private DataHolder value = null;
    public Long[] indexes = null;
    public byte[] indexTypes = null;
    public long txnId = -1L;
    public int threadId = -1;
    public int lockCount = 0;
    public Address lockAddress = null;
    public long timeout = -1L;
    public long ttl = -1L;
    public int blockId = -1;
    public byte responseType = (byte)2;
    public long longValue = Long.MIN_VALUE;
    public long version = -1L;
    public long callId = -1L;
    public Connection conn;
    public int totalSize = 0;
    boolean sizeRead = false;
    int totalWritten = 0;
    public boolean client = false;
    public CallState callState = null;
    public static final byte PACKET_VERSION = GroupProperties.PACKET_VERSION.getByte();
    private static final Map<String, byte[]> mapStringByteCache = new ConcurrentHashMap<String, byte[]>(1000);

    private static void putString(ByteBuffer bb, String str) {
        if (str == null) {
            bb.putInt(0);
        } else {
            byte[] bytes = mapStringByteCache.get(str);
            if (bytes == null) {
                bytes = str.getBytes();
                if (mapStringByteCache.size() >= 10000) {
                    mapStringByteCache.clear();
                }
                mapStringByteCache.put(str, bytes);
            }
            bb.putInt(bytes.length);
            bb.put(bytes);
        }
    }

    private static String getString(ByteBuffer bb) {
        int length = bb.getInt();
        if (length == 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        bb.get(bytes, 0, length);
        return new String(bytes);
    }

    protected void writeBoolean(ByteBuffer bb, boolean value) {
        bb.put(value ? (byte)1 : 0);
    }

    protected boolean readBoolean(ByteBuffer bb) {
        return bb.get() == 1;
    }

    public void onEnqueue() {
        this.bbSizes.clear();
        this.bbHeader.clear();
        this.bbHeader.put(this.operation.getValue());
        this.bbHeader.putInt(this.blockId);
        this.bbHeader.putInt(this.threadId);
        byte booleans = 0;
        if (this.lockCount != 0) {
            booleans = ByteUtil.setTrue(booleans, 0);
        }
        if (this.timeout != -1L) {
            booleans = ByteUtil.setTrue(booleans, 1);
        }
        if (this.ttl != -1L) {
            booleans = ByteUtil.setTrue(booleans, 2);
        }
        if (this.txnId != -1L) {
            booleans = ByteUtil.setTrue(booleans, 3);
        }
        if (this.longValue != Long.MIN_VALUE) {
            booleans = ByteUtil.setTrue(booleans, 4);
        }
        if (this.version != -1L) {
            booleans = ByteUtil.setTrue(booleans, 5);
        }
        if (this.client) {
            booleans = ByteUtil.setTrue(booleans, 6);
        }
        if (this.lockAddress == null) {
            booleans = ByteUtil.setTrue(booleans, 7);
        }
        this.bbHeader.put(booleans);
        if (this.lockCount != 0) {
            this.bbHeader.putInt(this.lockCount);
        }
        if (this.timeout != -1L) {
            this.bbHeader.putLong(this.timeout);
        }
        if (this.ttl != -1L) {
            this.bbHeader.putLong(this.ttl);
        }
        if (this.txnId != -1L) {
            this.bbHeader.putLong(this.txnId);
        }
        if (this.longValue != Long.MIN_VALUE) {
            this.bbHeader.putLong(this.longValue);
        }
        if (this.version != -1L) {
            this.bbHeader.putLong(this.version);
        }
        if (this.lockAddress != null) {
            this.lockAddress.writeObject(this.bbHeader);
        }
        this.bbHeader.putLong(this.callId);
        this.bbHeader.put(this.responseType);
        Packet.putString(this.bbHeader, this.name);
        byte indexCount = this.indexes == null ? (byte)0 : (byte)this.indexes.length;
        this.bbHeader.put(indexCount);
        for (byte i = 0; i < indexCount; i = (byte)(i + 1)) {
            this.bbHeader.putLong(this.indexes[i]);
            this.bbHeader.put(this.indexTypes[i]);
        }
        this.bbHeader.putInt(this.key == null ? -1 : this.key.partitionHash);
        this.bbHeader.putInt(this.value == null ? -1 : this.value.partitionHash);
        this.bbHeader.flip();
        this.bbSizes.putInt(this.bbHeader.limit());
        this.bbSizes.putInt(this.key == null ? 0 : this.key.size);
        this.bbSizes.putInt(this.value == null ? 0 : this.value.size);
        this.bbSizes.put(PACKET_VERSION);
        this.bbSizes.flip();
        this.totalSize = 0;
        this.totalSize += this.bbSizes.limit();
        this.totalSize += this.bbHeader.limit();
        this.totalSize += this.key == null ? 0 : this.key.size;
        this.totalSize += this.value == null ? 0 : this.value.size;
    }

    public void read() {
        this.operation = ClusterOperation.create(this.bbHeader.get());
        this.blockId = this.bbHeader.getInt();
        this.threadId = this.bbHeader.getInt();
        byte booleans = this.bbHeader.get();
        if (ByteUtil.isTrue(booleans, 0)) {
            this.lockCount = this.bbHeader.getInt();
        }
        if (ByteUtil.isTrue(booleans, 1)) {
            this.timeout = this.bbHeader.getLong();
        }
        if (ByteUtil.isTrue(booleans, 2)) {
            this.ttl = this.bbHeader.getLong();
        }
        if (ByteUtil.isTrue(booleans, 3)) {
            this.txnId = this.bbHeader.getLong();
        }
        if (ByteUtil.isTrue(booleans, 4)) {
            this.longValue = this.bbHeader.getLong();
        }
        if (ByteUtil.isTrue(booleans, 5)) {
            this.version = this.bbHeader.getLong();
        }
        this.client = ByteUtil.isTrue(booleans, 6);
        boolean lockAddressNull = ByteUtil.isTrue(booleans, 7);
        if (!lockAddressNull) {
            this.lockAddress = new Address();
            this.lockAddress.readObject(this.bbHeader);
        }
        this.callId = this.bbHeader.getLong();
        this.responseType = this.bbHeader.get();
        this.name = Packet.getString(this.bbHeader);
        byte indexCount = this.bbHeader.get();
        if (indexCount > 0) {
            this.indexes = new Long[indexCount];
            this.indexTypes = new byte[indexCount];
            for (byte i = 0; i < indexCount; i = (byte)(i + 1)) {
                this.indexes[i] = this.bbHeader.getLong();
                this.indexTypes[i] = this.bbHeader.get();
            }
        }
        int keyPartitionHash = this.bbHeader.getInt();
        int valuePartitionHash = this.bbHeader.getInt();
        if (this.key != null) {
            this.key.setPartitionHash(keyPartitionHash);
        }
        if (this.value != null) {
            this.value.setPartitionHash(valuePartitionHash);
        }
    }

    public void clearForResponse() {
        this.name = null;
        this.key = null;
        this.value = null;
        this.blockId = -1;
        this.timeout = -1L;
        this.ttl = -1L;
        this.txnId = -1L;
        this.threadId = -1;
        this.lockAddress = null;
        this.lockCount = 0;
        this.longValue = Long.MIN_VALUE;
        this.version = -1L;
        this.indexes = null;
        this.indexTypes = null;
    }

    public void reset() {
        this.name = null;
        this.operation = ClusterOperation.NONE;
        this.threadId = -1;
        this.lockCount = 0;
        this.lockAddress = null;
        this.timeout = -1L;
        this.ttl = -1L;
        this.txnId = -1L;
        this.responseType = (byte)2;
        this.blockId = -1;
        this.longValue = Long.MIN_VALUE;
        this.version = -1L;
        this.callId = -1L;
        this.client = false;
        this.bbSizes.clear();
        this.bbHeader.clear();
        this.key = null;
        this.value = null;
        this.conn = null;
        this.totalSize = 0;
        this.totalWritten = 0;
        this.sizeRead = false;
        this.indexes = null;
        this.indexTypes = null;
        this.callState = null;
    }

    public String toString() {
        int keySize = this.key == null ? 0 : this.key.size();
        int valueSize = this.getValueData() == null ? 0 : this.getValueData().size();
        Object str = null;
        if (this.operation == ClusterOperation.REMOTELY_PROCESS) {
            str = IOUtil.toObject(this.value.toData());
        }
        return "Packet [" + (Object)((Object)this.operation) + "] name=" + this.name + ", connection=" + this.conn + ",blockId=" + this.blockId + ", keySize=" + keySize + ", valueSize=" + valueSize + " client=" + this.client + " obj=" + str + " callId=" + this.callId;
    }

    public void flipBuffers() {
        this.bbSizes.flip();
        this.bbHeader.flip();
    }

    public final boolean writeToSocketBuffer(ByteBuffer dest) {
        this.totalWritten += IOUtil.copyToHeapBuffer(this.bbSizes, dest);
        this.totalWritten += IOUtil.copyToHeapBuffer(this.bbHeader, dest);
        if (this.key != null && this.key.size() > 0) {
            this.totalWritten += IOUtil.copyToHeapBuffer(this.key.buffer, dest);
        }
        if (this.getValueData() != null && this.getValueData().size() > 0) {
            this.totalWritten += IOUtil.copyToHeapBuffer(this.value.buffer, dest);
        }
        return this.totalWritten >= this.totalSize;
    }

    public final boolean read(ByteBuffer bb) {
        while (!this.sizeRead && bb.hasRemaining() && this.bbSizes.hasRemaining()) {
            IOUtil.copyToHeapBuffer(bb, this.bbSizes);
        }
        if (!this.sizeRead && !this.bbSizes.hasRemaining()) {
            this.sizeRead = true;
            this.bbSizes.flip();
            this.bbHeader.limit(this.bbSizes.getInt());
            int keySize = this.bbSizes.getInt();
            int valueSize = this.bbSizes.getInt();
            if (keySize > 0) {
                this.key = new DataHolder(keySize);
            }
            if (valueSize > 0) {
                this.value = new DataHolder(valueSize);
            }
            if (this.bbHeader.limit() == 0) {
                throw new RuntimeException("read.bbHeader size cannot be 0");
            }
            byte packetVersion = this.bbSizes.get();
            if (packetVersion != PACKET_VERSION) {
                String msg = "Packet versions are not the same. Expected " + PACKET_VERSION + " Found: " + packetVersion;
                throw new RuntimeException(msg);
            }
        }
        if (this.sizeRead) {
            while (bb.hasRemaining() && this.bbHeader.hasRemaining()) {
                IOUtil.copyToHeapBuffer(bb, this.bbHeader);
            }
            while (this.key != null && bb.hasRemaining() && this.key.shouldRead()) {
                this.key.read(bb);
            }
            while (this.getValueData() != null && bb.hasRemaining() && this.value.shouldRead()) {
                this.value.read(bb);
            }
        }
        if (!(!this.sizeRead || this.bbHeader.hasRemaining() || this.key != null && this.key.shouldRead() || this.value != null && this.value.shouldRead())) {
            this.sizeRead = false;
            if (this.key != null) {
                this.key.postRead();
            }
            if (this.value != null) {
                this.value.postRead();
            }
            return true;
        }
        return false;
    }

    public void set(String name, ClusterOperation operation, Object objKey, Object objValue) {
        this.threadId = ThreadContext.get().getThreadId();
        this.name = name;
        this.operation = operation;
        if (objKey != null) {
            if (objKey instanceof Data) {
                this.setKey((Data)objKey);
            } else {
                this.key = new DataHolder(ThreadContext.get().toData(objKey));
            }
        }
        if (objValue != null) {
            if (objValue instanceof Data) {
                this.setValue((Data)objValue);
            } else {
                this.value = new DataHolder(ThreadContext.get().toData(objValue));
            }
        }
    }

    public void setFromConnection(Connection conn) {
        this.conn = conn;
        if (this.lockAddress == null) {
            this.lockAddress = conn.getEndPoint();
        }
    }

    public DataHolder getKey() {
        return this.key;
    }

    public DataHolder getValue() {
        return this.value;
    }

    public Data getKeyData() {
        return this.key == null ? null : this.key.toData();
    }

    public Data getValueData() {
        return this.value == null ? null : this.value.toData();
    }

    public void setKey(Data key) {
        this.key = key == null || key.size() == 0 ? null : new DataHolder(key);
    }

    public void setValue(Data value) {
        this.value = value == null || value.size() == 0 ? null : new DataHolder(value);
    }
}

