/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.ConnectionMonitor;
import com.hazelcast.nio.InOutSelector;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.ReadHandler;
import com.hazelcast.nio.SocketChannelWrapper;
import com.hazelcast.nio.WriteHandler;
import com.hazelcast.util.SimpleBoundedQueue;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.logging.Level;

public final class Connection {
    final SocketChannelWrapper socketChannel;
    final ReadHandler readHandler;
    final WriteHandler writeHandler;
    final ConnectionManager connectionManager;
    final InOutSelector inOutSelector;
    private volatile boolean live = true;
    private volatile Type type = Type.NONE;
    Address endPoint = null;
    private final ILogger logger;
    private final int connectionId;
    private final SimpleBoundedQueue<Packet> packetQueue = new SimpleBoundedQueue(100);
    private ConnectionMonitor monitor;

    public Connection(ConnectionManager connectionManager, InOutSelector inOutSelector, int connectionId, SocketChannelWrapper socketChannel) {
        this.inOutSelector = inOutSelector;
        this.connectionId = connectionId;
        this.logger = connectionManager.ioService.getLogger(Connection.class.getName());
        this.connectionManager = connectionManager;
        this.socketChannel = socketChannel;
        this.writeHandler = new WriteHandler(this);
        this.readHandler = new ReadHandler(this);
    }

    public Type getType() {
        return this.type;
    }

    public void releasePacket(Packet packet) {
        this.packetQueue.offer(packet);
    }

    public Packet obtainPacket() {
        Packet packet = this.packetQueue.poll();
        if (packet == null) {
            packet = new Packet();
        } else {
            packet.reset();
        }
        return packet;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public boolean isClient() {
        return this.type != null && this.type != Type.NONE && this.type.isClient();
    }

    public void setType(Type type) {
        if (this.type == Type.NONE) {
            this.type = type;
        }
    }

    public SocketChannelWrapper getSocketChannelWrapper() {
        return this.socketChannel;
    }

    public ReadHandler getReadHandler() {
        return this.readHandler;
    }

    public WriteHandler getWriteHandler() {
        return this.writeHandler;
    }

    public InOutSelector getInOutSelector() {
        return this.inOutSelector;
    }

    public boolean live() {
        return this.live;
    }

    public Address getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(Address endPoint) {
        this.endPoint = endPoint;
    }

    public void setMonitor(ConnectionMonitor monitor) {
        this.monitor = monitor;
    }

    public ConnectionMonitor getMonitor() {
        return this.monitor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection that = (Connection)o;
        return this.connectionId == that.getConnectionId();
    }

    public int hashCode() {
        return this.connectionId;
    }

    public void close0() throws IOException {
        if (!this.live) {
            return;
        }
        this.live = false;
        if (this.socketChannel != null && this.socketChannel.isOpen()) {
            this.socketChannel.close();
        }
        this.readHandler.shutdown();
        this.writeHandler.shutdown();
    }

    public void close() {
        this.close(null);
    }

    public void close(Throwable t) {
        try {
            this.close0();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        this.logger.log(Level.INFO, "Connection lost " + this.socketChannel.socket().getRemoteSocketAddress());
        this.connectionManager.destroyConnection(this);
        this.connectionManager.ioService.disconnectExistingCalls(this.endPoint);
        if (t != null && this.monitor != null) {
            this.monitor.onError(t);
        }
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public String toString() {
        Socket socket = this.socketChannel.socket();
        SocketAddress remoteSocketAddress = socket != null ? socket.getRemoteSocketAddress() : null;
        return "Connection [" + remoteSocketAddress + " -> " + this.endPoint + "] live=" + this.live + ", client=" + this.isClient() + ", type=" + (Object)((Object)this.type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NONE(false, false),
        MEMBER(true, true),
        CLIENT(false, true),
        REST_CLIENT(false, false),
        MEMCACHE_CLIENT(false, false);

        final boolean member;
        final boolean binary;

        private Type(boolean member, boolean binary) {
            this.member = member;
            this.binary = binary;
        }

        public boolean isBinary() {
            return this.binary;
        }

        public boolean isClient() {
            return !this.member;
        }
    }
}

