/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.impl.ExecutorThreadFactory;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.jmx.ClusterMBean;
import com.hazelcast.jmx.DataMBean;
import com.hazelcast.jmx.ObjectNameSpec;
import com.hazelcast.jmx.StatisticsCollector;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.lang.management.ManagementFactory;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class ManagementService {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static volatile ScheduledThreadPoolExecutor statCollectors;
    private final ILogger logger;
    private final FactoryImpl instance;
    private String name;
    private boolean started = false;

    public ManagementService(FactoryImpl instance) {
        this.instance = instance;
        this.logger = instance.node.getLogger(ManagementService.class.getName());
    }

    public HazelcastInstance getInstance() {
        return this.instance;
    }

    private synchronized void start() {
        boolean jmxProperty = this.instance.node.groupProperties.ENABLE_JMX.getBoolean();
        if (!jmxProperty) {
            return;
        }
        this.logger.log(Level.INFO, "Hazelcast JMX agent enabled");
        if (this.showDetails() && statCollectors == null) {
            statCollectors = new ScheduledThreadPoolExecutor(2, new ExecutorThreadFactory(null, "jmx", null));
        }
        this.started = true;
    }

    private void nameLookup() throws MalformedObjectNameException {
        MBeanServer mbs = ManagementService.mBeanServer();
        int idx = -1;
        Set<ObjectInstance> queryNames = mbs.queryMBeans(ObjectNameSpec.getClustersFilter(), null);
        for (ObjectInstance object : queryNames) {
            String name = object.getObjectName().getKeyProperty("name");
            try {
                idx = Math.max(idx, Integer.parseInt(name));
            }
            catch (NumberFormatException e) {}
        }
        this.name = Integer.toString(idx + 1);
    }

    public synchronized void register() {
        if (!this.started) {
            this.start();
        }
        if (!this.started) {
            return;
        }
        MBeanServer mbs = ManagementService.mBeanServer();
        try {
            this.nameLookup();
            ClusterMBean clusterMBean = new ClusterMBean(this, this.name);
            mbs.registerMBean(clusterMBean, clusterMBean.getObjectName());
            DataMBean dataMBean = new DataMBean(this);
            dataMBean.setParentName(clusterMBean.getRootName());
            mbs.registerMBean(dataMBean, dataMBean.getObjectName());
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Unable to start JMX service", e);
            return;
        }
        counter.incrementAndGet();
    }

    public synchronized void unregister() {
        if (!this.started) {
            return;
        }
        MBeanServer mbs = ManagementService.mBeanServer();
        try {
            Set<ObjectName> entries = mbs.queryNames(ObjectNameSpec.getClusterNameFilter(this.name), null);
            for (ObjectName name : entries) {
                if (!mbs.isRegistered(name)) continue;
                mbs.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.FINEST, "Error unregistering MBeans", e);
        }
        counter.decrementAndGet();
    }

    private static MBeanServer mBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    public static synchronized void shutdown() {
        if (counter.get() > 0) {
            return;
        }
        MBeanServer mbs = ManagementService.mBeanServer();
        try {
            Set<ObjectName> entries = mbs.queryNames(new ObjectName("com.hazelcast:*"), null);
            for (ObjectName name : entries) {
                if (!mbs.isRegistered(name)) continue;
                mbs.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            Logger.getLogger("hz.ManagementCenter").log(Level.FINEST, "Error unregistering MBeans", e);
        }
        if (statCollectors != null) {
            statCollectors.shutdownNow();
            statCollectors = null;
        }
    }

    final boolean showDetails() {
        return this.instance.node.groupProperties.ENABLE_JMX_DETAILED.getBoolean();
    }

    public static StatisticsCollector newStatisticsCollector() {
        if (statCollectors != null) {
            long interval = 1L;
            ScheduledCollector collector = new ScheduledCollector(interval);
            ScheduledFuture<?> future = statCollectors.scheduleWithFixedDelay(collector, interval, interval, TimeUnit.SECONDS);
            collector.setScheduledFuture(future);
            return collector;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ScheduledCollector
    implements Runnable,
    StatisticsCollector {
        private final long interval;
        private volatile long events = 0L;
        private volatile long total = 0L;
        private volatile double min = 9.223372036854776E18;
        private volatile double max = 0.0;
        private volatile double average = 0.0;
        private ScheduledFuture<StatisticsCollector> future;

        public ScheduledCollector(long interval) {
            this.interval = interval;
        }

        @Override
        public synchronized void run() {
            this.average = (double)this.events / (double)this.interval;
            this.events = 0L;
            this.min = this.average < this.min ? this.average : this.min;
            this.max = this.average > this.max ? this.average : this.max;
        }

        private void setScheduledFuture(ScheduledFuture<StatisticsCollector> future) {
            this.future = future;
        }

        @Override
        public void destroy() {
            this.future.cancel(true);
        }

        @Override
        public synchronized void addEvent() {
            ++this.events;
            ++this.total;
        }

        @Override
        public synchronized void reset() {
            this.events = 0L;
            this.min = 9.223372036854776E18;
            this.max = 0.0;
            this.average = 0.0;
        }

        @Override
        public long getEvents() {
            return this.events;
        }

        @Override
        public long getTotal() {
            return this.total;
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double getMax() {
            return this.max;
        }

        @Override
        public double getAverage() {
            return this.average;
        }

        @Override
        public long getInterval() {
            return this.interval;
        }
    }
}

