/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.impl.base.CallStateLog;
import com.hazelcast.nio.Address;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallState {
    private final long callId;
    private final Address caller;
    private final int callerThreadId;
    private final Queue<CallStateLog> logQ = new LinkedBlockingQueue<CallStateLog>(1000);
    private final Queue<Address> targets = new LinkedBlockingQueue<Address>(10);

    public CallState(long callId, Address caller, int callerThreadId) {
        this.callId = callId;
        this.caller = caller;
        this.callerThreadId = callerThreadId;
    }

    public void addLog(CallStateLog log) {
        this.logQ.offer(log);
    }

    public void addTarget(Address target) {
        this.targets.offer(target);
    }

    public Address getCaller() {
        return this.caller;
    }

    public int getCallerThreadId() {
        return this.callerThreadId;
    }

    public Queue<Address> getTargets() {
        return this.targets;
    }

    public long getCallId() {
        return this.callId;
    }

    public Queue<CallStateLog> getLogQ() {
        return this.logQ;
    }
}

