/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.ClusterImpl;
import com.hazelcast.cluster.ClusterManager;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.config.Config;
import com.hazelcast.config.Join;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.impl.AddressPicker;
import com.hazelcast.impl.BlockingQueueManager;
import com.hazelcast.impl.ClientService;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.ExecutorManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.GroupProperties;
import com.hazelcast.impl.Joiner;
import com.hazelcast.impl.ListenerManager;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.MulticastJoiner;
import com.hazelcast.impl.MulticastService;
import com.hazelcast.impl.NodeBaseVariables;
import com.hazelcast.impl.NodeMulticastListener;
import com.hazelcast.impl.NodeType;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.TcpIpJoiner;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TopicManager;
import com.hazelcast.impl.Util;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.TextCommandServiceImpl;
import com.hazelcast.impl.base.CallStateService;
import com.hazelcast.impl.base.CpuUtilization;
import com.hazelcast.impl.base.NodeInitializer;
import com.hazelcast.impl.base.NodeInitializerFactory;
import com.hazelcast.impl.base.VersionCheck;
import com.hazelcast.impl.management.ManagementCenterService;
import com.hazelcast.impl.wan.WanReplicationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingServiceImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.NodeIOService;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.Serializer;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.util.ConcurrentHashSet;
import com.hazelcast.util.SimpleBoundedQueue;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.channels.ServerSocketChannel;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private final ILogger logger;
    private AtomicBoolean joined = new AtomicBoolean(false);
    private volatile boolean active = false;
    private volatile boolean outOfMemory = false;
    private volatile boolean completelyShutdown = false;
    private final ClusterImpl clusterImpl;
    private final Set<Address> failedConnections = new ConcurrentHashSet<Address>();
    private final NodeShutdownHookThread shutdownHookThread = new NodeShutdownHookThread("hz.ShutdownThread");
    private final boolean liteMember;
    private final NodeType localNodeType;
    final NodeBaseVariables baseVariables;
    public final ConcurrentMapManager concurrentMapManager;
    public final BlockingQueueManager blockingQueueManager;
    public final ClusterManager clusterManager;
    public final TopicManager topicManager;
    public final ListenerManager listenerManager;
    public final ClusterService clusterService;
    public final ExecutorManager executorManager;
    public final MulticastService multicastService;
    public final ConnectionManager connectionManager;
    public final ClientService clientService;
    public final TextCommandServiceImpl textCommandService;
    public final Config config;
    public final GroupProperties groupProperties;
    public final ThreadGroup threadGroup;
    final Address address;
    final MemberImpl localMember;
    volatile Address masterAddress = null;
    volatile Thread serviceThread = null;
    public final FactoryImpl factory;
    private final int buildNumber;
    public final LoggingServiceImpl loggingService;
    private static final AtomicInteger counter = new AtomicInteger();
    private final CpuUtilization cpuUtilization = new CpuUtilization();
    private final CallStateService callStateService = new CallStateService();
    final SimpleBoundedQueue<Packet> serviceThreadPacketQueue = new SimpleBoundedQueue(1000);
    final int id = counter.incrementAndGet();
    final WanReplicationService wanReplicationService;
    final Joiner joiner;
    public final NodeInitializer initializer;
    private ManagementCenterService managementCenterService = null;
    public final SecurityContext securityContext;

    public Node(FactoryImpl factory, Config config) {
        this.threadGroup = new ThreadGroup(factory.getName());
        this.factory = factory;
        this.config = config;
        this.groupProperties = new GroupProperties(config);
        this.liteMember = config.isLiteMember();
        this.localNodeType = this.liteMember ? NodeType.LITE_MEMBER : NodeType.MEMBER;
        ServerSocketChannel serverSocketChannel = null;
        Address localAddress = null;
        try {
            String preferIPv4Stack = System.getProperty("java.net.preferIPv4Stack");
            String preferIPv6Address = System.getProperty("java.net.preferIPv6Addresses");
            if (preferIPv6Address == null && preferIPv4Stack == null) {
                System.setProperty("java.net.preferIPv4Stack", "true");
            }
            serverSocketChannel = ServerSocketChannel.open();
            AddressPicker addressPicker = new AddressPicker(this, serverSocketChannel);
            localAddress = addressPicker.pickAddress();
            localAddress.setThisAddress(true);
        }
        catch (Throwable e) {
            Util.throwUncheckedException(e);
        }
        this.address = localAddress;
        this.localMember = new MemberImpl(this.address, true, this.localNodeType);
        String loggingType = this.groupProperties.LOGGING_TYPE.getString();
        this.loggingService = new LoggingServiceImpl(config.getGroupConfig().getName(), loggingType, this.localMember);
        this.logger = this.loggingService.getLogger(Node.class.getName());
        this.initializer = NodeInitializerFactory.create();
        this.initializer.beforeInitialize(this);
        this.securityContext = config.getSecurityConfig().isEnabled() ? this.initializer.getSecurityContext() : null;
        this.clusterImpl = new ClusterImpl(this, this.localMember);
        this.baseVariables = new NodeBaseVariables(this.address, this.localMember);
        this.clusterService = new ClusterService(this);
        this.clusterService.start();
        this.connectionManager = new ConnectionManager(new NodeIOService(this), serverSocketChannel);
        this.clusterManager = new ClusterManager(this);
        this.executorManager = new ExecutorManager(this);
        this.clientService = new ClientService(this);
        this.concurrentMapManager = new ConcurrentMapManager(this);
        this.blockingQueueManager = new BlockingQueueManager(this);
        this.listenerManager = new ListenerManager(this);
        this.topicManager = new TopicManager(this);
        this.textCommandService = new TextCommandServiceImpl(this);
        this.clusterManager.addMember(false, this.localMember);
        this.initializer.printNodeInfo(this);
        this.buildNumber = this.initializer.getBuildNumber();
        VersionCheck.check(this, this.initializer.getBuild(), this.initializer.getVersion());
        Join join = config.getNetworkConfig().getJoin();
        MulticastService mcService = null;
        try {
            if (join.getMulticastConfig().isEnabled()) {
                MulticastConfig multicastConfig = join.getMulticastConfig();
                MulticastSocket multicastSocket = new MulticastSocket(null);
                multicastSocket.setReuseAddress(true);
                multicastSocket.bind(new InetSocketAddress(multicastConfig.getMulticastPort()));
                multicastSocket.setTimeToLive(multicastConfig.getMulticastTimeToLive());
                multicastSocket.setInterface(this.address.getInetAddress());
                multicastSocket.setReceiveBufferSize(65536);
                multicastSocket.setSendBufferSize(65536);
                String multicastGroup = System.getProperty("hazelcast.multicast.group");
                if (multicastGroup == null) {
                    multicastGroup = multicastConfig.getMulticastGroup();
                }
                multicastConfig.setMulticastGroup(multicastGroup);
                multicastSocket.joinGroup(InetAddress.getByName(multicastGroup));
                multicastSocket.setSoTimeout(1000);
                mcService = new MulticastService(this, multicastSocket);
                mcService.addMulticastListener(new NodeMulticastListener(this));
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.multicastService = mcService;
        this.wanReplicationService = new WanReplicationService(this);
        this.initializeListeners(config);
        this.joiner = this.createJoiner();
    }

    public CallStateService getCallStateService() {
        return this.callStateService;
    }

    private void initializeListeners(Config config) {
        for (ListenerConfig listenerCfg : config.getListenerConfigs()) {
            Object listener = listenerCfg.getImplementation();
            if (listener == null) {
                try {
                    listener = Serializer.newInstance(Serializer.loadClass(listenerCfg.getClassName()));
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (listener instanceof InstanceListener) {
                this.factory.addInstanceListener((InstanceListener)listener);
                continue;
            }
            if (listener instanceof MembershipListener) {
                this.clusterImpl.addMembershipListener((MembershipListener)listener);
                continue;
            }
            if (listener instanceof MigrationListener) {
                this.concurrentMapManager.partitionServiceImpl.addMigrationListener((MigrationListener)listener);
                continue;
            }
            if (listener == null) continue;
            String error = "Unknown listener type: " + listener.getClass();
            IllegalArgumentException t = new IllegalArgumentException(error);
            this.logger.log(Level.WARNING, error, t);
        }
    }

    public void failedConnection(Address address) {
        this.logger.log(Level.FINEST, this.getThisAddress() + " failed connecting to " + address);
        this.failedConnections.add(address);
    }

    public ClusterImpl getClusterImpl() {
        return this.clusterImpl;
    }

    public final NodeType getLocalNodeType() {
        return this.localNodeType;
    }

    public Address getMasterAddress() {
        return this.masterAddress;
    }

    public Address getThisAddress() {
        return this.address;
    }

    public String getName() {
        return this.factory.getName();
    }

    public String getThreadNamePrefix(String name) {
        return "hz." + this.getName() + "." + name;
    }

    public String getThreadPoolNamePrefix(String poolName) {
        return this.getThreadNamePrefix(poolName) + ".thread-";
    }

    public void handleInterruptedException(Thread thread, Exception e) {
        this.logger.log(Level.FINEST, thread.getName() + " is interrupted ", e);
    }

    public void checkNodeState() {
        if (this.factory.restarted) {
            throw new IllegalStateException("Hazelcast Instance is restarted!");
        }
        if (!this.isActive()) {
            throw new IllegalStateException("Hazelcast Instance is not active!");
        }
    }

    public final boolean isLiteMember() {
        return this.liteMember;
    }

    public boolean joined() {
        return this.joined.get();
    }

    public boolean isMaster() {
        return this.address != null && this.address.equals(this.masterAddress);
    }

    public void setMasterAddress(Address master) {
        if (master != null) {
            this.logger.log(Level.FINE, "** setting master address to " + master.toString());
        }
        this.masterAddress = master;
    }

    public void cleanupServiceThread() {
        this.clusterManager.checkServiceThread();
        this.baseVariables.qServiceThreadPacketCache.clear();
        this.concurrentMapManager.reset();
        this.logger.log(Level.FINEST, "Shutting down the cluster manager");
        this.clusterManager.stop();
    }

    private void generateMemberUuid() {
        String uuid = UUID.randomUUID().toString();
        this.logger.log(Level.FINEST, "Generated new UUID for local member: " + uuid);
        this.localMember.setUuid(uuid);
    }

    public void shutdown(final boolean force, boolean now) {
        if (now) {
            this.doShutdown(force);
        } else {
            new Thread(new Runnable(){

                public void run() {
                    Node.this.doShutdown(force);
                }
            }).start();
        }
    }

    private void doShutdown(boolean force) {
        long start = System.currentTimeMillis();
        this.logger.log(Level.FINE, "** we are being asked to shutdown when active = " + String.valueOf(this.active));
        if (!force && this.isActive()) {
            int maxWaitSeconds = this.groupProperties.GRACEFUL_SHUTDOWN_MAX_WAIT.getInteger();
            int waitSeconds = 0;
            do {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (this.concurrentMapManager.partitionManager.hasActiveBackupTask() && ++waitSeconds < maxWaitSeconds);
            if (waitSeconds >= maxWaitSeconds) {
                this.logger.log(Level.WARNING, "Graceful shutdown could not be completed in " + maxWaitSeconds + " seconds!");
            }
        }
        if (this.isActive()) {
            this.joined.set(false);
            this.setActive(false);
            this.setMasterAddress(null);
            this.wanReplicationService.shutdown();
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            if (this.managementCenterService != null) {
                this.managementCenterService.shutdown();
            }
            this.logger.log(Level.FINEST, "Shutting down the clientService");
            this.clientService.shutdown();
            this.logger.log(Level.FINEST, "Shutting down the concurrentMapManager");
            this.concurrentMapManager.shutdown();
            this.logger.log(Level.FINEST, "Shutting down the cluster service");
            this.clusterService.stop();
            if (this.multicastService != null) {
                this.logger.log(Level.FINEST, "Shutting down the multicast service");
                this.multicastService.stop();
            }
            this.logger.log(Level.FINEST, "Shutting down the connection manager");
            this.connectionManager.shutdown();
            this.logger.log(Level.FINEST, "Shutting down the executorManager");
            this.executorManager.stop();
            this.textCommandService.stop();
            this.masterAddress = null;
            if (this.securityContext != null) {
                this.securityContext.destroy();
            }
            this.initializer.destroy();
            int numThreads = this.threadGroup.activeCount();
            Thread[] threads = new Thread[numThreads * 2];
            numThreads = this.threadGroup.enumerate(threads, false);
            for (int i = 0; i < numThreads; ++i) {
                Thread thread = threads[i];
                this.logger.log(Level.FINEST, "Shutting down thread " + thread.getName());
                thread.interrupt();
            }
            this.failedConnections.clear();
            this.serviceThreadPacketQueue.clear();
            this.callStateService.shutdown();
            ThreadContext.get().shutdown(this.factory);
            this.logger.log(Level.INFO, "Hazelcast Shutdown is completed in " + (System.currentTimeMillis() - start) + " ms.");
        }
    }

    public void start() {
        this.logger.log(Level.FINEST, "We are asked to start and completelyShutdown is " + String.valueOf(this.completelyShutdown));
        if (this.completelyShutdown) {
            return;
        }
        this.generateMemberUuid();
        this.serviceThread = new Thread(this.threadGroup, this.clusterService, this.getThreadNamePrefix("ServiceThread"));
        this.serviceThread.setPriority(this.groupProperties.SERVICE_THREAD_PRIORITY.getInteger());
        this.logger.log(Level.FINEST, "Starting thread " + this.serviceThread.getName());
        this.serviceThread.start();
        this.connectionManager.start();
        if (this.config.getNetworkConfig().getJoin().getMulticastConfig().isEnabled()) {
            Thread multicastServiceThread = new Thread(this.threadGroup, this.multicastService, this.getThreadNamePrefix("MulticastThread"));
            multicastServiceThread.start();
        }
        this.setActive(true);
        if (!this.completelyShutdown) {
            this.logger.log(Level.FINEST, "Adding ShutdownHook");
            Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        }
        this.logger.log(Level.FINEST, "finished starting threads, calling join");
        this.join();
        int clusterSize = this.clusterImpl.getMembers().size();
        if (this.address.getPort() >= this.config.getPort() + clusterSize) {
            StringBuilder sb = new StringBuilder("Config seed port is ");
            sb.append(this.config.getPort());
            sb.append(" and cluster size is ");
            sb.append(clusterSize);
            sb.append(". Some of the ports seem occupied!");
            this.logger.log(Level.WARNING, sb.toString());
        }
        if (this.groupProperties.MANCENTER_ENABLED.getBoolean()) {
            try {
                this.managementCenterService = new ManagementCenterService(this.factory);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "ManagementCenterService could not be started!", e);
            }
        }
        this.initializer.afterInitialize(this);
    }

    public void onRestart() {
        this.generateMemberUuid();
    }

    public ILogger getLogger(String name) {
        return this.loggingService.getLogger(name);
    }

    public GroupProperties getGroupProperties() {
        return this.groupProperties;
    }

    public TextCommandService getTextCommandService() {
        return this.textCommandService;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutOfMemory(OutOfMemoryError e) {
        try {
            if (this.connectionManager != null) {
                this.connectionManager.shutdown();
                this.shutdown(true, false);
            }
        }
        catch (Throwable ignored) {
            this.logger.log(Level.FINEST, ignored.getMessage(), ignored);
        }
        finally {
            this.outOfMemory = true;
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public Set<Address> getFailedConnections() {
        return this.failedConnections;
    }

    public void setJoined() {
        this.joined.set(true);
    }

    public JoinInfo createJoinInfo() {
        return this.createJoinInfo(false);
    }

    public JoinInfo createJoinInfo(boolean withCredentials) {
        JoinInfo jr = new JoinInfo(this.getLogger(JoinInfo.class.getName()), true, this.address, this.config, this.getLocalNodeType(), Packet.PACKET_VERSION, this.buildNumber, this.clusterImpl.getMembers().size(), 0, this.localMember.getUuid());
        if (withCredentials && this.securityContext != null) {
            Credentials c = this.securityContext.getCredentialsFactory().newCredentials();
            jr.setCredentials(c);
        }
        return jr;
    }

    public boolean validateJoinRequest(JoinRequest joinRequest) throws Exception {
        boolean valid;
        boolean bl = valid = Packet.PACKET_VERSION == joinRequest.packetVersion && this.buildNumber == joinRequest.buildNumber;
        if (valid) {
            try {
                valid = this.config.isCompatible(joinRequest.config);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Invalid join request, reason:" + e.getMessage());
                throw e;
            }
        }
        return valid;
    }

    void rejoin() {
        this.masterAddress = null;
        this.joined.set(false);
        this.clusterImpl.reset();
        this.failedConnections.clear();
        this.join();
    }

    void join() {
        try {
            if (this.joiner == null) {
                this.logger.log(Level.WARNING, "No join method is enabled! Starting standalone.");
                this.setAsMaster();
            } else {
                this.joiner.join(this.joined);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage());
            this.factory.lifecycleService.restart();
        }
    }

    Joiner getJoiner() {
        return this.joiner;
    }

    Joiner createJoiner() {
        Join join = this.config.getNetworkConfig().getJoin();
        if (join.getMulticastConfig().isEnabled() && this.multicastService != null) {
            return new MulticastJoiner(this);
        }
        if (join.getTcpIpConfig().isEnabled()) {
            return new TcpIpJoiner(this);
        }
        if (join.getAwsConfig().isEnabled()) {
            try {
                Class<?> clazz = Class.forName("com.hazelcast.impl.TcpIpJoinerOverAWS");
                Constructor<?> constructor = clazz.getConstructor(Node.class);
                return (Joiner)constructor.newInstance(this);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, e.getMessage());
                return null;
            }
        }
        return null;
    }

    void setAsMaster() {
        this.logger.log(Level.FINEST, "This node is being set as the master");
        this.masterAddress = this.address;
        this.logger.log(Level.FINEST, "adding member myself");
        this.clusterManager.enqueueAndWait(new Processable(){

            public void process() {
                Node.this.clusterManager.addMember(Node.this.address, Node.this.getLocalNodeType(), Node.this.localMember.getUuid());
                Node.this.clusterImpl.setMembers(Node.this.baseVariables.lsMembers);
            }
        }, 5);
        this.setJoined();
    }

    public Config getConfig() {
        return this.config;
    }

    public ExecutorManager getExecutorManager() {
        return this.executorManager;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isOutOfMemory() {
        return this.outOfMemory;
    }

    public CpuUtilization getCpuUtilization() {
        return this.cpuUtilization;
    }

    public String toString() {
        return "Node[" + this.getName() + "]";
    }

    public class NodeShutdownHookThread
    extends Thread {
        NodeShutdownHookThread(String name) {
            super(name);
        }

        public void run() {
            try {
                if (Node.this.isActive() && !Node.this.completelyShutdown) {
                    Node.this.completelyShutdown = true;
                    if (Node.this.groupProperties.SHUTDOWNHOOK_ENABLED.getBoolean()) {
                        Node.this.shutdown(false, true);
                    }
                } else {
                    Node.this.logger.log(Level.FINEST, "shutdown hook - we are not --> active and not completely down so we are not calling shutdown");
                }
            }
            catch (Exception e) {
                Node.this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }
}

