/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.Instance;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.MultiMap;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.Block;
import com.hazelcast.impl.Blocks;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Constants;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.IRemoveAwareProxy;
import com.hazelcast.impl.LocalMapStatsImpl;
import com.hazelcast.impl.LocallyOwnedMap;
import com.hazelcast.impl.MapNearCache;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.PartitionManager;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.RecordEntry;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TransactionImpl;
import com.hazelcast.impl.base.AddressAwareException;
import com.hazelcast.impl.base.Call;
import com.hazelcast.impl.base.DataRecordEntry;
import com.hazelcast.impl.base.KeyValue;
import com.hazelcast.impl.base.PacketProcessor;
import com.hazelcast.impl.base.Pairs;
import com.hazelcast.impl.base.ScheduledAction;
import com.hazelcast.impl.concurrentmap.MultiData;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.QueryContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentMapManager
extends BaseManager {
    final int PARTITION_COUNT;
    final long GLOBAL_REMOVE_DELAY_MILLIS;
    final long CLEANUP_DELAY_MILLIS;
    final boolean LOG_STATE;
    long lastLogStateTime = System.currentTimeMillis();
    final Block[] blocks;
    final ConcurrentMap<String, CMap> maps;
    final ConcurrentMap<String, LocallyOwnedMap> mapLocallyOwnedMaps;
    final ConcurrentMap<String, MapNearCache> mapCaches;
    final OrderedExecutionTask[] orderedExecutionTasks;
    final PartitionManager partitionManager;
    long newRecordId = 0L;
    volatile long nextCleanup = 0L;

    ConcurrentMapManager(Node node) {
        super(node);
        this.PARTITION_COUNT = node.groupProperties.CONCURRENT_MAP_PARTITION_COUNT.getInteger();
        this.GLOBAL_REMOVE_DELAY_MILLIS = node.groupProperties.REMOVE_DELAY_SECONDS.getLong() * 1000L;
        this.CLEANUP_DELAY_MILLIS = node.groupProperties.CLEANUP_DELAY_SECONDS.getLong() * 1000L;
        this.LOG_STATE = node.groupProperties.LOG_STATE.getBoolean();
        this.blocks = new Block[this.PARTITION_COUNT];
        this.maps = new ConcurrentHashMap<String, CMap>(10);
        this.mapLocallyOwnedMaps = new ConcurrentHashMap<String, LocallyOwnedMap>(10);
        this.mapCaches = new ConcurrentHashMap<String, MapNearCache>(10);
        this.orderedExecutionTasks = new OrderedExecutionTask[this.PARTITION_COUNT];
        this.partitionManager = new PartitionManager(this);
        for (int i = 0; i < this.PARTITION_COUNT; ++i) {
            this.orderedExecutionTasks[i] = new OrderedExecutionTask();
        }
        node.clusterService.registerPeriodicRunnable(new FallThroughRunnable(){

            public void doRun() {
                ConcurrentMapManager.this.logState();
                long now = System.currentTimeMillis();
                Collection cmaps = ConcurrentMapManager.this.maps.values();
                for (CMap cmap : cmaps) {
                    if (cmap.cleanupState != CMap.CleanupState.SHOULD_CLEAN) continue;
                    ConcurrentMapManager.this.executeCleanup(cmap, true);
                }
                if (now > ConcurrentMapManager.this.nextCleanup) {
                    for (CMap cmap : cmaps) {
                        if (cmap.cleanupState != CMap.CleanupState.NONE) continue;
                        ConcurrentMapManager.this.executeCleanup(cmap, false);
                    }
                    ConcurrentMapManager.this.nextCleanup = now + ConcurrentMapManager.this.CLEANUP_DELAY_MILLIS;
                }
            }
        });
        node.clusterService.registerPeriodicRunnable(this.partitionManager);
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_GET_MAP_ENTRY, new GetMapEntryOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_GET, new GetOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_MERGE, new MergeOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_TRY_PUT, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_PUT, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_PUT_MULTI, new PutMultiOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REMOVE, new RemoveOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_EVICT, new EvictOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REMOVE_IF_SAME, new RemoveOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REMOVE_ITEM, new RemoveItemOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT, new BackupPacketProcessor());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_ADD, new BackupPacketProcessor());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE_MULTI, new BackupPacketProcessor());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE, new BackupPacketProcessor());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK, new BackupPacketProcessor());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_LOCK, new LockOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_LOCK_AND_GET_VALUE, new LockOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_UNLOCK, new UnlockOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_LOCK_MAP, new LockMapOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_UNLOCK_MAP, new LockMapOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES, new QueryOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ITERATE_VALUES, new QueryOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, new QueryOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS_ALL, new QueryOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_MIGRATE_RECORD, new MigrationOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REMOVE_MULTI, new RemoveMultiOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ADD_TO_LIST, new AddOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ADD_TO_SET, new AddOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_SIZE, new SizeOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_CONTAINS, new ContainsOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE, new ContainsValueOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BLOCK_INFO, new BlockInfoOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BLOCKS, new BlocksOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BLOCK_MIGRATION_CHECK, new BlockMigrationCheckHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_VALUE_COUNT, new ValueCountOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_INVALIDATE, new InvalidateOperationHandler());
        this.registerPacketProcessor(ClusterOperation.ATOMIC_NUMBER_GET_AND_SET, new AtomicOperationHandler());
        this.registerPacketProcessor(ClusterOperation.ATOMIC_NUMBER_GET_AND_ADD, new AtomicOperationHandler());
        this.registerPacketProcessor(ClusterOperation.ATOMIC_NUMBER_COMPARE_AND_SET, new AtomicOperationHandler());
        this.registerPacketProcessor(ClusterOperation.ATOMIC_NUMBER_ADD_AND_GET, new AtomicOperationHandler());
    }

    private void executeCleanup(final CMap cmap, final boolean forced) {
        if (cmap.cleanupState == CMap.CleanupState.CLEANING) {
            return;
        }
        cmap.cleanupState = CMap.CleanupState.CLEANING;
        this.executeLocally(new FallThroughRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doRun() {
                try {
                    cmap.startCleanup(forced);
                }
                catch (Exception e) {
                    try {
                        ConcurrentMapManager.this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        ConcurrentMapManager.this.enqueueAndReturn(new Processable(){

                            public void process() {
                                cmap.cleanupState = CMap.CleanupState.NONE;
                            }
                        });
                        throw throwable;
                    }
                    ConcurrentMapManager.this.enqueueAndReturn(new /* invalid duplicate definition of identical inner class */);
                }
                ConcurrentMapManager.this.enqueueAndReturn(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    public void onRestart() {
        this.enqueueAndWait(new Processable(){

            public void process() {
                ConcurrentMapManager.this.partitionManager.reset();
                for (CMap cmap : ConcurrentMapManager.this.maps.values()) {
                    cmap.reset();
                }
            }
        }, 5);
    }

    public void reset() {
        this.maps.clear();
        this.mapLocallyOwnedMaps.clear();
        this.mapCaches.clear();
    }

    public void syncForDead(MemberImpl deadMember) {
        this.partitionManager.syncForDead(deadMember);
    }

    public void syncForAdd() {
        this.partitionManager.syncForAdd();
    }

    public int hashBlocks() {
        int hash = 1;
        for (int i = 0; i < this.PARTITION_COUNT; ++i) {
            Block block = this.blocks[i];
            hash = hash * 31 + (block == null ? 0 : block.customHash());
        }
        return hash;
    }

    void logState() {
        long now = System.currentTimeMillis();
        if (this.LOG_STATE && now - this.lastLogStateTime > 15000L) {
            StringBuffer sbState = new StringBuffer(this.thisAddress + " State[" + new Date(now));
            sbState.append("]======================");
            for (Block block : this.blocks) {
                if (block == null || !block.isMigrating()) continue;
                sbState.append("\n");
                sbState.append(block);
            }
            Collection calls = this.mapCalls.values();
            for (Call call : calls) {
                if (call.getEnqueueCount() <= 15 && now - call.getFirstEnqueueTime() <= 15000L) continue;
                sbState.append("\n");
                sbState.append(call);
            }
            sbState.append("\nCall Count:" + calls.size());
            Collection cmaps = this.maps.values();
            for (CMap cmap : cmaps) {
                cmap.appendState(sbState);
            }
            this.node.blockingQueueManager.appendState(sbState);
            this.node.executorManager.appendState(sbState);
            long total = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory();
            sbState.append("\nCluster Size:" + this.lsMembers.size());
            sbState.append("\nUsed Memory:");
            sbState.append((total - free) / 1024L / 1024L);
            sbState.append("MB");
            this.logger.log(Level.INFO, sbState.toString());
            this.lastLogStateTime = now;
        }
    }

    void backupRecord(Record rec) {
        if (rec.getMultiValues() != null) {
            Set<Data> values = rec.getMultiValues();
            int initialVersion = (int)rec.getVersion() - values.size();
            int version = initialVersion < 0 ? 0 : initialVersion;
            for (Data value : values) {
                Record record = rec.copy();
                record.setValue(value);
                record.setVersion(++version);
                MBackupOp backupOp = new MBackupOp();
                backupOp.backup(record);
            }
        } else {
            MBackupOp backupOp = new MBackupOp();
            backupOp.backup(rec);
        }
    }

    void migrateRecord(CMap cmap, Record rec) {
        if (!this.node.isActive() || this.node.factory.restarted) {
            return;
        }
        MMigrate mmigrate = new MMigrate();
        if (cmap.isMultiMap()) {
            Set<Data> values = rec.getMultiValues();
            if (values == null || values.size() == 0) {
                mmigrate.migrateMulti(rec, null);
            } else {
                for (Data value : values) {
                    mmigrate.migrateMulti(rec, value);
                }
            }
        } else {
            boolean migrated = mmigrate.migrate(rec);
            if (!migrated) {
                this.logger.log(Level.FINEST, "Migration failed " + rec.getKey());
            }
        }
    }

    public boolean isOwned(Record record) {
        Block block = this.getOrCreateBlock(record.getBlockId());
        return this.thisAddress.equals(block.getOwner());
    }

    public int getPartitionCount() {
        return this.PARTITION_COUNT;
    }

    public Block[] getBlocks() {
        return this.blocks;
    }

    public PartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    public Map<String, CMap> getCMaps() {
        return this.maps;
    }

    public void destroy(String name) {
        this.maps.remove(name);
    }

    boolean isMapIndexed(String name) {
        CMap cmap = this.getMap(name);
        return cmap != null && cmap.getMapIndexService().hasIndexedAttributes();
    }

    void setIndexValues(Request request, Object value) {
        long[] indexes;
        CMap cmap = this.getMap(request.name);
        if (cmap != null && (indexes = cmap.getMapIndexService().getIndexValues(value)) != null) {
            byte[] indexTypes = cmap.getMapIndexService().getIndexTypes();
            request.setIndexes(indexes, indexTypes);
            for (byte b : indexTypes) {
                if (b != -1) continue;
                throw new RuntimeException("Index type cannot be -1: " + b);
            }
        }
    }

    void fireMapEvent(Map<Address, Boolean> mapListeners, String name, int eventType, Record record, Address callerAddress) {
        this.checkServiceThread();
        this.fireMapEvent(mapListeners, name, eventType, record.getKey(), record.getValue(), record.getListeners(), callerAddress);
    }

    public LocalMapStatsImpl getLocalMapStats(String name) {
        CMap cmap = this.getMap(name);
        if (cmap == null) {
            return new LocalMapStatsImpl();
        }
        return cmap.getLocalMapStats();
    }

    @Override
    public Address getKeyOwner(Data key) {
        this.checkServiceThread();
        int blockId = this.getBlockId(key);
        Block block = this.blocks[blockId];
        if (block == null) {
            if (this.isMaster() && !this.isSuperClient()) {
                block = this.getOrCreateBlock(blockId);
                block.setOwner(this.thisAddress);
            } else {
                return null;
            }
        }
        if (block.isMigrating()) {
            return null;
        }
        return block.getOwner();
    }

    @Override
    public boolean isMigrating(Request req) {
        return this.partitionManager.isMigrating(req);
    }

    public int getBlockId(Data key) {
        int hash = key.hashCode();
        return hash == Integer.MIN_VALUE ? 0 : Math.abs(hash) % this.PARTITION_COUNT;
    }

    public long newRecordId() {
        return this.newRecordId++;
    }

    Block getOrCreateBlock(Data key) {
        return this.getOrCreateBlock(this.getBlockId(key));
    }

    void evictAsync(final String name, final Data key) {
        this.executeLocally(new FallThroughRunnable(){

            public void doRun() {
                try {
                    MEvict mEvict = new MEvict();
                    mEvict.evict(name, key);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    Block getOrCreateBlock(int blockId) {
        this.checkServiceThread();
        Block block = this.blocks[blockId];
        if (block == null) {
            this.blocks[blockId] = block = new Block(blockId, null);
            if (this.isMaster() && !this.isSuperClient()) {
                block.setOwner(this.thisAddress);
            }
        }
        return block;
    }

    CMap getMap(String name) {
        return (CMap)this.maps.get(name);
    }

    public CMap getOrCreateMap(String name) {
        this.checkServiceThread();
        CMap map = (CMap)this.maps.get(name);
        if (map == null) {
            map = new CMap(this, name);
            this.maps.put(name, map);
        }
        return map;
    }

    void checkServiceThread() {
        if (Thread.currentThread() != this.node.serviceThread) {
            throw new Error("Only ServiceThread can access this method. " + Thread.currentThread());
        }
    }

    @Override
    void handleListenerRegistrations(boolean add, String name, Data key, Address address, boolean includeValue) {
        CMap cmap = this.getOrCreateMap(name);
        if (add) {
            cmap.addListener(key, address, includeValue);
        } else {
            cmap.removeListener(key, address);
        }
    }

    boolean sendBlockInfo(Block block, Address address) {
        return this.send("mapblock", ClusterOperation.CONCURRENT_MAP_BLOCK_INFO, block, address);
    }

    void executeAsync(Request request) {
        OrderedExecutionTask orderedExecutionTask = this.orderedExecutionTasks[this.getBlockId(request.key)];
        int size = orderedExecutionTask.offer(request);
        if (size == 1) {
            this.node.executorManager.executeStoreTask(orderedExecutionTask);
        }
    }

    public boolean mapIsNotLocked(Request request) {
        CMap cmap = this.getOrCreateMap(request.name);
        return cmap.isNotLocked(request);
    }

    public boolean exceedingMapMaxSize(Request request) {
        CMap cmap = this.getOrCreateMap(request.name);
        return cmap.exceedingMapMaxSize(request);
    }

    Record recordExist(Request req) {
        CMap cmap = (CMap)this.maps.get(req.name);
        if (cmap == null) {
            return null;
        }
        return cmap.getRecord(req.key);
    }

    Record ensureRecord(Request req) {
        this.checkServiceThread();
        CMap cmap = this.getOrCreateMap(req.name);
        Record record = cmap.getRecord(req.key);
        if (record == null) {
            record = cmap.createNewRecord(req.key, req.value);
            cmap.mapRecords.put(req.key, record);
        }
        return record;
    }

    final boolean testLock(Request req) {
        Record record = this.recordExist(req);
        return record == null || record.testLock(req.lockThreadId, req.lockAddress);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Entries
    implements Set {
        final String name;
        final List<Map.Entry> lsKeyValues = new ArrayList<Map.Entry>();
        final ClusterOperation operation;
        final boolean checkValue;

        public Entries(String name, ClusterOperation operation) {
            List<Map.Entry> entriesUnderTxn;
            this.name = name;
            this.operation = operation;
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            boolean bl = this.checkValue = Instance.InstanceType.MAP == BaseManager.getInstanceType(name) && (operation == ClusterOperation.CONCURRENT_MAP_ITERATE_VALUES || operation == ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES);
            if (txn != null && (entriesUnderTxn = txn.newEntries(name)) != null) {
                this.lsKeyValues.addAll(entriesUnderTxn);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public int size() {
            return this.lsKeyValues.size();
        }

        @Override
        public Iterator iterator() {
            return new EntryIterator(this.lsKeyValues.iterator());
        }

        public void addEntries(Pairs pairs) {
            if (pairs == null) {
                return;
            }
            if (pairs.getKeyValues() == null) {
                return;
            }
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            for (KeyValue entry : pairs.getKeyValues()) {
                if (txn != null) {
                    Object key = entry.getKey();
                    if (txn.has(this.name, key)) {
                        Object value = txn.get(this.name, key);
                        if (value == null) continue;
                        this.lsKeyValues.add(BaseManager.createSimpleEntry(ConcurrentMapManager.this.node.factory, this.name, key, value));
                        continue;
                    }
                    entry.setName(ConcurrentMapManager.this.node.factory, this.name);
                    this.lsKeyValues.add(entry);
                    continue;
                }
                entry.setName(ConcurrentMapManager.this.node.factory, this.name);
                this.lsKeyValues.add(entry);
            }
        }

        public List<Map.Entry> getKeyValues() {
            return this.lsKeyValues;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        @Override
        public Object[] toArray(Object[] a) {
            ArrayList values = new ArrayList();
            for (Object obj : this) {
                if (obj == null) continue;
                values.add(obj);
            }
            if (a == null) {
                return values.toArray();
            }
            return values.toArray(a);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class EntryIterator
        implements Iterator {
            final Iterator<Map.Entry> it;
            Map.Entry entry = null;
            boolean calledHasNext = false;

            public EntryIterator(Iterator<Map.Entry> it) {
                this.it = it;
            }

            @Override
            public boolean hasNext() {
                this.calledHasNext = true;
                if (!this.it.hasNext()) {
                    return false;
                }
                this.entry = this.it.next();
                if (Entries.this.checkValue && this.entry.getValue() == null) {
                    return this.hasNext();
                }
                return true;
            }

            public Object next() {
                if (!this.calledHasNext) {
                    this.hasNext();
                }
                this.calledHasNext = false;
                if (Entries.this.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS || Entries.this.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS_ALL) {
                    return this.entry.getKey();
                }
                if (Entries.this.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_VALUES) {
                    return this.entry.getValue();
                }
                if (Entries.this.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES) {
                    return this.entry;
                }
                throw new RuntimeException("Unknown iteration type " + (Object)((Object)Entries.this.operation));
            }

            @Override
            public void remove() {
                if (BaseManager.getInstanceType(Entries.this.name) == Instance.InstanceType.MULTIMAP) {
                    if (Entries.this.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS) {
                        ((MultiMap)ConcurrentMapManager.this.node.factory.getOrCreateProxyByName(Entries.this.name)).remove(this.entry.getKey(), null);
                    } else {
                        ((MultiMap)ConcurrentMapManager.this.node.factory.getOrCreateProxyByName(Entries.this.name)).remove(this.entry.getKey(), this.entry.getValue());
                    }
                } else {
                    ((IRemoveAwareProxy)ConcurrentMapManager.this.node.factory.getOrCreateProxyByName(Entries.this.name)).removeKey(this.entry.getKey());
                }
                this.it.remove();
            }
        }
    }

    class OrderedExecutionTask
    implements Runnable,
    Processable {
        Queue<Request> qResponses = new ConcurrentLinkedQueue<Request>();
        Queue<Request> qRequests = new ConcurrentLinkedQueue<Request>();
        AtomicInteger offerSize = new AtomicInteger();

        OrderedExecutionTask() {
        }

        int offer(Request request) {
            this.qRequests.offer(request);
            return this.offerSize.incrementAndGet();
        }

        public void run() {
            Request request;
            while ((request = this.qRequests.poll()) != null) {
                try {
                    AsynchronousExecution ae = (AsynchronousExecution)((Object)ConcurrentMapManager.this.getPacketProcessor(request.operation));
                    ae.execute(request);
                }
                catch (Exception e) {
                    ConcurrentMapManager.this.logger.log(Level.FINEST, "Store thrown exception for " + (Object)((Object)request.operation), e);
                    request.response = IOUtil.toData(new AddressAwareException(e, ConcurrentMapManager.this.thisAddress));
                }
                this.offerSize.decrementAndGet();
                this.qResponses.offer(request);
                ConcurrentMapManager.this.enqueueAndReturn(this);
            }
        }

        public void process() {
            Request request = this.qResponses.poll();
            if (request != null) {
                AsynchronousExecution ae = (AsynchronousExecution)((Object)ConcurrentMapManager.this.getPacketProcessor(request.operation));
                ae.afterExecute(request);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QueryOperationHandler
    extends ExecutedOperationHandler {
        QueryOperationHandler() {
        }

        @Override
        public void handle(Request request) {
            if (ConcurrentMapManager.this.mapIsNotLocked(request) && !ConcurrentMapManager.this.isMigrating(request)) {
                super.handle(request);
            } else {
                request.response = Constants.Objects.OBJECT_REDO;
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        @Override
        Runnable createRunnable(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            return new QueryTask(cmap, request);
        }

        void createResultPairs(Request request, Collection<MapEntry> colRecords, boolean evaluateEntries, Predicate predicate) {
            Pairs pairs = new Pairs();
            if (colRecords != null) {
                long now = System.currentTimeMillis();
                for (MapEntry mapEntry : colRecords) {
                    int size;
                    Record record = (Record)mapEntry;
                    if (!record.isActive() || !record.isValid(now)) continue;
                    if (record.getKey() == null || record.getKey().size() == 0) {
                        throw new RuntimeException("Key cannot be null or zero-size: " + record.getKey());
                    }
                    boolean match = !evaluateEntries || predicate.apply(record.getRecordEntry());
                    if (!match) continue;
                    boolean onlyKeys = request.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS_ALL || request.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS;
                    Data key = record.getKey();
                    if (record.getValue() != null) {
                        Data value = onlyKeys ? null : record.getValue();
                        pairs.addKeyValue(new KeyValue(key, value));
                        continue;
                    }
                    if (record.getCopyCount() > 0) {
                        for (int i = 0; i < record.getCopyCount(); ++i) {
                            pairs.addKeyValue(new KeyValue(key, null));
                        }
                        continue;
                    }
                    if (record.getMultiValues() == null || (size = record.getMultiValues().size()) <= 0) continue;
                    if (request.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS) {
                        pairs.addKeyValue(new KeyValue(key, null));
                        continue;
                    }
                    Set<Data> values = record.getMultiValues();
                    for (Data value : values) {
                        pairs.addKeyValue(new KeyValue(key, value));
                    }
                }
            }
            if (!request.local) {
                request.value = null;
            }
            request.response = pairs.size() > 0 ? (request.local ? pairs : IOUtil.toData(pairs)) : null;
        }

        class QueryTask
        implements Runnable {
            final CMap cmap;
            final Request request;

            QueryTask(CMap cmap, Request request) {
                this.cmap = cmap;
                this.request = request;
            }

            public void run() {
                try {
                    Predicate predicate = null;
                    if (this.request.value != null) {
                        predicate = (Predicate)IOUtil.toObject(this.request.value);
                    }
                    QueryContext queryContext = new QueryContext(this.cmap.getName(), predicate);
                    Set<MapEntry> results = this.cmap.getMapIndexService().doQuery(queryContext);
                    boolean evaluateValues = predicate != null && !queryContext.isStrong();
                    QueryOperationHandler.this.createResultPairs(this.request, results, evaluateValues, predicate);
                    ConcurrentMapManager.this.enqueueAndReturn(new Processable(){

                        public void process() {
                            boolean sent;
                            int callerPartitionHash = QueryTask.this.request.blockId;
                            if (ConcurrentMapManager.this.partitionManager.containsMigratingBlock() || callerPartitionHash != ConcurrentMapManager.this.hashBlocks()) {
                                QueryTask.this.request.response = Constants.Objects.OBJECT_REDO;
                            }
                            if (!(sent = ConcurrentMapManager.this.returnResponse(QueryTask.this.request))) {
                                Connection conn = ConcurrentMapManager.this.node.connectionManager.getConnection(QueryTask.this.request.caller);
                                ConcurrentMapManager.this.logger.log(Level.WARNING, QueryTask.this.request + " !! response cannot be sent to " + QueryTask.this.request.caller + " conn:" + conn);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    ConcurrentMapManager.this.logger.log(Level.SEVERE, this.request.toString(), e);
                }
            }
        }
    }

    class SizeOperationHandler
    extends ExecutedOperationHandler {
        SizeOperationHandler() {
        }

        public void handle(Request request) {
            if (ConcurrentMapManager.this.mapIsNotLocked(request) && !ConcurrentMapManager.this.isMigrating(request)) {
                super.handle(request);
            } else {
                request.response = Constants.Objects.OBJECT_REDO;
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        Runnable createRunnable(final Request request) {
            final CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            return new Runnable(){

                public void run() {
                    request.response = (long)cmap.size();
                    ConcurrentMapManager.this.enqueueAndReturn(new Processable(){

                        public void process() {
                            boolean sent;
                            int callerPartitionHash = request.blockId;
                            int myPartitionHashNow = ConcurrentMapManager.this.hashBlocks();
                            if (callerPartitionHash != myPartitionHashNow) {
                                request.response = Constants.Objects.OBJECT_REDO;
                            }
                            if (!(sent = ConcurrentMapManager.this.returnResponse(request))) {
                                Connection conn = ConcurrentMapManager.this.node.connectionManager.getConnection(request.caller);
                                ConcurrentMapManager.this.logger.log(Level.WARNING, request + " !! response cannot be sent to " + request.caller + " conn:" + conn);
                            }
                        }
                    });
                }
            };
        }
    }

    abstract class ExecutedOperationHandler
    extends BaseManager.ResponsiveOperationHandler {
        ExecutedOperationHandler() {
        }

        public void process(Packet packet) {
            Request request = Request.copy(packet);
            request.local = false;
            this.handle(request);
        }

        public void handle(Request request) {
            ConcurrentMapManager.this.node.executorManager.executeQueryTask(this.createRunnable(request));
        }

        abstract Runnable createRunnable(Request var1);
    }

    class ContainsValueOperationHandler
    extends BaseManager.AbstractOperationHandler {
        ContainsValueOperationHandler() {
        }

        public void process(Packet packet) {
            this.processMigrationAware(packet);
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.containsValue(request);
        }
    }

    abstract class StoreAwareOperationHandler
    extends SchedulableOperationHandler
    implements AsynchronousExecution {
        StoreAwareOperationHandler() {
        }

        public void execute(Request request) {
            CMap cmap = (CMap)ConcurrentMapManager.this.maps.get(request.name);
            if (request.operation == ClusterOperation.CONCURRENT_MAP_GET) {
                Object value = cmap.loader.load(IOUtil.toObject(request.key));
                if (value != null) {
                    ConcurrentMapManager.this.setIndexValues(request, value);
                    request.value = IOUtil.toData(value);
                }
            } else if (request.operation == ClusterOperation.CONCURRENT_MAP_PUT || request.operation == ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT) {
                Object value = IOUtil.toObject(request.value);
                cmap.store.store(IOUtil.toObject(request.key), value);
            } else if (request.operation == ClusterOperation.CONCURRENT_MAP_REMOVE) {
                cmap.store.delete(IOUtil.toObject(request.key));
            } else if (request.operation == ClusterOperation.CONCURRENT_MAP_EVICT) {
                cmap.store.store(IOUtil.toObject(request.key), IOUtil.toObject(request.value));
                request.response = Boolean.TRUE;
            } else if (request.operation == ClusterOperation.CONCURRENT_MAP_MERGE) {
                boolean success = false;
                Object winner = null;
                if (cmap.mergePolicy != null) {
                    Record existing = cmap.getRecord(request.key);
                    RecordEntry existingEntry = existing == null ? null : cmap.getRecordEntry(existing);
                    DataRecordEntry newEntry = (DataRecordEntry)IOUtil.toObject(request.value);
                    Object key = newEntry.getKey();
                    if (key != null && newEntry.getValue() != null && (winner = cmap.mergePolicy.merge(cmap.getName(), newEntry, existingEntry)) != null) {
                        success = true;
                        if (cmap.writeDelayMillis == 0L && cmap.store != null) {
                            cmap.store.store(key, winner);
                            boolean bl = success = request.response == null;
                        }
                    }
                }
                if (success) {
                    request.value = IOUtil.toData(winner);
                    request.response = Boolean.TRUE;
                } else {
                    request.value = null;
                    request.response = Boolean.FALSE;
                }
            }
        }

        protected boolean shouldExecuteAsync(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (request.operation == ClusterOperation.CONCURRENT_MAP_GET) {
                return cmap.loader != null;
            }
            return cmap.writeDelayMillis == 0L && cmap.store != null;
        }

        public void handle(Request request) {
            if (ConcurrentMapManager.this.mapIsNotLocked(request) && !ConcurrentMapManager.this.exceedingMapMaxSize(request)) {
                if (this.shouldSchedule(request)) {
                    if (request.hasEnoughTimeToSchedule()) {
                        this.schedule(request);
                    } else {
                        this.onNoTimeToSchedule(request);
                    }
                    return;
                }
                if (this.shouldExecuteAsync(request)) {
                    ConcurrentMapManager.this.executeAsync(request);
                    return;
                }
                this.doOperation(request);
                ConcurrentMapManager.this.returnResponse(request);
            } else {
                request.response = Constants.Objects.OBJECT_REDO;
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        public void afterExecute(Request request) {
            if (request.response == null) {
                this.doOperation(request);
            } else {
                request.value = (Data)request.response;
            }
            ConcurrentMapManager.this.returnResponse(request);
        }
    }

    static interface AsynchronousExecution {
        public void execute(Request var1);

        public void afterExecute(Request var1);
    }

    abstract class SchedulableOperationHandler
    extends MTargetAwareOperationHandler {
        SchedulableOperationHandler() {
        }

        protected boolean shouldSchedule(Request request) {
            return !ConcurrentMapManager.this.testLock(request);
        }

        protected void onNoTimeToSchedule(Request request) {
            request.response = null;
            ConcurrentMapManager.this.returnResponse(request);
        }

        protected void schedule(Request request) {
            Record record = ConcurrentMapManager.this.ensureRecord(request);
            request.scheduled = true;
            ScheduledAction scheduledAction = new ScheduledAction(request){

                public boolean consume() {
                    SchedulableOperationHandler.this.handle(this.request);
                    return true;
                }

                public void onExpire() {
                    SchedulableOperationHandler.this.onNoTimeToSchedule(this.request);
                }

                public void onMigrate() {
                    this.request.response = Constants.Objects.OBJECT_REDO;
                    ConcurrentMapManager.this.returnResponse(this.request);
                }
            };
            record.addScheduledAction(scheduledAction);
            ConcurrentMapManager.this.node.clusterManager.registerScheduledAction(scheduledAction);
        }

        public void handle(Request request) {
            if (this.shouldSchedule(request)) {
                if (request.hasEnoughTimeToSchedule()) {
                    this.schedule(request);
                } else {
                    this.onNoTimeToSchedule(request);
                }
            } else {
                this.doOperation(request);
                ConcurrentMapManager.this.returnResponse(request);
            }
        }
    }

    class LockOperationHandler
    extends SchedulableOperationHandler {
        LockOperationHandler() {
        }

        protected void onNoTimeToSchedule(Request request) {
            request.response = Boolean.FALSE;
            ConcurrentMapManager.this.returnResponse(request);
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.lock(request);
        }
    }

    class UnlockOperationHandler
    extends SchedulableOperationHandler {
        UnlockOperationHandler() {
        }

        protected boolean shouldSchedule(Request request) {
            return false;
        }

        void doOperation(Request request) {
            boolean unlocked = true;
            Record record = ConcurrentMapManager.this.recordExist(request);
            ConcurrentMapManager.this.logger.log(Level.FINEST, (Object)((Object)request.operation) + " unlocking " + record);
            if (record != null) {
                unlocked = record.unlock(request.lockThreadId, request.lockAddress);
                if (unlocked) {
                    CMap cmap = ConcurrentMapManager.this.getOrCreateMap(record.getName());
                    record.incrementVersion();
                    request.version = record.getVersion();
                    request.lockCount = record.getLockCount();
                    cmap.fireScheduledActions(record);
                }
                ConcurrentMapManager.this.logger.log(Level.FINEST, unlocked + " now lock " + record.getLock());
            }
            request.response = unlocked ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    class MigrationOperationHandler
    extends BaseManager.AbstractOperationHandler {
        MigrationOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.own(request);
            request.response = Boolean.TRUE;
        }
    }

    class ContainsOperationHandler
    extends BaseManager.MigrationAwareOperationHandler {
        ContainsOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.contains(request);
        }
    }

    class ValueCountOperationHandler
    extends MTargetAwareOperationHandler {
        ValueCountOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.valueCount(request.key);
        }
    }

    class GetOperationHandler
    extends StoreAwareOperationHandler {
        GetOperationHandler() {
        }

        public void handle(Request request) {
            if (ConcurrentMapManager.this.mapIsNotLocked(request)) {
                CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
                Record record = cmap.getRecord(request.key);
                if (!(cmap.loader == null || record != null && record.isActive() && record.isValid() && record.getValue() != null)) {
                    ConcurrentMapManager.this.executeAsync(request);
                } else {
                    this.doOperation(request);
                    ConcurrentMapManager.this.returnResponse(request);
                }
            } else {
                request.response = Constants.Objects.OBJECT_REDO;
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Data value = cmap.get(request);
            request.clearForResponse();
            request.response = value;
        }

        public void afterExecute(Request request) {
            if (request.response == Boolean.FALSE) {
                request.response = Constants.Objects.OBJECT_REDO;
            } else if (request.value != null) {
                Record record = ConcurrentMapManager.this.ensureRecord(request);
                if (record.getValue() == null) {
                    record.setValue(request.value);
                }
                CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
                record.setIndexes(request.indexes, request.indexTypes);
                cmap.markAsActive(record);
                cmap.updateIndexes(record);
                request.response = record.getValue();
            }
            ConcurrentMapManager.this.returnResponse(request);
        }
    }

    class MergeOperationHandler
    extends StoreAwareOperationHandler {
        MergeOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.put(request);
            request.response = Boolean.TRUE;
        }

        protected boolean shouldExecuteAsync(Request request) {
            return true;
        }

        public void afterExecute(Request request) {
            if (request.response != Boolean.FALSE) {
                this.doOperation(request);
            }
            ConcurrentMapManager.this.returnResponse(request);
        }
    }

    class EvictOperationHandler
    extends StoreAwareOperationHandler {
        EvictOperationHandler() {
        }

        public void handle(Request request) {
            if (ConcurrentMapManager.this.mapIsNotLocked(request)) {
                CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
                Record record = cmap.getRecord(request.key);
                if (record != null && record.isActive() && cmap.loader != null && cmap.writeDelayMillis > 0L && record.isValid() && record.isDirty()) {
                    record.setDirty(false);
                    request.value = record.getValue();
                    ConcurrentMapManager.this.executeAsync(request);
                } else {
                    this.doOperation(request);
                    ConcurrentMapManager.this.returnResponse(request);
                }
            } else {
                request.response = Constants.Objects.OBJECT_REDO;
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.evict(request);
        }

        public void afterExecute(Request request) {
            if (request.response == Boolean.TRUE) {
                this.doOperation(request);
            } else {
                CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
                Record record = cmap.getRecord(request.key);
                cmap.markAsDirty(record);
                request.response = Boolean.FALSE;
            }
            ConcurrentMapManager.this.returnResponse(request);
        }
    }

    class GetMapEntryOperationHandler
    extends MTargetAwareOperationHandler {
        GetMapEntryOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.getMapEntry(request);
        }
    }

    class AddOperationHandler
    extends MTargetAwareOperationHandler {
        AddOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.add(request, false);
        }
    }

    class AtomicOperationHandler
    extends MTargetAwareOperationHandler {
        AtomicOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.doAtomic(request);
        }
    }

    class PutOperationHandler
    extends StoreAwareOperationHandler {
        PutOperationHandler() {
        }

        protected void onNoTimeToSchedule(Request request) {
            request.response = null;
            if (request.operation == ClusterOperation.CONCURRENT_MAP_TRY_PUT) {
                request.response = Boolean.FALSE;
            }
            ConcurrentMapManager.this.returnResponse(request);
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.put(request);
            if (request.operation == ClusterOperation.CONCURRENT_MAP_TRY_PUT) {
                request.response = Boolean.TRUE;
            }
        }
    }

    class PutMultiOperationHandler
    extends SchedulableOperationHandler {
        PutMultiOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.putMulti(request);
        }
    }

    class RemoveMultiOperationHandler
    extends SchedulableOperationHandler {
        RemoveMultiOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.removeMulti(request);
        }
    }

    class RemoveOperationHandler
    extends StoreAwareOperationHandler {
        RemoveOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.remove(request);
        }
    }

    class RemoveItemOperationHandler
    extends StoreAwareOperationHandler {
        RemoveItemOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.removeItem(request);
        }
    }

    abstract class MTargetAwareOperationHandler
    extends BaseManager.TargetAwareOperationHandler {
        MTargetAwareOperationHandler() {
        }

        boolean isRightRemoteTarget(Request request) {
            return ConcurrentMapManager.this.thisAddress.equals(ConcurrentMapManager.this.getKeyOwner(request.key));
        }
    }

    class InvalidateOperationHandler
    implements PacketProcessor {
        InvalidateOperationHandler() {
        }

        public void process(Packet packet) {
            MapNearCache mapNearCache;
            CMap cmap = ConcurrentMapManager.this.getMap(packet.name);
            if (cmap != null && (mapNearCache = cmap.mapNearCache) != null) {
                mapNearCache.invalidate(packet.getKeyData());
            }
            ConcurrentMapManager.this.releasePacket(packet);
        }
    }

    class BackupPacketProcessor
    extends BaseManager.AbstractOperationHandler {
        BackupPacketProcessor() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Boolean value = cmap.backup(request);
            request.clearForResponse();
            request.response = value;
        }
    }

    class LockMapOperationHandler
    extends BaseManager.MigrationAwareOperationHandler {
        LockMapOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.lockMap(request);
        }
    }

    class BlockInfoOperationHandler
    implements PacketProcessor {
        BlockInfoOperationHandler() {
        }

        public void process(Packet packet) {
            Block blockInfo = (Block)IOUtil.toObject(packet.getValueData());
            ConcurrentMapManager.this.partitionManager.completeMigration(blockInfo.getBlockId());
            if (ConcurrentMapManager.this.isMaster() && !blockInfo.isMigrating()) {
                for (MemberImpl member : ConcurrentMapManager.this.lsMembers) {
                    if (member.localMember() || member.getAddress().equals(packet.conn.getEndPoint())) continue;
                    ConcurrentMapManager.this.sendBlockInfo(new Block(blockInfo), member.getAddress());
                }
            }
            ConcurrentMapManager.this.releasePacket(packet);
        }
    }

    class BlocksOperationHandler
    extends BlockInfoOperationHandler {
        BlocksOperationHandler() {
        }

        public void process(Packet packet) {
            Blocks blocks = (Blocks)IOUtil.toObject(packet.getValueData());
            ConcurrentMapManager.this.partitionManager.handleBlocks(blocks);
            ConcurrentMapManager.this.releasePacket(packet);
        }
    }

    class BlockMigrationCheckHandler
    extends BaseManager.AbstractOperationHandler {
        BlockMigrationCheckHandler() {
        }

        void doOperation(Request request) {
            request.response = ConcurrentMapManager.this.partitionManager.containsMigratingBlock();
        }
    }

    class MGetEntries
    extends MMigrationAwareTargetedCall {
        public MGetEntries(Address target, ClusterOperation operation, String name, Predicate predicate) {
            this.target = target;
            this.request.reset();
            this.setLocal(operation, name, null, predicate, -1L, -1L);
        }
    }

    public class MIterate
    extends BaseManager.MultiCall {
        Entries entries = null;
        final String name;
        final ClusterOperation operation;
        final Predicate predicate;

        public MIterate(ClusterOperation operation, String name, Predicate predicate) {
            this.name = name;
            this.operation = operation;
            this.predicate = predicate;
        }

        BaseManager.TargetAwareOp createNewTargetAwareOp(Address target) {
            return new MGetEntries(target, this.operation, this.name, this.predicate);
        }

        void onCall() {
            this.entries = new Entries(this.name, this.operation);
        }

        boolean onResponse(Object response) {
            Pairs pairs = null;
            if (response instanceof Data) {
                pairs = (Pairs)IOUtil.toObject((Data)response);
            } else if (response instanceof Pairs) {
                pairs = (Pairs)response;
            } else {
                return true;
            }
            this.entries.addEntries(pairs);
            return true;
        }

        Object returnResult() {
            return this.entries;
        }
    }

    public class MIterateLocal
    extends MGetEntries {
        public MIterateLocal(String name, Predicate predicate) {
            super(ConcurrentMapManager.this.thisAddress, ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, name, predicate);
            this.doOp();
        }

        public Set iterate() {
            Entries entries = new Entries(this.request.name, this.request.operation);
            Pairs pairs = (Pairs)this.getResultAsObject();
            entries.addEntries(pairs);
            return entries;
        }

        public Object getResult() {
            return this.getRedoAwareResult();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MSize
    extends BaseManager.MultiCall<Integer> {
        int size = 0;
        final String name;

        public int getSize() {
            int size = (Integer)this.call();
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            if (txn != null) {
                size += txn.size(this.name);
            }
            return size < 0 ? 0 : size;
        }

        public MSize(String name) {
            this.name = name;
        }

        @Override
        BaseManager.TargetAwareOp createNewTargetAwareOp(Address target) {
            return new MGetSize(target);
        }

        @Override
        boolean onResponse(Object response) {
            this.size += ((Long)response).intValue();
            return true;
        }

        @Override
        void onCall() {
            this.size = 0;
        }

        @Override
        Integer returnResult() {
            return this.size;
        }

        class MGetSize
        extends MMigrationAwareTargetedCall {
            public MGetSize(Address target) {
                this.target = target;
                this.request.reset();
                this.setLocal(ClusterOperation.CONCURRENT_MAP_SIZE, MSize.this.name);
                this.request.setLongRequest();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MLockMap
    extends BaseManager.MultiCall<Boolean> {
        private final String name;
        private final long timeout;
        private final ClusterOperation operation;

        public MLockMap(String name, boolean lock, long timeout) {
            this.name = name;
            this.operation = lock ? ClusterOperation.CONCURRENT_MAP_LOCK_MAP : ClusterOperation.CONCURRENT_MAP_UNLOCK_MAP;
            this.timeout = timeout;
        }

        @Override
        BaseManager.TargetAwareOp createNewTargetAwareOp(Address target) {
            return new MTargetLockMap(target);
        }

        @Override
        boolean onResponse(Object response) {
            return true;
        }

        @Override
        void onCall() {
        }

        @Override
        Boolean returnResult() {
            return true;
        }

        class MTargetLockMap
        extends MMigrationAwareTargetedCall {
            public MTargetLockMap(Address target) {
                this.target = target;
                this.request.reset();
                this.setLocal(MLockMap.this.operation, MLockMap.this.name, null, null, MLockMap.this.timeout, -1L);
                this.request.setBooleanRequest();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MContainsValue
    extends BaseManager.MultiCall<Boolean> {
        boolean contains = false;
        final String name;
        final Object value;

        public MContainsValue(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        @Override
        BaseManager.TargetAwareOp createNewTargetAwareOp(Address target) {
            return new MGetContainsValue(target);
        }

        @Override
        boolean onResponse(Object response) {
            if (response == Boolean.TRUE) {
                this.contains = true;
                return false;
            }
            return true;
        }

        @Override
        void onCall() {
            this.contains = false;
        }

        @Override
        Boolean returnResult() {
            return this.contains;
        }

        class MGetContainsValue
        extends MMigrationAwareTargetedCall {
            public MGetContainsValue(Address target) {
                this.target = target;
                this.request.reset();
                this.setLocal(ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE, MContainsValue.this.name, null, MContainsValue.this.value, 0L, -1L);
                this.request.setBooleanRequest();
            }
        }
    }

    abstract class MMigrationAwareTargetedCall
    extends BaseManager.MigrationAwareTargetedCall {
        MMigrationAwareTargetedCall() {
        }

        public void process() {
            this.request.blockId = ConcurrentMapManager.this.hashBlocks();
            super.process();
        }
    }

    abstract class MBackupAwareOp
    extends BaseManager.MTargetAwareOp {
        protected final MBackup[] backupOps = new MBackup[3];
        protected volatile int backupCount = 0;

        MBackupAwareOp() {
        }

        protected void backup(ClusterOperation operation) {
            if (this.backupCount > 0) {
                int i;
                for (i = 0; i < this.backupCount; ++i) {
                    int distance = i + 1;
                    MBackup backupOp = this.backupOps[i];
                    if (backupOp == null) {
                        this.backupOps[i] = backupOp = new MBackup();
                    }
                    if (this.request.key == null || this.request.key.size() == 0) {
                        throw new RuntimeException("Key is null! " + this.request.key);
                    }
                    backupOp.sendBackup(operation, this.target, distance, this.request);
                }
                for (i = 0; i < this.backupCount; ++i) {
                    MBackup backupOp = this.backupOps[i];
                    backupOp.getResultAsBoolean();
                }
            }
        }

        void prepareForBackup() {
            this.backupCount = 0;
            if (ConcurrentMapManager.this.lsMembers.size() > 1) {
                CMap map = ConcurrentMapManager.this.getOrCreateMap(this.request.name);
                this.backupCount = map.getBackupCount();
                this.backupCount = Math.min(this.backupCount, ConcurrentMapManager.this.lsMembers.size());
            }
        }

        public void process() {
            this.prepareForBackup();
            super.process();
        }

        public void handleNoneRedoResponse(Packet packet) {
            this.handleRemoteResponse(packet);
            super.handleNoneRedoResponse(packet);
        }

        public void handleRemoteResponse(Packet packet) {
            this.request.local = true;
            this.request.version = packet.version;
            this.request.lockCount = packet.lockCount;
            this.request.longValue = packet.longValue;
        }
    }

    class MBackupOp
    extends MBackupAwareOp {
        MBackupOp() {
        }

        public void backup(Record record) {
            this.request.setFromRecord(record);
            this.doOp();
            boolean stillOwner = this.getResultAsBoolean();
            if (stillOwner) {
                this.target = ConcurrentMapManager.this.thisAddress;
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            }
        }

        public void process() {
            this.prepareForBackup();
            if (!ConcurrentMapManager.this.thisAddress.equals(ConcurrentMapManager.this.getKeyOwner(this.request.key))) {
                this.setResult(Boolean.FALSE);
            } else {
                this.setResult(Boolean.TRUE);
            }
        }
    }

    class MBackup
    extends BaseManager.MTargetAwareOp {
        protected Address owner = null;
        protected int distance = 0;

        MBackup() {
        }

        public void sendBackup(ClusterOperation operation, Address owner, int distance, Request reqBackup) {
            this.reset();
            this.owner = owner;
            this.distance = distance;
            this.request.setFromRequest(reqBackup);
            this.request.operation = operation;
            this.request.caller = ConcurrentMapManager.this.thisAddress;
            this.request.setBooleanRequest();
            this.doOp();
        }

        public void reset() {
            super.reset();
            this.owner = null;
            this.distance = 0;
        }

        public void process() {
            MemberImpl targetMember = ConcurrentMapManager.this.getNextMemberAfter(this.owner, true, this.distance);
            if (targetMember == null) {
                this.setResult(Boolean.TRUE);
                return;
            }
            this.target = targetMember.getAddress();
            if (this.target.equals(ConcurrentMapManager.this.thisAddress)) {
                this.doLocalOp();
            } else {
                this.invoke();
            }
        }
    }

    abstract class MBackupAndMigrationAwareOp
    extends MBackupAwareOp {
        MBackupAndMigrationAwareOp() {
        }

        public boolean isMigrationAware() {
            return true;
        }
    }

    class MRemoveMulti
    extends MBackupAndMigrationAwareOp {
        MRemoveMulti() {
        }

        boolean remove(String name, Object key, Object value) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (!txn.has(name, key)) {
                    Data oldValue;
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, value, 8000L);
                    if (!locked) {
                        ConcurrentMapManager.this.throwCME(key);
                    }
                    boolean existingRecord = (oldValue = mlock.oldValue) != null;
                    txn.attachRemoveOp(name, key, value, !existingRecord);
                    return existingRecord;
                }
                MContainsKey mContainsKey = new MContainsKey();
                boolean containsEntry = mContainsKey.containsEntry(name, key, value);
                txn.attachRemoveOp(name, key, value, !containsEntry);
                return containsEntry;
            }
            boolean result = this.booleanCall(ClusterOperation.CONCURRENT_MAP_REMOVE_MULTI, name, key, value, 0L, -1L);
            if (result) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE_MULTI);
            }
            return result;
        }
    }

    class MPut
    extends MBackupAndMigrationAwareOp {
        MPut() {
        }

        public boolean replace(String name, Object key, Object oldValue, Object newValue, long timeout) {
            Object result = this.txnalReplaceIfSame(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME, name, key, newValue, oldValue, timeout);
            return result == Boolean.TRUE;
        }

        public Object replace(String name, Object key, Object value, long timeout, long ttl) {
            return this.txnalPut(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL, name, key, value, timeout, ttl);
        }

        public Object putIfAbsent(String name, Object key, Object value, long timeout, long ttl) {
            return this.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT, name, key, value, timeout, ttl);
        }

        public Object put(String name, Object key, Object value, long timeout, long ttl) {
            return this.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT, name, key, value, timeout, ttl);
        }

        public Object merge(Record record) {
            DataRecordEntry dataRecordEntry = new DataRecordEntry(record);
            ClusterOperation operation = ClusterOperation.CONCURRENT_MAP_MERGE;
            this.setLocal(operation, record.getName(), record.getKey(), dataRecordEntry, 0L, -1L);
            this.request.longValue = this.request.value == null ? Integer.MIN_VALUE : (long)this.request.value.hashCode();
            Object value = record.getRecordEntry().getValue();
            ConcurrentMapManager.this.setIndexValues(this.request, value);
            this.request.setBooleanRequest();
            this.doOp();
            Boolean returnObject = this.getResultAsBoolean();
            if (returnObject.booleanValue()) {
                this.request.value = record.getValue();
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            }
            return returnObject;
        }

        public boolean tryPut(String name, Object key, Object value, long timeout, long ttl) {
            return (Boolean)this.txnalPut(ClusterOperation.CONCURRENT_MAP_TRY_PUT, name, key, value, timeout, ttl);
        }

        private Object txnalReplaceIfSame(ClusterOperation operation, String name, Object key, Object newValue, Object expectedValue, long timeout) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (!txn.has(name, key)) {
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, 8000L);
                    if (!locked) {
                        ConcurrentMapManager.this.throwCME(key);
                    }
                    Object oldObject = null;
                    Data oldValue = mlock.oldValue;
                    if (oldValue != null) {
                        oldObject = IOUtil.toObject(oldValue);
                    }
                    if (oldObject == null) {
                        return Boolean.FALSE;
                    }
                    if (expectedValue.equals(oldValue)) {
                        txn.attachPutOp(name, key, newValue, false);
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                if (expectedValue.equals(txn.get(name, key))) {
                    txn.attachPutOp(name, key, newValue, false);
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            Data dataExpected = IOUtil.toData(expectedValue);
            Data dataNew = IOUtil.toData(newValue);
            this.setLocal(operation, name, key, new MultiData(dataExpected, dataNew), timeout, -1L);
            this.request.longValue = this.request.value == null ? Integer.MIN_VALUE : (long)dataNew.hashCode();
            ConcurrentMapManager.this.setIndexValues(this.request, newValue);
            this.request.setBooleanRequest();
            this.doOp();
            Boolean returnObject = this.getResultAsBoolean();
            if (returnObject instanceof AddressAwareException) {
                ConcurrentMapManager.this.rethrowException(operation, (AddressAwareException)((Object)returnObject));
            }
            if (returnObject != Boolean.FALSE) {
                this.request.value = dataNew;
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            }
            return returnObject;
        }

        private Object txnalPut(ClusterOperation operation, String name, Object key, Object value, long timeout, long ttl) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (!txn.has(name, key)) {
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, 8000L);
                    if (!locked) {
                        ConcurrentMapManager.this.throwCME(key);
                    }
                    Object oldObject = null;
                    Data oldValue = mlock.oldValue;
                    if (oldValue != null) {
                        oldObject = IOUtil.toObject(oldValue);
                    }
                    txn.attachPutOp(name, key, value, oldObject == null);
                    return threadContext.isClient() ? oldValue : oldObject;
                }
                return txn.attachPutOp(name, key, value, false);
            }
            this.setLocal(operation, name, key, value, timeout, ttl);
            this.request.longValue = this.request.value == null ? Integer.MIN_VALUE : (long)this.request.value.hashCode();
            ConcurrentMapManager.this.setIndexValues(this.request, value);
            if (operation == ClusterOperation.CONCURRENT_MAP_TRY_PUT) {
                this.request.setBooleanRequest();
                this.doOp();
                Boolean returnObject = this.getResultAsBoolean();
                if (returnObject.booleanValue()) {
                    this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
                }
                return returnObject;
            }
            this.request.setObjectRequest();
            this.doOp();
            Object returnObject = this.getResultAsObject();
            if (returnObject instanceof AddressAwareException) {
                ConcurrentMapManager.this.rethrowException(operation, (AddressAwareException)returnObject);
            }
            this.request.longValue = Long.MIN_VALUE;
            this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            return returnObject;
        }
    }

    class MAtomic
    extends MBackupAndMigrationAwareOp {
        final Data nameAsKey;
        final ClusterOperation op;
        final long expected;
        final long value;
        final boolean ignoreExpected;

        MAtomic(Data nameAsKey, ClusterOperation op, long value, long expected, boolean ignoreExpected) {
            this.nameAsKey = nameAsKey;
            this.op = op;
            this.value = value;
            this.expected = expected;
            this.ignoreExpected = ignoreExpected;
        }

        MAtomic(Data nameAsKey, ClusterOperation op, long value, long expected) {
            this(nameAsKey, op, value, expected, false);
        }

        MAtomic(Data nameAsKey, ClusterOperation op, long value) {
            this(nameAsKey, op, value, 0L, true);
        }

        boolean doBooleanAtomic() {
            Data expectedData = this.ignoreExpected ? null : IOUtil.toData(this.expected);
            this.setLocal(this.op, "c:hz_AtomicNumber", this.nameAsKey, expectedData, 0L, 0L);
            this.request.longValue = this.value;
            this.request.setBooleanRequest();
            this.doOp();
            Boolean returnObject = this.getResultAsBoolean();
            if (returnObject instanceof AddressAwareException) {
                ConcurrentMapManager.this.rethrowException(this.op, (AddressAwareException)((Object)returnObject));
            }
            return returnObject != Boolean.FALSE;
        }

        long doLongAtomic() {
            this.setLocal(this.op, "c:hz_AtomicNumber", this.nameAsKey, null, 0L, 0L);
            this.request.longValue = this.value;
            this.doOp();
            Object returnObject = this.getResultAsObject();
            if (returnObject instanceof AddressAwareException) {
                ConcurrentMapManager.this.rethrowException(this.op, (AddressAwareException)returnObject);
            }
            return (Long)returnObject;
        }

        void backup(Long value) {
            this.request.value = IOUtil.toData(value);
            this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
        }
    }

    class MPutMulti
    extends MBackupAndMigrationAwareOp {
        MPutMulti() {
        }

        boolean put(String name, Object key, Object value) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (!txn.has(name, key, value)) {
                    boolean added;
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, value, 8000L);
                    if (!locked) {
                        ConcurrentMapManager.this.throwCME(key);
                    }
                    boolean bl = added = mlock.oldValue == null;
                    if (added) {
                        txn.attachPutOp(name, key, value, true);
                    }
                    return added;
                }
                return false;
            }
            boolean result = this.booleanCall(ClusterOperation.CONCURRENT_MAP_PUT_MULTI, name, key, value, 0L, -1L);
            if (result) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            }
            return result;
        }
    }

    class MAdd
    extends MBackupAndMigrationAwareOp {
        MAdd() {
        }

        boolean addToList(String name, Object value) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                txn.attachAddOp(name, value);
                return true;
            }
            Data key = ThreadContext.get().toData(value);
            boolean result = this.booleanCall(ClusterOperation.CONCURRENT_MAP_ADD_TO_LIST, name, key, null, 0L, -1L);
            this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_ADD);
            return result;
        }

        boolean addToSet(String name, Object value) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (!txn.has(name, value)) {
                    MContainsKey containsKey = new MContainsKey();
                    if (!containsKey.containsKey(name, value)) {
                        txn.attachPutOp(name, value, null, true);
                        return true;
                    }
                    return false;
                }
                return false;
            }
            Data key = ThreadContext.get().toData(value);
            boolean result = this.booleanCall(ClusterOperation.CONCURRENT_MAP_ADD_TO_SET, name, key, null, 0L, -1L);
            this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_ADD);
            return result;
        }
    }

    class MRemove
    extends MBackupAndMigrationAwareOp {
        MRemove() {
        }

        public Object remove(String name, Object key, long timeout) {
            return this.txnalRemove(ClusterOperation.CONCURRENT_MAP_REMOVE, name, key, null, timeout);
        }

        public Object removeIfSame(String name, Object key, Object value, long timeout) {
            return this.txnalRemove(ClusterOperation.CONCURRENT_MAP_REMOVE_IF_SAME, name, key, value, timeout);
        }

        private Object txnalRemove(ClusterOperation operation, String name, Object key, Object value, long timeout) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (!txn.has(name, key)) {
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, 8000L);
                    if (!locked) {
                        ConcurrentMapManager.this.throwCME(key);
                    }
                    Object oldObject = null;
                    Data oldValue = mlock.oldValue;
                    if (oldValue != null) {
                        oldObject = threadContext.toObject(oldValue);
                    }
                    int removedValueCount = 0;
                    if (oldObject != null) {
                        if (oldObject instanceof CMap.Values) {
                            CMap.Values values = (CMap.Values)oldObject;
                            removedValueCount = values.size();
                        } else {
                            removedValueCount = 1;
                        }
                    }
                    txn.attachRemoveOp(name, key, value, oldObject == null, removedValueCount);
                    return oldObject;
                }
                return txn.attachRemoveOp(name, key, value, false);
            }
            Object oldValue = this.objectCall(operation, name, key, value, timeout, -1L);
            if (oldValue != null) {
                if (oldValue instanceof AddressAwareException) {
                    ConcurrentMapManager.this.rethrowException(operation, (AddressAwareException)oldValue);
                }
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE);
            }
            return oldValue;
        }
    }

    class MRemoveItem
    extends MBackupAndMigrationAwareOp {
        MRemoveItem() {
        }

        public boolean removeItem(String name, Object key) {
            return this.removeItem(name, key, null);
        }

        public boolean removeItem(String name, Object key, Object value) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                try {
                    if (!txn.has(name, key)) {
                        MLock mlock = new MLock();
                        boolean locked = mlock.lockAndGetValue(name, key, 8000L);
                        if (!locked) {
                            ConcurrentMapManager.this.throwCME(key);
                        }
                        Object oldObject = null;
                        Data oldValue = mlock.oldValue;
                        if (oldValue != null) {
                            oldObject = threadContext.toObject(oldValue);
                        }
                        txn.attachRemoveOp(name, key, null, oldObject == null);
                        return oldObject != null;
                    }
                    return txn.attachRemoveOp(name, key, null, false) != null;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return false;
                }
            }
            boolean removed = this.booleanCall(ClusterOperation.CONCURRENT_MAP_REMOVE_ITEM, name, key, value, 0L, -1L);
            if (removed) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE);
            }
            return removed;
        }
    }

    class MValueCount
    extends BaseManager.MTargetAwareOp {
        MValueCount() {
        }

        public Object count(String name, Object key, long timeout) {
            this.request.setLongRequest();
            return this.objectCall(ClusterOperation.CONCURRENT_MAP_VALUE_COUNT, name, key, null, timeout, -1L);
        }

        public boolean isMigrationAware() {
            return true;
        }
    }

    class MGet
    extends BaseManager.MTargetAwareOp {
        Object key = null;
        MapNearCache nearCache = null;

        MGet() {
        }

        public Object get(String name, Object key, long timeout) {
            Object value;
            Object value2;
            this.key = key;
            ThreadContext tc = ThreadContext.get();
            TransactionImpl txn = tc.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1 && txn.has(name, key)) {
                return txn.get(name, key);
            }
            this.nearCache = (MapNearCache)ConcurrentMapManager.this.mapCaches.get(name);
            if (this.nearCache != null && (value2 = this.nearCache.get(key)) != null) {
                return value2;
            }
            LocallyOwnedMap locallyOwnedMap = (LocallyOwnedMap)ConcurrentMapManager.this.mapLocallyOwnedMaps.get(name);
            if (locallyOwnedMap != null && (value = locallyOwnedMap.get(key)) != Constants.Objects.OBJECT_REDO) {
                return value;
            }
            value = this.objectCall(ClusterOperation.CONCURRENT_MAP_GET, name, key, null, timeout, -1L);
            if (value instanceof AddressAwareException) {
                ConcurrentMapManager.this.rethrowException(this.request.operation, (AddressAwareException)value);
            }
            return value;
        }

        public void reset() {
            this.key = null;
            this.nearCache = null;
            super.reset();
        }

        public final void handleNoneRedoResponse(Packet packet) {
            Data value;
            if (this.nearCache != null && (value = packet.getValueData()) != null && value.size() > 0) {
                this.nearCache.put(this.key, this.request.key, packet.getValueData());
            }
            super.handleNoneRedoResponse(packet);
        }

        public boolean isMigrationAware() {
            return true;
        }
    }

    class MAddKeyListener
    extends BaseManager.MTargetAwareOp {
        MAddKeyListener() {
        }

        public boolean addListener(String name, boolean add, Object key, boolean includeValue) {
            ClusterOperation operation = add ? ClusterOperation.ADD_LISTENER : ClusterOperation.REMOVE_LISTENER;
            this.setLocal(operation, name, key, null, -1L, -1L);
            this.request.longValue = includeValue ? 1L : 0L;
            this.request.setBooleanRequest();
            this.doOp();
            return this.getResultAsBoolean();
        }

        public boolean isMigrationAware() {
            return true;
        }
    }

    class MGetMapEntry
    extends BaseManager.MTargetAwareOp {
        MGetMapEntry() {
        }

        public MapEntry get(String name, Object key) {
            CMap.CMapEntry mapEntry;
            Object result = this.objectCall(ClusterOperation.CONCURRENT_MAP_GET_MAP_ENTRY, name, key, null, 0L, -1L);
            if (result instanceof Data) {
                result = IOUtil.toObject((Data)result);
            }
            if ((mapEntry = (CMap.CMapEntry)result) != null) {
                mapEntry.setHazelcastInstance(ConcurrentMapManager.this.node.factory);
                mapEntry.set(name, key);
            }
            return mapEntry;
        }
    }

    class MMigrate
    extends MBackupAwareOp {
        MMigrate() {
        }

        public boolean migrateMulti(Record record, Data value) {
            this.request.setFromRecord(record);
            this.request.value = value;
            this.request.operation = ClusterOperation.CONCURRENT_MAP_MIGRATE_RECORD;
            this.request.setBooleanRequest();
            this.doOp();
            boolean result = this.getResultAsBoolean();
            this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            return result;
        }

        public boolean migrate(Record record) {
            this.request.setFromRecord(record);
            if (this.request.key == null) {
                throw new RuntimeException("req.key is null " + this.request.redoCount);
            }
            this.request.operation = ClusterOperation.CONCURRENT_MAP_MIGRATE_RECORD;
            this.request.setBooleanRequest();
            this.doOp();
            boolean result = this.getResultAsBoolean();
            this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            return result;
        }

        public void setTarget() {
            Block block;
            this.target = ConcurrentMapManager.this.getKeyOwner(this.request.key);
            if (this.target == null && (block = ConcurrentMapManager.this.blocks[this.request.blockId]) != null) {
                this.target = block.getMigrationAddress();
            }
        }
    }

    class MEvict
    extends MBackupAndMigrationAwareOp {
        MEvict() {
        }

        public boolean evict(String name, Object key) {
            return this.evict(ClusterOperation.CONCURRENT_MAP_EVICT, name, key);
        }

        public boolean evict(ClusterOperation operation, String name, Object key) {
            Data k = key instanceof Data ? (Data)key : IOUtil.toData(key);
            this.request.setLocal(operation, name, k, null, 0, -1L, -1L, ConcurrentMapManager.this.thisAddress);
            this.request.setBooleanRequest();
            this.doOp();
            boolean result = this.getResultAsBoolean();
            if (result) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE);
            }
            return result;
        }
    }

    class MContainsKey
    extends BaseManager.MTargetAwareOp {
        Object key = null;
        MapNearCache nearCache = null;

        MContainsKey() {
        }

        public boolean containsEntry(String name, Object key, Object value) {
            return this.booleanCall(ClusterOperation.CONCURRENT_MAP_CONTAINS, name, key, value, 0L, -1L);
        }

        public boolean containsKey(String name, Object key) {
            this.key = key;
            this.nearCache = (MapNearCache)ConcurrentMapManager.this.mapCaches.get(name);
            Data dataKey = IOUtil.toData(key);
            if (this.nearCache != null) {
                if (this.nearCache.containsKey(key)) {
                    return true;
                }
                if (this.nearCache.getMaxSize() == Integer.MAX_VALUE) {
                    return false;
                }
            }
            return this.booleanCall(ClusterOperation.CONCURRENT_MAP_CONTAINS, name, dataKey, null, 0L, -1L);
        }

        public void reset() {
            this.key = null;
            this.nearCache = null;
            super.reset();
        }

        protected void setResult(Object obj) {
            if (obj != null && obj == Boolean.TRUE && this.nearCache != null) {
                this.nearCache.setContainsKey(this.key, this.request.key);
            }
            super.setResult(obj);
        }

        public boolean isMigrationAware() {
            return true;
        }
    }

    class MLock
    extends MBackupAndMigrationAwareOp {
        volatile Data oldValue = null;

        MLock() {
        }

        public boolean unlock(String name, Object key, long timeout) {
            boolean unlocked = this.booleanCall(ClusterOperation.CONCURRENT_MAP_UNLOCK, name, key, null, timeout, -1L);
            if (unlocked) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK);
            }
            return unlocked;
        }

        public boolean lock(String name, Object key, long timeout) {
            boolean locked = this.booleanCall(ClusterOperation.CONCURRENT_MAP_LOCK, name, key, null, timeout, -1L);
            if (locked) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK);
            }
            return locked;
        }

        public boolean lockAndGetValue(String name, Object key, long timeout) {
            return this.lockAndGetValue(name, key, null, timeout);
        }

        public boolean lockAndGetValue(String name, Object key, Object value, long timeout) {
            boolean locked = this.booleanCall(ClusterOperation.CONCURRENT_MAP_LOCK_AND_GET_VALUE, name, key, value, timeout, -1L);
            if (locked) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK);
            }
            return locked;
        }

        public void afterGettingResult(Request request) {
            if (request.operation == ClusterOperation.CONCURRENT_MAP_LOCK_AND_GET_VALUE && this.oldValue == null) {
                this.oldValue = request.value;
            }
            super.afterGettingResult(request);
        }

        public void handleNoneRedoResponse(Packet packet) {
            if (this.request.operation == ClusterOperation.CONCURRENT_MAP_LOCK_AND_GET_VALUE) {
                this.oldValue = packet.getValueData();
            }
            super.handleNoneRedoResponse(packet);
        }
    }
}

