/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.util.SimpleBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AsyncCall
implements Future,
Runnable {
    private static final Object NULL = new Object();
    private final BlockingQueue responseQ = new SimpleBlockingQueue();
    private final CallContext callContext = ThreadContext.get().getCallContext();

    protected abstract void call();

    public void run() {
        ThreadContext.get().setCallContext(this.callContext);
        this.call();
    }

    public void setResult(Object obj) {
        if (obj == null) {
            obj = NULL;
        }
        this.responseQ.offer(obj);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return false;
    }

    public Object get() throws InterruptedException, ExecutionException {
        return this.processResult(this.responseQ.take());
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object result = this.responseQ.poll(timeout, unit);
        if (result == null) {
            throw new TimeoutException();
        }
        return this.processResult(result);
    }

    private Object processResult(Object result) throws ExecutionException {
        if (result == NULL) {
            return null;
        }
        if (result instanceof Throwable) {
            throw new ExecutionException((Throwable)result);
        }
        return result;
    }
}

