/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.provider;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.HazelcastInstanceFactory;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.provider.HazelcastCache;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Properties;
import java.util.logging.Level;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;

public final class HazelcastCacheProvider
implements CacheProvider {
    private static final ILogger LOG = Logger.getLogger(HazelcastCacheProvider.class.getName());
    private HazelcastInstance instance;

    public Cache buildCache(String name, Properties properties) throws CacheException {
        return new HazelcastCache(this.instance, name);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return HazelcastTimestamper.nextTimestamp(this.instance);
    }

    public void start(Properties props) throws CacheException {
        LOG.log(Level.INFO, "Starting up HazelcastCacheProvider...");
        this.instance = HazelcastInstanceFactory.createInstance(props);
    }

    public void stop() {
        LOG.log(Level.INFO, "Shutting down HazelcastCacheProvider...");
        this.instance.shutdown();
    }
}

