/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.access;

import com.hazelcast.core.IMap;
import com.hazelcast.hibernate.access.AbstractAccessDelegate;
import com.hazelcast.hibernate.region.HazelcastRegion;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadWriteAccessDelegate<T extends HazelcastRegion>
extends AbstractAccessDelegate<T> {
    public ReadWriteAccessDelegate(T hazelcastRegion) {
        super(hazelcastRegion);
    }

    @Override
    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    @Override
    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict(Object key) throws CacheException {
        IMap cache = this.getCache();
        cache.lock(key);
        try {
            cache.remove(key);
        }
        finally {
            cache.unlock(key);
        }
    }

    @Override
    public void evictAll() throws CacheException {
        this.getCache().clear();
    }

    @Override
    public Object get(Object key, long txTimestamp) throws CacheException {
        return this.getCache().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insert(Object key, Object value, Object version) throws CacheException {
        IMap cache = this.getCache();
        cache.lock(key);
        try {
            cache.put(key, value);
        }
        finally {
            cache.unlock(key);
        }
        return true;
    }

    @Override
    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return null;
    }

    @Override
    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        IMap cache = this.getCache();
        cache.lock(key);
        try {
            cache.put(key, value);
        }
        finally {
            cache.unlock(key);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        IMap cache = this.getCache();
        cache.lock(key);
        try {
            cache.put(key, value);
        }
        finally {
            cache.unlock(key);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object key) throws CacheException {
        IMap cache = this.getCache();
        cache.lock(key);
        try {
            cache.remove(key);
        }
        finally {
            cache.unlock(key);
        }
    }

    @Override
    public void removeAll() throws CacheException {
        this.getCache().clear();
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) throws CacheException {
    }

    @Override
    public void unlockRegion(SoftLock lock) throws CacheException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        IMap cache = this.getCache();
        cache.lock(key);
        try {
            cache.put(key, value);
        }
        finally {
            cache.unlock(key);
        }
        return true;
    }
}

