/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.merge.AddNewEntryMergePolicy;
import com.hazelcast.merge.HigherHitsMergePolicy;
import com.hazelcast.merge.LatestUpdateMergePolicy;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    public static final int DEFAULT_PORT = 5701;
    private String xmlConfig = null;
    private GroupConfig groupConfig = new GroupConfig();
    private int port = 5701;
    private boolean reuseAddress = false;
    private boolean portAutoIncrement = true;
    private ExecutorConfig executorConfig = new ExecutorConfig();
    private Map<String, ExecutorConfig> mapExecutors = new ConcurrentHashMap<String, ExecutorConfig>();
    private Map<String, TopicConfig> mapTopicConfigs = new ConcurrentHashMap<String, TopicConfig>();
    private Map<String, QueueConfig> mapQueueConfigs = new ConcurrentHashMap<String, QueueConfig>();
    private Map<String, MapConfig> mapConfigs = new ConcurrentHashMap<String, MapConfig>();
    private URL configurationUrl;
    private File configurationFile;
    private NetworkConfig networkConfig = new NetworkConfig();
    private boolean superClient = false;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private Properties properties = new Properties();
    private Map<String, MergePolicyConfig> mapMergePolicyConfigs = new ConcurrentHashMap<String, MergePolicyConfig>();

    public Config() {
        String os;
        String superClientProp = System.getProperty("hazelcast.super.client");
        if ("true".equalsIgnoreCase(superClientProp)) {
            this.superClient = true;
        }
        this.reuseAddress = (os = System.getProperty("os.name").toLowerCase()).indexOf("win") == -1;
        this.addMergePolicyConfig(new MergePolicyConfig("hz.ADD_NEW_ENTRY", new AddNewEntryMergePolicy()));
        this.addMergePolicyConfig(new MergePolicyConfig("hz.HIGHER_HITS", new HigherHitsMergePolicy()));
        this.addMergePolicyConfig(new MergePolicyConfig("hz.LATEST_UPDATE", new LatestUpdateMergePolicy()));
    }

    public void addMergePolicyConfig(MergePolicyConfig mergePolicyConfig) {
        this.mapMergePolicyConfigs.put(mergePolicyConfig.getName(), mergePolicyConfig);
    }

    public MergePolicyConfig getMergePolicyConfig(String name) {
        return this.mapMergePolicyConfigs.get(name);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Config setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Config setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public QueueConfig getQueueConfig(String name) {
        Set<String> qNames = this.mapQueueConfigs.keySet();
        for (String pattern : qNames) {
            if (!this.nameMatches(name, pattern)) continue;
            return this.mapQueueConfigs.get(pattern);
        }
        QueueConfig defaultConfig = this.mapQueueConfigs.get("default");
        if (defaultConfig == null) {
            defaultConfig = new QueueConfig();
            this.mapQueueConfigs.put("default", defaultConfig);
        }
        return defaultConfig;
    }

    public MapConfig getMapConfig(String name) {
        Set<String> qNames = this.mapConfigs.keySet();
        for (String pattern : qNames) {
            if (!this.nameMatches(name, pattern)) continue;
            return this.mapConfigs.get(pattern);
        }
        MapConfig defaultConfig = this.mapConfigs.get("default");
        if (defaultConfig == null) {
            defaultConfig = new MapConfig();
            this.mapConfigs.put("default", defaultConfig);
        }
        return defaultConfig;
    }

    public TopicConfig getTopicConfig(String name) {
        Set<String> tNames = this.mapTopicConfigs.keySet();
        for (String pattern : tNames) {
            if (!this.nameMatches(name, pattern)) continue;
            return this.mapTopicConfigs.get(pattern);
        }
        TopicConfig defaultConfig = this.mapTopicConfigs.get("default");
        if (defaultConfig == null) {
            defaultConfig = new TopicConfig();
            this.mapTopicConfigs.put("default", defaultConfig);
        }
        return defaultConfig;
    }

    private boolean nameMatches(String name, String pattern) {
        int index = pattern.indexOf(42);
        if (index == -1) {
            return name.equals(pattern);
        }
        String firstPart = pattern.substring(0, index);
        int indexFirstPart = name.indexOf(firstPart, 0);
        if (indexFirstPart == -1) {
            return false;
        }
        String secondPart = pattern.substring(index + 1);
        int indexSecondPart = name.indexOf(secondPart, index + 1);
        return indexSecondPart != -1;
    }

    public NetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public Config setNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
        return this;
    }

    public String getXmlConfig() {
        return this.xmlConfig;
    }

    public Config setXmlConfig(String xmlConfig) {
        this.xmlConfig = xmlConfig;
        return this;
    }

    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public Config setGroupConfig(GroupConfig groupConfig) {
        this.groupConfig = groupConfig;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public Config setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean isPortAutoIncrement() {
        return this.portAutoIncrement;
    }

    public Config setPortAutoIncrement(boolean portAutoIncrement) {
        this.portAutoIncrement = portAutoIncrement;
        return this;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public Config setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
        return this;
    }

    public ExecutorConfig getExecutorConfig() {
        return this.executorConfig;
    }

    public Config setExecutorConfig(ExecutorConfig executorConfig) {
        this.addExecutorConfig(executorConfig);
        return this;
    }

    public Config addExecutorConfig(ExecutorConfig executorConfig) {
        this.mapExecutors.put(executorConfig.getName(), executorConfig);
        return this;
    }

    public ExecutorConfig getExecutorConfig(String name) {
        ExecutorConfig defaultConfig;
        ExecutorConfig ec = this.mapExecutors.get(name);
        if (ec == null && (defaultConfig = this.mapExecutors.get("default")) != null) {
            ec = new ExecutorConfig(name, defaultConfig.getCorePoolSize(), defaultConfig.getMaxPoolSize(), defaultConfig.getKeepAliveSeconds());
        }
        if (ec == null) {
            ec = new ExecutorConfig(name);
            this.mapExecutors.put(name, ec);
        }
        return ec;
    }

    public Collection<ExecutorConfig> getExecutorConfigs() {
        return this.mapExecutors.values();
    }

    public Map<String, TopicConfig> getTopicConfigs() {
        return this.mapTopicConfigs;
    }

    public Config setTopicConfigs(Map<String, TopicConfig> mapTopicConfigs) {
        this.mapTopicConfigs = mapTopicConfigs;
        return this;
    }

    public Map<String, QueueConfig> getQConfigs() {
        return this.mapQueueConfigs;
    }

    public Config setMapQConfigs(Map<String, QueueConfig> mapQConfigs) {
        this.mapQueueConfigs = mapQConfigs;
        return this;
    }

    public Map<String, MapConfig> getMapConfigs() {
        return this.mapConfigs;
    }

    public Config setMapConfigs(Map<String, MapConfig> mapConfigs) {
        this.mapConfigs = mapConfigs;
        return this;
    }

    public URL getConfigurationUrl() {
        return this.configurationUrl;
    }

    public Config setConfigurationUrl(URL configurationUrl) {
        this.configurationUrl = configurationUrl;
        return this;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public Config setConfigurationFile(File configurationFile) {
        this.configurationFile = configurationFile;
        return this;
    }

    public boolean isSuperClient() {
        return this.superClient;
    }

    public Config setSuperClient(boolean superClient) {
        this.superClient = superClient;
        return this;
    }
}

