/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.ClientRunnable;
import com.hazelcast.client.Connection;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.NoMemberAvailableException;
import com.hazelcast.core.Member;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IORunnable
extends ClientRunnable {
    protected Map<Long, Call> callMap;
    protected final HazelcastClient client;
    final ILogger logger = Logger.getLogger(this.getClass().getName());

    public IORunnable(HazelcastClient client, Map<Long, Call> calls) {
        this.client = client;
        this.callMap = calls;
    }

    public void interruptWaitingCalls() {
        Collection<Call> calls = this.callMap.values();
        for (Call call : calls) {
            call.setResponse(new NoMemberAvailableException());
        }
        calls.clear();
        new Thread(new Runnable(){

            public void run() {
                IORunnable.this.client.shutdown();
            }
        }).start();
    }

    protected synchronized void onDisconnect(Connection oldConnection) {
        boolean shouldExecuteOnDisconnect = this.client.getConnectionManager().shouldExecuteOnDisconnect(oldConnection);
        if (!shouldExecuteOnDisconnect) {
            return;
        }
        Member leftMember = oldConnection.getMember();
        Collection<Call> calls = this.callMap.values();
        for (Call call : calls) {
            Call removed = this.callMap.remove(call.getId());
            if (removed == null || this.client.getOutRunnable().queue.contains(removed)) continue;
            this.logger.log(Level.FINE, Thread.currentThread() + ": Calling on disconnect " + leftMember);
            removed.onDisconnect(leftMember);
        }
    }

    private boolean restoredConnection(Connection connection, boolean isOldConnectionNull, long oldConnectionId) {
        return !isOldConnectionNull && connection != null && (long)connection.getVersion() != oldConnectionId;
    }

    protected boolean restoredConnection(Connection oldConnection, Connection newConnection) {
        boolean isOldConnectionNull;
        long oldConnectionId = -1L;
        boolean bl = isOldConnectionNull = oldConnection == null;
        if (!isOldConnectionNull) {
            oldConnectionId = oldConnection.getVersion();
        }
        return this.restoredConnection(newConnection, isOldConnectionNull, oldConnectionId);
    }
}

