/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.nio.Address;

public class DistributedLock {
    Address lockAddress = null;
    int lockThreadId = -1;
    int lockCount;

    public DistributedLock() {
    }

    public DistributedLock(DistributedLock copy) {
        this.lockAddress = copy.lockAddress;
        this.lockCount = copy.lockCount;
        this.lockThreadId = copy.lockThreadId;
    }

    public DistributedLock(Address address, int threadId) {
        this.lockAddress = address;
        this.lockThreadId = threadId;
        this.lockCount = 1;
    }

    public DistributedLock(Address lockAddress, int lockThreadId, int lockCount) {
        this.lockAddress = lockAddress;
        this.lockThreadId = lockThreadId;
        this.lockCount = lockCount;
    }

    public boolean isLocked() {
        return this.lockCount > 0;
    }

    public boolean isLockedBy(Address address, int threadId) {
        return this.lockThreadId == threadId && this.lockAddress.equals(address);
    }

    public boolean lock(Address address, int threadId) {
        if (this.lockCount == 0) {
            this.lockAddress = address;
            this.lockThreadId = threadId;
            ++this.lockCount;
            return true;
        }
        if (this.isLockedBy(address, threadId)) {
            ++this.lockCount;
            return true;
        }
        return false;
    }

    public boolean unlock(Address address, int threadId) {
        if (this.lockCount == 0) {
            return false;
        }
        if (this.isLockedBy(address, threadId)) {
            --this.lockCount;
            if (this.lockCount == 0) {
                this.lockAddress = null;
                this.lockThreadId = -1;
            }
            return true;
        }
        return false;
    }

    public boolean testLock(int threadId, Address address) {
        return this.lockCount == 0 || this.getLockThreadId() == threadId && this.getLockAddress().equals(address);
    }

    public void clear() {
        this.lockThreadId = -1;
        this.lockCount = 0;
        this.lockAddress = null;
    }

    public Address getLockAddress() {
        return this.lockAddress;
    }

    public int getLockThreadId() {
        return this.lockThreadId;
    }

    public int getLockCount() {
        return this.lockCount;
    }

    public String toString() {
        return "Lock{lockAddress=" + this.lockAddress + ", lockThreadId=" + this.lockThreadId + ", lockCount=" + this.lockCount + '}';
    }
}

