/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ClientService;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Packet;
import java.util.logging.Level;

public class ClientRequestHandler
extends FallThroughRunnable {
    private final Packet packet;
    private final CallContext callContext;
    private final Node node;
    private final ClientService.ClientOperationHandler clientOperationHandler;
    private volatile Thread runningThread = null;
    private volatile boolean valid = true;
    private final ILogger logger;

    public ClientRequestHandler(Node node, Packet packet, CallContext callContext, ClientService.ClientOperationHandler clientOperationHandler) {
        this.packet = packet;
        this.callContext = callContext;
        this.node = node;
        this.clientOperationHandler = clientOperationHandler;
        this.logger = node.getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        this.runningThread = Thread.currentThread();
        ThreadContext.get().setCallContext(this.callContext);
        try {
            if (!this.valid) {
                return;
            }
            this.clientOperationHandler.handle(this.node, this.packet);
            this.node.clientService.getClientEndpoint(this.packet.conn).removeRequest(this);
            this.clientOperationHandler.postHandle(this.packet);
        }
        catch (Throwable e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
            if (this.node.isActive()) {
                throw (RuntimeException)e;
            }
        }
        finally {
            this.runningThread = null;
        }
    }

    public void cancel() {
        this.valid = false;
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
    }
}

