/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.config.Config;
import com.hazelcast.impl.NodeType;
import com.hazelcast.nio.Address;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class JoinRequest
extends AbstractRemotelyProcessable {
    protected NodeType nodeType = NodeType.MEMBER;
    public Address address;
    public Address to;
    public byte packetVersion;
    public int buildNumber;
    public Config config;

    public JoinRequest() {
    }

    public JoinRequest(Address address, Config config, NodeType type, byte packetVersion, int buildNumber) {
        this(null, address, config, type, packetVersion, buildNumber);
    }

    public JoinRequest(Address to, Address address, Config config, NodeType type, byte packetVersion, int buildNumber) {
        this.to = to;
        this.address = address;
        this.config = config;
        this.nodeType = type;
        this.packetVersion = packetVersion;
        this.buildNumber = buildNumber;
    }

    public void readData(DataInput in) throws IOException {
        this.packetVersion = in.readByte();
        this.buildNumber = in.readInt();
        boolean hasTo = in.readBoolean();
        if (hasTo) {
            this.to = new Address();
            this.to.readData(in);
        }
        this.address = new Address();
        this.address.readData(in);
        this.nodeType = NodeType.create(in.readInt());
        this.config = new Config();
        this.config.readData(in);
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeByte(this.packetVersion);
        out.writeInt(this.buildNumber);
        boolean hasTo = this.to != null;
        out.writeBoolean(hasTo);
        if (hasTo) {
            this.to.writeData(out);
        }
        this.address.writeData(out);
        out.writeInt(this.nodeType.getValue());
        this.config.writeData(out);
    }

    public String toString() {
        return "JoinRequest{nodeType=" + (Object)((Object)this.nodeType) + ", address=" + this.address + ", buildNumber='" + this.buildNumber + '\'' + ", packetVersion='" + this.packetVersion + '\'' + ", config='" + this.config + "'}";
    }

    public void process() {
        this.getNode().clusterManager.handleJoinRequest(this);
    }
}

