/*
 * Decompiled with CFR 0.152.
 */
package com.hannesdorfmann.adapterdelegates4;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.AdapterListUpdateCallback;
import androidx.recyclerview.widget.AsyncDifferConfig;
import androidx.recyclerview.widget.AsyncListDiffer;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListUpdateCallback;
import androidx.recyclerview.widget.RecyclerView;
import com.hannesdorfmann.adapterdelegates4.AdapterDelegatesManager;
import java.util.List;

public class AsyncListDifferDelegationAdapter<T>
extends RecyclerView.Adapter {
    protected final AdapterDelegatesManager<List<T>> delegatesManager;
    protected final AsyncListDiffer<T> differ;

    public AsyncListDifferDelegationAdapter(@NonNull DiffUtil.ItemCallback<T> diffCallback) {
        this(diffCallback, new AdapterDelegatesManager<List<T>>());
    }

    public AsyncListDifferDelegationAdapter(@NonNull DiffUtil.ItemCallback<T> diffCallback, @NonNull AdapterDelegatesManager<List<T>> delegatesManager) {
        if (diffCallback == null) {
            throw new NullPointerException("ItemCallback is null");
        }
        if (delegatesManager == null) {
            throw new NullPointerException("AdapterDelegatesManager is null");
        }
        this.differ = new AsyncListDiffer((RecyclerView.Adapter)this, diffCallback);
        this.delegatesManager = delegatesManager;
    }

    public AsyncListDifferDelegationAdapter(@NonNull AsyncDifferConfig differConfig, @NonNull AdapterDelegatesManager<List<T>> delegatesManager) {
        if (differConfig == null) {
            throw new NullPointerException("AsyncDifferConfig is null");
        }
        if (delegatesManager == null) {
            throw new NullPointerException("AdapterDelegatesManager is null");
        }
        this.differ = new AsyncListDiffer((ListUpdateCallback)new AdapterListUpdateCallback((RecyclerView.Adapter)this), differConfig);
        this.delegatesManager = delegatesManager;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return this.delegatesManager.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        this.delegatesManager.onBindViewHolder(this.differ.getCurrentList(), position, holder, null);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position, @NonNull List payloads) {
        this.delegatesManager.onBindViewHolder(this.differ.getCurrentList(), position, holder, payloads);
    }

    public int getItemViewType(int position) {
        return this.delegatesManager.getItemViewType(this.differ.getCurrentList(), position);
    }

    public void onViewRecycled(@NonNull RecyclerView.ViewHolder holder) {
        this.delegatesManager.onViewRecycled(holder);
    }

    public boolean onFailedToRecycleView(@NonNull RecyclerView.ViewHolder holder) {
        return this.delegatesManager.onFailedToRecycleView(holder);
    }

    public void onViewAttachedToWindow(@NonNull RecyclerView.ViewHolder holder) {
        this.delegatesManager.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(@NonNull RecyclerView.ViewHolder holder) {
        this.delegatesManager.onViewDetachedFromWindow(holder);
    }

    public List<T> getItems() {
        return this.differ.getCurrentList();
    }

    public void setItems(List<T> items) {
        this.differ.submitList(items);
    }

    public int getItemCount() {
        return this.differ.getCurrentList().size();
    }
}

