/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.NShort;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.algoritm.Dijkstra;
import com.hankcs.hanlp.recognition.nr.JapanesePersonRecognition;
import com.hankcs.hanlp.recognition.nr.PersonRecognition;
import com.hankcs.hanlp.recognition.nr.TranslatedPersonRecognition;
import com.hankcs.hanlp.recognition.ns.PlaceRecognition;
import com.hankcs.hanlp.recognition.nt.OrganizationRecognition;
import com.hankcs.hanlp.seg.NShort.Path.NShortPath;
import com.hankcs.hanlp.seg.WordBasedGenerativeModelSegment;
import com.hankcs.hanlp.seg.common.Graph;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import java.util.LinkedList;
import java.util.List;

public class NShortSegment
extends WordBasedGenerativeModelSegment {
    List<Vertex> BiOptimumSegment(WordNet wordNetOptimum) {
        Graph graph = NShortSegment.GenerateBiGraph(wordNetOptimum);
        if (HanLP.Config.DEBUG) {
            System.out.printf("\u7ec6\u5206\u8bcd\u56fe\uff1a%s\n", graph.printByTo());
        }
        NShortPath nShortPath = new NShortPath(graph, 1);
        List<int[]> spResult = nShortPath.getNPaths(1);
        assert (spResult.size() > 0) : "\u6700\u77ed\u8def\u5f84\u6c42\u89e3\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4e0b\u56fe\u662f\u5426\u6709\u60ac\u5b64\u8282\u70b9\u6216\u8d1f\u5708\n" + graph.printByTo();
        return graph.parsePath(spResult.get(0));
    }

    @Override
    public List<Term> segSentence(char[] sentence) {
        WordNet wordNetOptimum = new WordNet(sentence);
        WordNet wordNetAll = new WordNet(sentence);
        List<List<Vertex>> coarseResult = this.BiSegment(sentence, 2, wordNetOptimum, wordNetAll);
        boolean NERexists = false;
        for (List<Vertex> vertexList : coarseResult) {
            if (HanLP.Config.DEBUG) {
                System.out.println("\u7c97\u5206\u7ed3\u679c" + NShortSegment.convert(vertexList, false));
            }
            if (!this.config.ner) continue;
            wordNetOptimum.addAll(vertexList);
            int preSize = wordNetOptimum.size();
            if (this.config.nameRecognize) {
                PersonRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.translatedNameRecognize) {
                TranslatedPersonRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.japaneseNameRecognize) {
                JapanesePersonRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.placeRecognize) {
                PlaceRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.organizationRecognize) {
                vertexList = Dijkstra.compute(NShortSegment.GenerateBiGraph(wordNetOptimum));
                wordNetOptimum.addAll(vertexList);
                OrganizationRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (NERexists || preSize == wordNetOptimum.size()) continue;
            NERexists = true;
        }
        List<Vertex> vertexList = coarseResult.get(0);
        if (NERexists) {
            Graph graph = NShortSegment.GenerateBiGraph(wordNetOptimum);
            vertexList = Dijkstra.compute(graph);
            if (HanLP.Config.DEBUG) {
                System.out.printf("\u7ec6\u5206\u8bcd\u7f51\uff1a\n%s\n", wordNetOptimum);
                System.out.printf("\u7ec6\u5206\u8bcd\u56fe\uff1a%s\n", graph.printByTo());
            }
        }
        if (this.config.numberQuantifierRecognize) {
            this.mergeNumberQuantifier(vertexList, wordNetAll, this.config);
        }
        if (this.config.indexMode) {
            return NShortSegment.decorateResultForIndexMode(vertexList, wordNetAll);
        }
        if (this.config.speechTagging) {
            NShortSegment.speechTagging(vertexList);
        }
        return NShortSegment.convert(vertexList, this.config.offset);
    }

    public List<List<Vertex>> BiSegment(char[] sSentence, int nKind, WordNet wordNetOptimum, WordNet wordNetAll) {
        NShortPath nShortPath;
        List<int[]> spResult;
        LinkedList<List<Vertex>> coarseResult = new LinkedList<List<Vertex>>();
        this.GenerateWordNet(sSentence, wordNetAll);
        Graph graph = NShortSegment.GenerateBiGraph(wordNetAll);
        if (HanLP.Config.DEBUG) {
            System.out.printf("\u6253\u5370\u8bcd\u56fe\uff1a%s\n", graph.printByTo());
        }
        if ((spResult = (nShortPath = new NShortPath(graph, nKind)).getNPaths(nKind * 2)).size() == 0) {
            throw new RuntimeException(nKind + "-\u6700\u77ed\u8def\u5f84\u6c42\u89e3\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4e0a\u9762\u7684\u8bcd\u7f51\u662f\u5426\u5b58\u5728\u8d1f\u5708\u6216\u60ac\u5b64\u8282\u70b9");
        }
        for (int[] path : spResult) {
            List<Vertex> vertexes = graph.parsePath(path);
            NShortSegment.GenerateWord(vertexes, wordNetOptimum);
            coarseResult.add(vertexes);
        }
        return coarseResult;
    }

    public static List<Term> parse(String text) {
        return new NShortSegment().seg(text);
    }

    @Override
    public NShortSegment enablePartOfSpeechTagging(boolean enable) {
        this.config.speechTagging = enable;
        return this;
    }

    @Override
    public NShortSegment enablePlaceRecognize(boolean enable) {
        this.config.placeRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    @Override
    public NShortSegment enableOrganizationRecognize(boolean enable) {
        this.config.organizationRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    @Override
    public NShortSegment enableTranslatedNameRecognize(boolean enable) {
        this.config.translatedNameRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    @Override
    public NShortSegment enableJapaneseNameRecognize(boolean enable) {
        this.config.japaneseNameRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    @Override
    public NShortSegment enableOffset(boolean enable) {
        this.config.offset = enable;
        return this;
    }

    @Override
    public NShortSegment enableAllNamedEntityRecognize(boolean enable) {
        this.config.nameRecognize = enable;
        this.config.japaneseNameRecognize = enable;
        this.config.translatedNameRecognize = enable;
        this.config.placeRecognize = enable;
        this.config.organizationRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }
}

