/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.recognition.ns;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.algoritm.Viterbi;
import com.hankcs.hanlp.corpus.dictionary.item.EnumItem;
import com.hankcs.hanlp.corpus.tag.NS;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.ns.PlaceDictionary;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class PlaceRecognition {
    public static boolean Recognition(List<Vertex> pWordSegResult, WordNet wordNetOptimum, WordNet wordNetAll) {
        List<EnumItem<NS>> roleTagList = PlaceRecognition.roleTag(pWordSegResult, wordNetAll);
        if (HanLP.Config.DEBUG) {
            StringBuilder sbLog = new StringBuilder();
            Iterator<Vertex> iterator = pWordSegResult.iterator();
            for (EnumItem<NS> NSEnumItem : roleTagList) {
                sbLog.append('[');
                sbLog.append(iterator.next().realWord);
                sbLog.append(' ');
                sbLog.append(NSEnumItem);
                sbLog.append(']');
            }
            System.out.printf("\u5730\u540d\u89d2\u8272\u89c2\u5bdf\uff1a%s\n", sbLog.toString());
        }
        List<NS> NSList = PlaceRecognition.viterbiExCompute(roleTagList);
        if (HanLP.Config.DEBUG) {
            StringBuilder sbLog = new StringBuilder();
            Iterator<Vertex> iterator = pWordSegResult.iterator();
            sbLog.append('[');
            for (NS NS2 : NSList) {
                sbLog.append(iterator.next().realWord);
                sbLog.append('/');
                sbLog.append((Object)NS2);
                sbLog.append(" ,");
            }
            if (sbLog.length() > 1) {
                sbLog.delete(sbLog.length() - 2, sbLog.length());
            }
            sbLog.append(']');
            System.out.printf("\u5730\u540d\u89d2\u8272\u6807\u6ce8\uff1a%s\n", sbLog.toString());
        }
        PlaceDictionary.parsePattern(NSList, pWordSegResult, wordNetOptimum, wordNetAll);
        return true;
    }

    public static List<EnumItem<NS>> roleTag(List<Vertex> vertexList, WordNet wordNetAll) {
        LinkedList<EnumItem<NS>> tagList = new LinkedList<EnumItem<NS>>();
        ListIterator<Vertex> listIterator = vertexList.listIterator();
        while (listIterator.hasNext()) {
            Vertex vertex = listIterator.next();
            if (Nature.ns == vertex.getNature() && vertex.getAttribute().totalFrequency <= 1000) {
                tagList.add(new EnumItem<NS>(NS.H, 1000));
                continue;
            }
            EnumItem<NS> NSEnumItem = (EnumItem<NS>)PlaceDictionary.dictionary.get(vertex.word);
            if (NSEnumItem == null) {
                NSEnumItem = new EnumItem<NS>(NS.Z, PlaceDictionary.transformMatrixDictionary.getTotalFrequency(NS.Z));
            }
            tagList.add(NSEnumItem);
        }
        return tagList;
    }

    private static void insert(ListIterator<Vertex> listIterator, List<EnumItem<NS>> tagList, WordNet wordNetAll, int line, NS ns) {
        Vertex vertex = wordNetAll.getFirst(line);
        assert (vertex != null) : "\u5168\u8bcd\u7f51\u5c45\u7136\u6709\u7a7a\u767d\u884c\uff01";
        listIterator.add(vertex);
        tagList.add(new EnumItem<NS>(ns, 1000));
    }

    public static List<NS> viterbiExCompute(List<EnumItem<NS>> roleTagList) {
        return Viterbi.computeEnumSimply(roleTagList, PlaceDictionary.transformMatrixDictionary);
    }
}

