/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.nr;

import com.hankcs.hanlp.corpus.dictionary.DictionaryMaker;
import com.hankcs.hanlp.corpus.dictionary.item.Item;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.corpus.tag.NR;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class NRCorpusLoader {
    public static boolean load(String path) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            DictionaryMaker dictionaryMaker = new DictionaryMaker();
            while ((line = br.readLine()) != null) {
                if (line.matches(".*[\\p{P}+~$`^=|<>\uff5e`$^+=|<>\uffe5\u00d7|\\s|a-z0-9A-Z]+.*")) continue;
                Integer length = line.length();
                switch (length) {
                    case 2: {
                        Word wordB = new Word(line.substring(0, 1), NR.B.toString());
                        Word wordE = new Word(line.substring(1), NR.E.toString());
                        dictionaryMaker.add(wordB);
                        dictionaryMaker.add(wordE);
                        break;
                    }
                    case 3: {
                        Word wordB = new Word(line.substring(0, 1), NR.B.toString());
                        Word wordC = new Word(line.substring(1, 2), NR.C.toString());
                        Word wordD = new Word(line.substring(2, 3), NR.D.toString());
                        dictionaryMaker.add(wordB);
                        dictionaryMaker.add(wordC);
                        dictionaryMaker.add(wordD);
                        break;
                    }
                }
            }
            br.close();
            Predefine.logger.info(dictionaryMaker.toString());
            dictionaryMaker.saveTxtTo("data/dictionary/person/name.txt", new DictionaryMaker.Filter(){

                @Override
                public boolean onSave(Item item) {
                    return false;
                }
            });
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u53d1\u751f\u9519\u8bef");
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        NRCorpusLoader.combine();
    }

    public static void combine() {
        DictionaryMaker dictionaryMaker = DictionaryMaker.combine(new String[]{"data/dictionary/person/nr.txt", "data/dictionary/person/authornames.txt"});
        dictionaryMaker.saveTxtTo("data/dictionary/person/nr.txt");
    }
}

