/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.dynamicarray;

import com.hankcs.hanlp.collection.dynamicarray.ChainItem;
import com.hankcs.hanlp.collection.dynamicarray.DynamicArray;

public class RowFirstDynamicArray<T>
extends DynamicArray<T> {
    public ChainItem<T> GetFirstElementOfRow(int nRow) {
        ChainItem pCur = this.pHead;
        while (pCur != null && pCur.row != nRow) {
            pCur = pCur.next;
        }
        return pCur;
    }

    public ChainItem<T> GetFirstElementOfRow(int nRow, ChainItem<T> startFrom) {
        ChainItem<T> pCur = startFrom;
        while (pCur != null && pCur.row != nRow) {
            pCur = pCur.next;
        }
        return pCur;
    }

    @Override
    public void SetElement(int nRow, int nCol, T content) {
        ChainItem pCur = this.pHead;
        ChainItem pPre = null;
        if (nRow > this.RowCount) {
            this.RowCount = nRow;
        }
        if (nCol > this.ColumnCount) {
            this.ColumnCount = nCol;
        }
        while (pCur != null && (pCur.row < nRow || pCur.row == nRow && pCur.col < nCol)) {
            pPre = pCur;
            pCur = pCur.next;
        }
        if (pCur != null && pCur.row == nRow && pCur.col == nCol) {
            pCur.Content = content;
        } else {
            ChainItem pNew = new ChainItem();
            pNew.col = nCol;
            pNew.row = nRow;
            pNew.Content = content;
            pNew.next = pCur;
            if (pPre == null) {
                this.pHead = pNew;
            } else {
                pPre.next = pNew;
            }
        }
    }
}

