/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.dynamicarray;

import com.hankcs.hanlp.collection.dynamicarray.ChainItem;
import java.util.ArrayList;
import java.util.List;

public abstract class DynamicArray<T> {
    protected ChainItem<T> pHead = null;
    public int ColumnCount = 0;
    public int RowCount = 0;

    public int ItemCount() {
        ChainItem<T> pCur = this.pHead;
        int nCount = 0;
        while (pCur != null) {
            ++nCount;
            pCur = pCur.next;
        }
        return nCount;
    }

    public ChainItem<T> GetElement(int nRow, int nCol) {
        ChainItem<T> pCur = this.pHead;
        while (pCur != null && (pCur.col != nCol || pCur.row != nRow)) {
            pCur = pCur.next;
        }
        return pCur;
    }

    public abstract void SetElement(int var1, int var2, T var3);

    public ChainItem<T> GetHead() {
        return this.pHead;
    }

    public int GetTail(ChainItem<T> pTailRet) {
        ChainItem<T> pCur = this.pHead;
        ChainItem<T> pPrev = null;
        int nCount = 0;
        while (pCur != null) {
            ++nCount;
            pPrev = pCur;
            pCur = pCur.next;
        }
        pTailRet.copy(pPrev);
        return nCount;
    }

    public void SetEmpty() {
        this.pHead = null;
        this.ColumnCount = 0;
        this.RowCount = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ChainItem<T> pCur = this.pHead;
        while (pCur != null) {
            sb.append(String.format("row:%d,  col:%d,  ", pCur.row, pCur.col));
            sb.append(pCur.Content);
            sb.append("\r\n");
            pCur = pCur.next;
        }
        return sb.toString();
    }

    public List<ChainItem<T>> ToListItems() {
        ArrayList<ChainItem<T>> result = new ArrayList<ChainItem<T>>();
        ChainItem<T> pCur = this.pHead;
        while (pCur != null) {
            result.add(pCur);
            pCur = pCur.next;
        }
        return result;
    }
}

