/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.BurpUpstreamDownloader;
import burp.HttpUtil;
import burp.IBurpExtender;
import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IRequestInfo;
import burp.IResponseInfo;
import burp.IScanIssue;
import burp.IScannerCheck;
import burp.IScannerInsertionPoint;
import burp.vuln.VulnerableLibraryIssue;
import burp.vuln.VulnerableLibraryIssueBuilder;
import com.esotericsoftware.minlog.Log;
import com.h3xstream.retirejs.repo.ScannerFacade;
import com.h3xstream.retirejs.repo.VulnerabilitiesRepository;
import com.h3xstream.retirejs.repo.VulnerabilitiesRepositoryLoader;
import com.h3xstream.retirejs.repo.dl.Downloader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class BurpExtender
implements IBurpExtender,
IScannerCheck {
    private IBurpExtenderCallbacks callbacks;
    private IExtensionHelpers helpers;
    private static BurpExtender extender;

    public static BurpExtender getInstance() {
        return extender;
    }

    public IExtensionHelpers getHelpers() {
        return this.callbacks.getHelpers();
    }

    public void registerExtenderCallbacks(final IBurpExtenderCallbacks callbacks) {
        this.callbacks = callbacks;
        extender = this;
        this.helpers = callbacks.getHelpers();
        this.callbacks.setExtensionName("Retire.js");
        PrintWriter stdout = new PrintWriter(callbacks.getStdout(), true);
        stdout.println("== Retire.js plugin ==");
        stdout.println("Passive scan rules to detect vulnerable Javascript libraries");
        stdout.println(" - Github : https://github.com/h3xstream/burp-retire-js");
        stdout.println("");
        stdout.println("== License ==");
        stdout.println("Retire.js repository is release under Apache License v2.");
        stdout.println("Retire.js Burp plugin is release under LGPL.");
        stdout.println("");
        Log.setLogger((Log.Logger)new Log.Logger(){

            protected void print(String message) {
                try {
                    if (message.contains("ERROR:")) {
                        callbacks.issueAlert(message);
                    }
                    callbacks.getStdout().write(message.getBytes());
                    callbacks.getStdout().write(10);
                }
                catch (IOException e) {
                    System.err.println("Error while printing the log : " + e.getMessage());
                }
            }
        });
        Log.INFO();
        try {
            ScannerFacade.loadInstance((VulnerabilitiesRepository)new VulnerabilitiesRepositoryLoader().load("https://raw.githubusercontent.com/Retirejs/retire.js/master/repository/jsrepository.json", (Downloader)new BurpUpstreamDownloader(this.callbacks)));
        }
        catch (IOException e) {
            Log.error((String)"ERROR: Problem occurs while preloading the RetireJS vulnerabilities", (Throwable)e);
        }
        callbacks.registerScannerCheck((IScannerCheck)this);
    }

    public List<IScanIssue> doPassiveScan(IHttpRequestResponse requestResponse) {
        List<IScanIssue> issues = new ArrayList<IScanIssue>();
        byte[] respBytes = requestResponse.getResponse();
        IResponseInfo responseInfo = this.helpers.analyzeResponse(respBytes);
        IRequestInfo requestInfo = this.helpers.analyzeRequest(requestResponse.getHttpService(), requestResponse.getRequest());
        String path = HttpUtil.getPathRequested(requestInfo);
        String contentType = HttpUtil.getContentType(responseInfo);
        try {
            boolean jsContentType = contentType != null ? contentType.indexOf("javascript") != -1 : false;
            int bodyOffset = responseInfo.getBodyOffset();
            if (jsContentType || path.endsWith(".js")) {
                Log.debug((String)("Analyzing " + path + " (body=" + (respBytes.length - bodyOffset) + " bytes)"));
                issues = this.scanJavaScript(respBytes, bodyOffset, path, requestResponse, requestInfo);
            } else if (contentType.indexOf("html") != -1 || path.endsWith(".htm") || path.endsWith(".html") || path.endsWith(".aspx") || path.endsWith(".asp") || path.endsWith(".php") || path.endsWith(".jsp")) {
                issues = this.scanHtmlPage(respBytes, bodyOffset, path, requestResponse, requestInfo);
            }
        }
        catch (Exception e) {
            Log.error((String)("Exception while scanning the script '" + path + "' (" + e.getClass().getName() + ": " + e.getMessage() + ")"));
        }
        return issues;
    }

    public List<IScanIssue> doActiveScan(IHttpRequestResponse baseRequestResponse, IScannerInsertionPoint insertionPoint) {
        return new ArrayList<IScanIssue>();
    }

    public int consolidateDuplicateIssues(IScanIssue existingIssue, IScanIssue newIssue) {
        boolean bothRetireJsIssue;
        boolean bl = bothRetireJsIssue = existingIssue instanceof VulnerableLibraryIssue && newIssue instanceof VulnerableLibraryIssue;
        if (bothRetireJsIssue) {
            VulnerableLibraryIssue issue1 = (VulnerableLibraryIssue)existingIssue;
            VulnerableLibraryIssue issue2 = (VulnerableLibraryIssue)newIssue;
            return issue1.equals(issue2) ? -1 : 0;
        }
        return -1;
    }

    private List<IScanIssue> scanJavaScript(byte[] respBytes, int offset, String scriptName, IHttpRequestResponse resp, IRequestInfo requestInfo) throws IOException {
        List res = ScannerFacade.getInstance().scanScript(scriptName, respBytes, offset);
        Log.debug((String)String.format("%d vulnerability(ies) for the script '%s'.", res.size(), scriptName));
        if (res.size() > 0) {
            return VulnerableLibraryIssueBuilder.convert(res, resp.getHttpService(), resp, requestInfo);
        }
        return new ArrayList<IScanIssue>();
    }

    private List<IScanIssue> scanHtmlPage(byte[] respBytes, int offset, String scriptName, IHttpRequestResponse resp, IRequestInfo requestInfo) throws IOException {
        List res = ScannerFacade.getInstance().scanHtml(respBytes, offset);
        Log.debug((String)String.format("%d vulnerability(ies) for the HTML page '%s'.", res.size(), scriptName));
        if (res.size() > 0) {
            return VulnerableLibraryIssueBuilder.convert(res, resp.getHttpService(), resp, requestInfo);
        }
        return new ArrayList<IScanIssue>();
    }
}

