/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.spring;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericSignatureParser;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class SignatureParserWithGeneric {
    private final List<String> argumentsTypes;
    private final String returnType;

    public SignatureParserWithGeneric(String signature) {
        GenericSignatureParser delegate = new GenericSignatureParser(signature);
        ArrayList arguments = new ArrayList();
        delegate.parameterSignatureIterator().forEachRemaining(arguments::add);
        this.argumentsTypes = Collections.unmodifiableList(arguments);
        this.returnType = delegate.getReturnTypeSignature();
    }

    public List<JavaClass[]> getArgumentsClasses() {
        ArrayList<JavaClass[]> types = new ArrayList<JavaClass[]>();
        for (String argumentType : this.argumentsTypes) {
            if (argumentType.equals("")) continue;
            types.add(this.typeToJavaClass(argumentType));
        }
        return types;
    }

    public JavaClass[] getReturnClasses() {
        return this.typeToJavaClass(this.returnType);
    }

    private JavaClass[] typeToJavaClass(String signature) {
        if ("V".equals(signature)) {
            return new JavaClass[0];
        }
        Type type = GenericUtilities.getType((String)signature);
        List<JavaClass> types = this.typeToJavaClass(type);
        return types.toArray(new JavaClass[types.size()]);
    }

    private List<JavaClass> typeToJavaClass(Type type) {
        ArrayList<JavaClass> types;
        block7: {
            block6: {
                types = new ArrayList<JavaClass>();
                if (type instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)type;
                    return this.typeToJavaClass(arrayType.getBasicType());
                }
                if (!(type instanceof GenericObjectType)) break block6;
                GenericObjectType genericObjectType = (GenericObjectType)type;
                try {
                    types.add(Repository.lookupClass((String)genericObjectType.getClassName()));
                }
                catch (ClassNotFoundException e) {
                    AnalysisContext.reportMissingClass((ClassNotFoundException)e);
                }
                if (genericObjectType.getParameters() == null) break block7;
                for (Type parameterType : genericObjectType.getParameters()) {
                    types.addAll(this.typeToJavaClass(parameterType));
                }
                break block7;
            }
            if (!(type instanceof ObjectType)) break block7;
            ObjectType objectType = (ObjectType)type;
            try {
                types.add(Repository.lookupClass((String)objectType.getClassName()));
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass((ClassNotFoundException)e);
            }
        }
        return types;
    }
}

