/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.jsp;

import com.h3xstream.findsecbugs.common.ByteCode;
import com.h3xstream.findsecbugs.common.JspUtils;
import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;

public class JstlOutDetector
implements Detector {
    private static final boolean DEBUG = false;
    private static final String JSP_JSTL_OUT = "JSP_JSTL_OUT";
    private static final InvokeMatcherBuilder OUT_TAG_ESCAPE_XML = InstructionDSL.invokeInstruction().atClass("org.apache.taglibs.standard.tag.rt.core.OutTag", "org.apache.taglibs.standard.tag.el.core.OutTag", "com.caucho.jstl.el.CoreOutTag", "com.caucho.jstl.rt.OutTag", "org.apache.taglibs.standard.tag.compat.core.OutTag", "org.appfuse.webapp.taglib.OutTag").atMethod("setEscapeXml").withArgs("(Z)V", "(Ljava/lang/String;)V");
    private final BugReporter bugReporter;

    public JstlOutDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        try {
            if (!this.isHttpServletSubtype(javaClass)) {
                return;
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)e);
        }
        for (Method m : javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException cFGBuilderException) {
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
    }

    private boolean isHttpServletSubtype(JavaClass javaClass) throws ClassNotFoundException {
        return Hierarchy.isSubtype((String)javaClass.getClassName(), (String)"javax.servlet.http.HttpServlet") || Hierarchy.isSubtype((String)javaClass.getClassName(), (String)"jakarta.servlet.http.HttpServlet");
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        JavaClass clz;
        boolean escapeXmlSetToFalse = false;
        boolean escapeXmlValueUnknown = false;
        Location locationWeakness = null;
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        LinkedList<Instruction> instructionVisited = new LinkedList<Instruction>();
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            InvokeInstruction invoke;
            Location location = (Location)i.next();
            Instruction inst = location.getHandle().getInstruction();
            instructionVisited.add(inst);
            if (!(inst instanceof InvokeInstruction) || !OUT_TAG_ESCAPE_XML.matches((Instruction)(invoke = (InvokeInstruction)inst), cpg)) continue;
            Integer booleanValue = ByteCode.getConstantInt(location.getHandle().getPrev());
            if (booleanValue != null && booleanValue == 0) {
                escapeXmlSetToFalse = true;
                locationWeakness = location;
                continue;
            }
            String stringValue = JspUtils.getContanstBooleanAsString(instructionVisited, cpg);
            if (stringValue != null && stringValue.equals("false")) {
                escapeXmlSetToFalse = true;
                locationWeakness = location;
            }
            if (booleanValue != null || stringValue != null) continue;
            escapeXmlValueUnknown = true;
            locationWeakness = location;
        }
        if (escapeXmlSetToFalse) {
            clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, JSP_JSTL_OUT, 2).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, locationWeakness));
        } else if (escapeXmlValueUnknown) {
            clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, JSP_JSTL_OUT, 3).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, locationWeakness));
        }
    }

    public void report() {
    }
}

