/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs;

import com.h3xstream.findsecbugs.RegexRedosAnalyzer;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

public class RedosAnnotationDetector
implements Detector {
    private static final String REDOS_TYPE = "REDOS";
    private static final String JAVAX_REGEX_ANNOTATION_TYPES = "Ljavax/validation/constraints/Pattern;";
    private static final String JAKARTA_REGEX_ANNOTATION_TYPES = "Ljakarta/validation/constraints/Pattern;";
    private BugReporter bugReporter;

    public RedosAnnotationDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        block0: for (Field f : javaClass.getFields()) {
            for (AnnotationEntry ae : f.getAnnotationEntries()) {
                ElementValuePair[] values;
                if (!this.isRegexAnnotation(ae)) continue;
                for (ElementValuePair valuePair : values = ae.getElementValuePairs()) {
                    if (!"regexp".equals(valuePair.getNameString())) continue;
                    String regex = valuePair.getValue().stringifyValue();
                    RegexRedosAnalyzer analyzer = new RegexRedosAnalyzer();
                    analyzer.analyseRegexString(regex);
                    if (!analyzer.isVulnerable()) continue;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, REDOS_TYPE, 3).addClass(javaClass).addField(javaClass.getClassName(), f.getName(), f.getSignature(), false));
                }
                continue block0;
            }
        }
    }

    private boolean isRegexAnnotation(AnnotationEntry ae) {
        return JAVAX_REGEX_ANNOTATION_TYPES.equals(ae.getAnnotationType()) || JAKARTA_REGEX_ANNOTATION_TYPES.equals(ae.getAnnotationType());
    }

    public void report() {
    }
}

