/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectOutputStream;
import org.h2.store.fs.FileObjectSplit;
import org.h2.store.fs.FileSystem;
import org.h2.store.fs.FileSystemWrapper;
import org.h2.util.New;

public class FileSystemSplit
extends FileSystemWrapper {
    public static final String PREFIX = "split:";
    private static final String PART_SUFFIX = ".part";
    private long defaultMaxSize = 1L << (int)SysProperties.SPLIT_FILE_SIZE_SHIFT;

    public boolean setReadOnly(String string) {
        String string2;
        string = this.unwrap(string);
        boolean bl = false;
        int n = 0;
        while (this.getFileSystem(string2 = FileSystemSplit.getFileName(string, n)).exists(string2)) {
            bl = this.getFileSystem(string2).setReadOnly(string2);
            ++n;
        }
        return bl;
    }

    public void copy(String string, String string2) {
        String string3;
        string = this.unwrap(string);
        string2 = this.unwrap(string2);
        this.getFileSystem(string).copy(string, string2);
        int n = 1;
        while (this.getFileSystem(string3 = FileSystemSplit.getFileName(string, n)).exists(string3)) {
            String string4 = FileSystemSplit.getFileName(string2, n);
            this.getFileSystem(string3).copy(string3, string4);
            ++n;
        }
    }

    public void delete(String string) {
        string = this.unwrap(string);
        int n = 0;
        while (true) {
            String string2 = FileSystemSplit.getFileName(string, n);
            if (!this.getFileSystem(string).exists(string2)) break;
            this.getFileSystem(string).delete(string2);
            ++n;
        }
    }

    public long getLastModified(String string) {
        string = this.unwrap(string);
        long l = 0L;
        int n = 0;
        while (true) {
            String string2 = FileSystemSplit.getFileName(string, n);
            if (!this.getFileSystem(string).exists(string2)) break;
            long l2 = this.getFileSystem(string).getLastModified(string);
            l = Math.max(l, l2);
            ++n;
        }
        return l;
    }

    public long length(String string) {
        string = this.unwrap(string);
        long l = 0L;
        int n = 0;
        while (true) {
            String string2 = FileSystemSplit.getFileName(string, n);
            if (!this.getFileSystem(string).exists(string2)) break;
            l += this.getFileSystem(string).length(string2);
            ++n;
        }
        return l;
    }

    public String[] listFiles(String string) {
        String[] stringArray = super.listFiles(string);
        ArrayList<String> arrayList = New.arrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.endsWith(PART_SUFFIX)) continue;
            arrayList.add(string2);
        }
        if (arrayList.size() != stringArray.length) {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public InputStream openFileInputStream(String string) throws IOException {
        String string2;
        string = this.unwrap(string);
        InputStream inputStream = this.getFileSystem(string).openFileInputStream(string);
        int n = 1;
        while (this.getFileSystem(string2 = FileSystemSplit.getFileName(string, n)).exists(string2)) {
            InputStream inputStream2 = this.getFileSystem(string2).openFileInputStream(string2);
            inputStream = new SequenceInputStream(inputStream, inputStream2);
            ++n;
        }
        return inputStream;
    }

    public FileObject openFileObject(String string, String string2) throws IOException {
        long l;
        string = this.unwrap(string);
        ArrayList<FileObject> arrayList = New.arrayList();
        FileObject fileObject = this.getFileSystem(string).openFileObject(string, string2);
        arrayList.add(fileObject);
        int n = 1;
        while (true) {
            String string3 = FileSystemSplit.getFileName(string, n);
            if (!this.getFileSystem(string).exists(string3)) break;
            fileObject = this.getFileSystem(string3).openFileObject(string3, string2);
            arrayList.add(fileObject);
            ++n;
        }
        FileObject[] fileObjectArray = new FileObject[arrayList.size()];
        arrayList.toArray(fileObjectArray);
        long l2 = l = fileObjectArray[0].length();
        if (fileObjectArray.length == 1) {
            if (l < this.defaultMaxSize) {
                l = this.defaultMaxSize;
            }
        } else {
            if (l == 0L) {
                this.closeAndThrow(fileObjectArray, fileObjectArray[0], l);
            }
            for (int i = 1; i < fileObjectArray.length - 1; ++i) {
                fileObject = fileObjectArray[i];
                long l3 = fileObject.length();
                l2 += l3;
                if (l3 == l) continue;
                this.closeAndThrow(fileObjectArray, fileObject, l);
            }
            fileObject = fileObjectArray[fileObjectArray.length - 1];
            long l4 = fileObject.length();
            l2 += l4;
            if (l4 > l) {
                this.closeAndThrow(fileObjectArray, fileObject, l);
            }
        }
        FileObjectSplit fileObjectSplit = new FileObjectSplit(string, string2, fileObjectArray, l2, l);
        return fileObjectSplit;
    }

    private void closeAndThrow(FileObject[] fileObjectArray, FileObject fileObject, long l) throws IOException {
        String string = "Expected file length: " + l + " got: " + fileObject.length() + " for " + fileObject.getName();
        for (FileObject fileObject2 : fileObjectArray) {
            fileObject2.close();
        }
        throw new IOException(string);
    }

    public OutputStream openFileOutputStream(String string, boolean bl) {
        try {
            return new FileObjectOutputStream(this.openFileObject(string, "rw"), bl);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string);
        }
    }

    public void rename(String string, String string2) {
        String string3;
        string = this.unwrap(string);
        string2 = this.unwrap(string2);
        int n = 0;
        while (this.getFileSystem(string3 = FileSystemSplit.getFileName(string, n)).exists(string3)) {
            String string4 = FileSystemSplit.getFileName(string2, n);
            this.getFileSystem(string4).rename(string3, string4);
            ++n;
        }
    }

    public boolean tryDelete(String string) {
        string = this.unwrap(string);
        int n = 0;
        while (true) {
            String string2 = FileSystemSplit.getFileName(string, n);
            if (!this.getFileSystem(string).exists(string2)) break;
            boolean bl = this.getFileSystem(string).tryDelete(string2);
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String unwrap(String string) {
        if (!string.startsWith(PREFIX)) {
            DbException.throwInternalError(string + " doesn't start with " + PREFIX);
        }
        if ((string = string.substring(PREFIX.length())).length() > 0 && Character.isDigit(string.charAt(0))) {
            int n = string.indexOf(58);
            String string2 = string.substring(0, n);
            try {
                this.defaultMaxSize = 1L << Integer.decode(string2);
                string = string.substring(n + 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string;
    }

    static String getFileName(String string, int n) {
        if (n > 0) {
            string = string + "." + n + PART_SUFFIX;
        }
        return string;
    }

    private FileSystem getFileSystem(String string) {
        return FileSystem.getInstance(string);
    }

    protected String getPrefix() {
        return PREFIX;
    }

    static {
        FileSystem.register(new FileSystemSplit());
    }
}

