/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.h2.util.StringUtils;

public class Profiler
implements Runnable {
    private static Instrumentation instrumentation;
    private static final int MAX_ELEMENTS = 1000;
    public int interval = 10;
    public int depth = 32;
    public boolean paused;
    private String[] ignoreLines = StringUtils.arraySplit("", ',', true);
    private String[] ignoreThreads = StringUtils.arraySplit("java.lang.Thread.dumpThreads,java.net.PlainSocketImpl.socketAccept,java.net.SocketInputStream.socketRead0,java.net.SocketOutputStream.socketWrite0,java.lang.UNIXProcess.waitForProcessExit,java.lang.Object.wait,java.lang.Thread.sleep,sun.awt.windows.WToolkit.eventLoop,sun.misc.Unsafe.park,dalvik.system.VMStack.getThreadStackTrace,dalvik.system.NativeStart.run", ',', true);
    private volatile boolean stop;
    private HashMap<String, Integer> counts = new HashMap();
    private int minCount = 1;
    private int total;
    private Thread thread;
    private long time;

    public static void premain(String string, Instrumentation instrumentation) {
        Profiler.instrumentation = instrumentation;
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public void startCollecting() {
        this.thread = new Thread(this);
        this.thread.setName("Profiler");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stopCollecting() {
        this.stop = true;
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
    }

    public void run() {
        this.time = System.currentTimeMillis();
        while (!this.stop) {
            try {
                this.tick();
            }
            catch (Throwable throwable) {
                // empty catch block
                break;
            }
        }
        this.time = System.currentTimeMillis() - this.time;
    }

    private void tick() {
        if (this.interval > 0) {
            if (this.paused) {
                return;
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            StackTraceElement[] stackTraceElementArray;
            Thread thread = entry.getKey();
            if (thread.getState() != Thread.State.RUNNABLE || (stackTraceElementArray = entry.getValue()).length == 0) continue;
            boolean bl = false;
            for (String string : this.ignoreThreads) {
                if (string.length() <= 0 || !stackTraceElementArray[0].toString().startsWith(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            StringBuilder stringBuilder = new StringBuilder();
            String string = null;
            int n = 0;
            for (int i = 0; i < stackTraceElementArray.length && n < this.depth; ++i) {
                String string2 = stackTraceElementArray[i].toString();
                bl = false;
                for (String string3 : this.ignoreLines) {
                    if (string3.length() <= 0 || !string2.startsWith(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl || string2.equals(string)) continue;
                string = string2;
                stringBuilder.append("at ").append(string2).append('\n');
                ++n;
            }
            if (stringBuilder.length() <= 0) continue;
            this.increment(stringBuilder.toString());
        }
    }

    private void increment(String string) {
        ++this.total;
        Integer n = this.counts.get(string);
        if (n == null) {
            this.counts.put(string, 1);
        } else {
            this.counts.put(string, n + 1);
        }
        if (this.counts.size() > 1000) {
            Iterator<Map.Entry<String, Integer>> iterator = this.counts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Integer> entry = iterator.next();
                if (entry.getValue() > this.minCount) continue;
                iterator.remove();
            }
            if (this.counts.size() > 1000) {
                ++this.minCount;
            }
        }
    }

    public String getTop(int n) {
        this.stopCollecting();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Profiler: top ").append(n).append(" stack trace(s) of ").append(this.time).append(" ms [build-").append(144).append("]:\n");
        if (this.counts.size() == 0) {
            stringBuilder.append("(none)");
        }
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4 = 0;
            Map.Entry<String, Integer> entry = null;
            for (Map.Entry<String, Integer> entry2 : this.counts.entrySet()) {
                if (entry2.getValue() <= n4) continue;
                entry = entry2;
                n4 = entry2.getValue();
            }
            if (entry == null) break;
            this.counts.remove(entry.getKey());
            if (++n2 >= n) {
                if (entry.getValue() < n3) break;
                n3 = entry.getValue();
            }
            stringBuilder.append(entry.getValue()).append('/').append(this.total).append('\n').append(entry.getKey());
        }
        stringBuilder.append('.');
        return stringBuilder.toString();
    }
}

