/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.CRC32;
import org.h2.command.Parser;
import org.h2.engine.MetaRecord;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRow;
import org.h2.security.SHA256;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.PageFreeList;
import org.h2.store.PageLog;
import org.h2.util.BitField;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.IntArray;
import org.h2.util.MathUtils;
import org.h2.util.MemoryUtils;
import org.h2.util.New;
import org.h2.util.ObjectArray;
import org.h2.util.RandomUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.util.Tool;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueLob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recover
extends Tool
implements DataHandler {
    private String databaseName;
    private int block;
    private int blockCount;
    private int storageId;
    private String storageName;
    private int recordLength;
    private int valueId;
    private boolean trace;
    private boolean lobFilesInDirectories;
    private ObjectArray<MetaRecord> schema;
    private HashSet<Integer> objectIdSet;
    private HashMap<Integer, String> tableMap;
    private boolean remove;

    public static void main(String[] stringArray) throws SQLException {
        new Recover().run(stringArray);
    }

    @Override
    public void run(String[] stringArray) throws SQLException {
        String string = ".";
        String string2 = null;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if ("-dir".equals(string3)) {
                string = stringArray[++i];
                continue;
            }
            if ("-db".equals(string3)) {
                string2 = stringArray[++i];
                continue;
            }
            if ("-removePassword".equals(string3)) {
                this.remove = true;
                continue;
            }
            if ("-trace".equals(string3)) {
                this.trace = true;
                continue;
            }
            if (string3.equals("-help") || string3.equals("-?")) {
                this.showUsage();
                return;
            }
            this.throwUnsupportedOption(string3);
        }
        if (this.remove) {
            this.removePassword(string, string2);
        }
        this.process(string, string2);
    }

    public static Reader readClob(String string) throws IOException {
        return new BufferedReader(new InputStreamReader(Recover.readBlob(string)));
    }

    public static InputStream readBlob(String string) throws IOException {
        return new BufferedInputStream(FileUtils.openFileInputStream(string));
    }

    private void removePassword(String string, String string2) throws SQLException {
        ArrayList<String> arrayList = FileLister.getDatabaseFiles(string, string2, true);
        for (String string3 : arrayList) {
            if (!string3.endsWith(".data.db")) continue;
            this.removePassword(string3);
        }
    }

    private void trace(String string) {
        if (this.trace) {
            this.out.println(string);
        }
    }

    private void traceError(String string, Throwable throwable) {
        this.out.println(string + ": " + throwable.toString());
        if (this.trace) {
            throwable.printStackTrace(this.out);
        }
    }

    private void removePassword(String string) throws SQLException {
        if (string.endsWith(".h2.db")) {
            this.remove = true;
            this.dumpPageStore(string);
            return;
        }
        this.setDatabaseName(string.substring(string.length() - ".data.db".length()));
        FileStore fileStore = FileStore.open(null, string, "rw");
        long l = fileStore.length();
        int n = 48;
        int n2 = 128;
        int n3 = (int)(l / (long)n2);
        this.blockCount = 1;
        for (int i = 0; i < n3; i += this.blockCount) {
            Value[] valueArray;
            fileStore.seek((long)n + (long)i * (long)n2);
            byte[] byArray = new byte[n2];
            DataPage dataPage = DataPage.create((DataHandler)this, byArray);
            long l2 = fileStore.getFilePointer();
            fileStore.readFully(byArray, 0, n2);
            this.blockCount = dataPage.readInt();
            this.setStorage(-1);
            this.recordLength = -1;
            this.valueId = -1;
            if (this.blockCount == 0) {
                this.blockCount = 1;
                continue;
            }
            if (this.blockCount < 0) {
                this.blockCount = 1;
                continue;
            }
            try {
                dataPage.checkCapacity(this.blockCount * n2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.blockCount = 1;
                continue;
            }
            if (this.blockCount > 1) {
                fileStore.readFully(dataPage.getBytes(), n2, this.blockCount * n2 - n2);
            }
            try {
                dataPage.check(this.blockCount * n2);
            }
            catch (SQLException sQLException) {
                this.blockCount = 1;
                continue;
            }
            this.setStorage(dataPage.readInt());
            if (this.storageId != 0) continue;
            this.recordLength = dataPage.readInt();
            if (this.recordLength <= 0) continue;
            try {
                valueArray = new Value[this.recordLength];
            }
            catch (Throwable throwable) {
                continue;
            }
            this.valueId = 0;
            while (this.valueId < this.recordLength) {
                try {
                    valueArray[this.valueId] = dataPage.readValue();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++this.valueId;
            }
            if (this.storageId != 0) continue;
            try {
                int n4;
                String string2 = valueArray[3].getString();
                if (!string2.startsWith("CREATE USER ") || (n4 = string2.indexOf("SALT")) < 0) continue;
                String string3 = string2.substring("CREATE USER ".length(), n4 - 1);
                if (string3.startsWith("\"")) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                SHA256 sHA256 = new SHA256();
                byte[] byArray2 = sHA256.getKeyPasswordHash(string3, "".toCharArray());
                byte[] byArray3 = RandomUtils.getSecureBytes(8);
                byte[] byArray4 = sHA256.getHashWithSalt(byArray2, byArray3);
                boolean bl = string2.indexOf("ADMIN") >= 0;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("CREATE USER ").append(Parser.quoteIdentifier(string3)).append(" SALT '").append(ByteUtils.convertBytesToString(byArray3)).append("' HASH '").append(ByteUtils.convertBytesToString(byArray4)).append('\'');
                if (bl) {
                    stringBuilder.append(" ADMIN");
                }
                byte[] byArray5 = stringBuilder.toString().getBytes();
                int n5 = ByteUtils.indexOf(dataPage.getBytes(), "CREATE USER ".getBytes(), 0);
                System.arraycopy(byArray5, 0, dataPage.getBytes(), n5, byArray5.length);
                dataPage.fill(this.blockCount * n2);
                dataPage.updateChecksum();
                fileStore.seek(l2);
                fileStore.write(dataPage.getBytes(), 0, dataPage.length());
                if (!this.trace) break;
                this.out.println("User: " + string3);
                break;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(this.out);
            }
        }
        this.closeSilently(fileStore);
    }

    public static void execute(String string, String string2) throws SQLException {
        new Recover().process(string, string2);
    }

    private void process(String string, String string2) throws SQLException {
        ArrayList<String> arrayList = FileLister.getDatabaseFiles(string, string2, true);
        if (arrayList.size() == 0) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        for (String string3 : arrayList) {
            if (string3.endsWith(".data.db")) {
                this.dumpData(string3);
                continue;
            }
            if (string3.endsWith(".h2.db")) {
                this.dumpPageStore(string3);
                continue;
            }
            if (string3.endsWith(".index.db")) {
                this.dumpIndex(string3);
                continue;
            }
            if (string3.endsWith(".log.db")) {
                this.dumpLog(string3);
                continue;
            }
            if (!string3.endsWith(".lob.db")) continue;
            this.dumpLob(string3, true);
            this.dumpLob(string3, false);
        }
    }

    private PrintWriter getWriter(String string, String string2) throws SQLException {
        string = string.substring(0, string.length() - 3);
        String string3 = string + string2;
        this.trace("Created file: " + string3);
        return new PrintWriter(IOUtils.getWriter(FileUtils.openFileOutputStream(string3, false)));
    }

    private void writeDataError(PrintWriter printWriter, String string, byte[] byArray, int n) {
        int n2;
        int n3;
        printWriter.println("-- ERROR: " + string + " block: " + this.block + " blockCount: " + this.blockCount + " storageId: " + this.storageId + " recordLength: " + this.recordLength + " valueId: " + this.valueId);
        StringBuilder stringBuilder = new StringBuilder();
        for (n3 = 0; n3 < n * 128; ++n3) {
            n2 = byArray[n3] & 0xFF;
            if (n2 >= 32 && n2 < 128) {
                stringBuilder.append((char)n2);
                continue;
            }
            stringBuilder.append('?');
        }
        printWriter.println("-- dump: " + stringBuilder.toString());
        stringBuilder = new StringBuilder();
        for (n3 = 0; n3 < n * 128; ++n3) {
            n2 = byArray[n3] & 0xFF;
            stringBuilder.append(' ');
            if (n2 < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n2));
        }
        printWriter.println("-- dump: " + stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLob(String string, boolean bl) {
        OutputStream outputStream = null;
        FileStore fileStore = null;
        int n = 0;
        String string2 = string + (bl ? ".comp" : "") + ".txt";
        BufferedInputStream bufferedInputStream = null;
        try {
            int n2;
            outputStream = FileUtils.openFileOutputStream(string2, false);
            fileStore = FileStore.open(null, string, "r");
            fileStore.init();
            bufferedInputStream = new BufferedInputStream(new FileStoreInputStream(fileStore, this, bl, false));
            byte[] byArray = new byte[4096];
            while ((n2 = ((InputStream)bufferedInputStream).read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n2);
                n += n2;
            }
            outputStream.close();
        }
        catch (Throwable throwable) {
            try {
                if (this.trace) {
                    this.traceError(string, throwable);
                }
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                IOUtils.closeSilently(outputStream);
                IOUtils.closeSilently(bufferedInputStream);
                this.closeSilently(fileStore);
            }
        }
        IOUtils.closeSilently(outputStream);
        IOUtils.closeSilently(bufferedInputStream);
        this.closeSilently(fileStore);
        if (n == 0) {
            try {
                FileUtils.delete(string2);
            }
            catch (SQLException sQLException) {
                this.traceError(string2, sQLException);
            }
        }
    }

    private void writeLogRecord(PrintWriter printWriter, DataPage dataPage) {
        this.recordLength = dataPage.readInt();
        if (this.recordLength <= 0) {
            this.writeDataError(printWriter, "recordLength<0", dataPage.getBytes(), this.blockCount);
            return;
        }
        try {
            Value[] valueArray = new Value[this.recordLength];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), this.blockCount);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("//     data: ");
        this.valueId = 0;
        while (this.valueId < this.recordLength) {
            try {
                Value value;
                valueArray[this.valueId] = value = dataPage.readValue();
                if (this.valueId > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.getSQL(value));
            }
            catch (Exception exception) {
                if (this.trace) {
                    this.traceError("log data", exception);
                }
                this.writeDataError(printWriter, "exception " + exception, dataPage.getBytes(), this.blockCount);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), this.blockCount);
            }
            ++this.valueId;
        }
        printWriter.println(stringBuilder.toString());
        printWriter.flush();
    }

    private String getSQL(Value value) {
        ValueLob valueLob;
        byte[] byArray;
        if (value instanceof ValueLob && (byArray = (valueLob = (ValueLob)value).getSmall()) == null) {
            String string = valueLob.getFileName();
            if (valueLob.getType() == 15) {
                return "READ_BLOB('" + string + ".txt')";
            }
            return "READ_CLOB('" + string + ".txt')";
        }
        return value.getSQL();
    }

    private void setDatabaseName(String string) {
        this.databaseName = string;
        this.lobFilesInDirectories = FileUtils.exists(this.databaseName + ".lobs.db");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLog(String string) {
        block22: {
            int n;
            DataPage dataPage;
            byte[] byArray;
            int n2;
            int n3;
            int n4;
            long l;
            FileStore fileStore;
            PrintWriter printWriter;
            block21: {
                printWriter = null;
                fileStore = null;
                this.setDatabaseName(string.substring(string.length() - ".log.db".length()));
                printWriter = this.getWriter(string, ".txt");
                fileStore = FileStore.open(null, string, "r");
                l = fileStore.length();
                printWriter.println("// length: " + l);
                n4 = 48;
                n3 = 16;
                n2 = (int)(l / (long)n3);
                byArray = new byte[n3];
                dataPage = DataPage.create((DataHandler)this, byArray);
                dataPage.fill(3 * n3);
                n = dataPage.length();
                dataPage.reset();
                if (l >= (long)(48 + n)) break block21;
                printWriter.println("// empty file");
                IOUtils.closeSilently(printWriter);
                this.closeSilently(fileStore);
                return;
            }
            try {
                int n5;
                fileStore.seek(n4);
                fileStore.readFully(dataPage.getBytes(), 0, n);
                int n6 = dataPage.readInt();
                int n7 = dataPage.readInt();
                int n8 = dataPage.readInt();
                printWriter.println("// id: " + n6);
                printWriter.println("// firstUncommittedPos: " + n7);
                printWriter.println("// firstUnwrittenPos: " + n8);
                int n9 = (int)(l / (long)n3);
                printWriter.println("// max: " + n9);
                block14: while ((long)(n5 = (int)(fileStore.getFilePointer() / (long)n3)) * (long)n3 < l) {
                    byArray = new byte[n3];
                    fileStore.readFully(byArray, 0, n3);
                    dataPage = DataPage.create((DataHandler)this, byArray);
                    n2 = MathUtils.convertLongToInt(Math.abs(dataPage.readInt()));
                    if (n2 > 1) {
                        byte[] byArray2 = MemoryUtils.newBytes(n2 * n3);
                        System.arraycopy(byArray, 0, byArray2, 0, n3);
                        byArray = byArray2;
                        try {
                            fileStore.readFully(byArray, n3, n2 * n3 - n3);
                        }
                        catch (SQLException sQLException) {
                            break;
                        }
                        dataPage = DataPage.create((DataHandler)this, byArray);
                        dataPage.check(n2 * n3);
                    }
                    dataPage.reset();
                    n2 = MathUtils.convertLongToInt(Math.abs(dataPage.readInt()));
                    if (n2 == 0) {
                        printWriter.println("// [" + n5 + "] blocks: " + n2 + " (end)");
                        break;
                    }
                    char c = (char)dataPage.readByte();
                    int n10 = dataPage.readInt();
                    if (c == 'P') {
                        String string2 = dataPage.readString();
                        printWriter.println("//   prepared session: " + n10 + " tx: " + string2);
                        continue;
                    }
                    if (c == 'C') {
                        printWriter.println("//   commit session: " + n10);
                        continue;
                    }
                    int n11 = dataPage.readInt();
                    int n12 = dataPage.readInt();
                    int n13 = dataPage.readInt();
                    if (c != 'T') {
                        dataPage.readDataPageNoSize();
                    }
                    switch (c) {
                        case 'S': {
                            char c2 = (char)dataPage.readByte();
                            int n14 = dataPage.readInt();
                            byte[] byArray3 = MemoryUtils.newBytes(n14);
                            if (n14 > 0) {
                                dataPage.read(byArray3, 0, n14);
                            }
                            printWriter.println("//   summary session: " + n10 + " fileType: " + c2 + " sumLength: " + n14);
                            this.dumpSummary(printWriter, byArray3);
                            continue block14;
                        }
                        case 'T': {
                            printWriter.println("//   truncate session: " + n10 + " storage: " + n11 + " pos: " + n12 + " blockCount: " + n13);
                            continue block14;
                        }
                        case 'I': {
                            printWriter.println("//   insert session: " + n10 + " storage: " + n11 + " pos: " + n12 + " blockCount: " + n13);
                            if (n11 < 0) continue block14;
                            this.writeLogRecord(printWriter, dataPage);
                            continue block14;
                        }
                        case 'D': {
                            printWriter.println("//   delete session: " + n10 + " storage: " + n11 + " pos: " + n12 + " blockCount: " + n13);
                            if (n11 < 0) continue block14;
                            this.writeLogRecord(printWriter, dataPage);
                            continue block14;
                        }
                    }
                    printWriter.println("//   type?: " + c + " session: " + n10 + " storage: " + n11 + " pos: " + n12 + " blockCount: " + n13);
                }
                printWriter.close();
            }
            catch (Throwable throwable) {
                try {
                    this.writeError(printWriter, throwable);
                    break block22;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    IOUtils.closeSilently(printWriter);
                    this.closeSilently(fileStore);
                }
            }
            IOUtils.closeSilently(printWriter);
            this.closeSilently(fileStore);
        }
    }

    private void dumpSummary(PrintWriter printWriter, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            printWriter.println("//     summary is empty");
            return;
        }
        try {
            int n;
            int n2;
            int n3;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n4 = dataInputStream.readInt();
            for (n3 = 0; n3 < n4 / 8; ++n3) {
                n2 = dataInputStream.read();
                if (n3 % 8 == 0) {
                    printWriter.print("//  ");
                }
                printWriter.print(" " + Long.toString(n3 * 8) + ": ");
                for (n = 0; n < 8; ++n) {
                    printWriter.print((n2 & 1) == 1 ? "1" : "0");
                    n2 >>>= 1;
                }
                if (n3 % 8 != 7) continue;
                printWriter.println("");
            }
            printWriter.println("//");
            n3 = dataInputStream.readInt();
            for (n2 = 0; n2 < n3; ++n2) {
                n = dataInputStream.readInt();
                if (n == -1) continue;
                printWriter.println("//     pos: " + n2 * 64 + " storage: " + n);
            }
            while ((n2 = dataInputStream.readInt()) >= 0) {
                n = dataInputStream.readInt();
                printWriter.println("//     storage: " + n2 + " recordCount: " + n);
            }
        }
        catch (Throwable throwable) {
            this.writeError(printWriter, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpIndex(String string) {
        PrintWriter printWriter = null;
        FileStore fileStore = null;
        try {
            this.setDatabaseName(string.substring(string.length() - ".index.db".length()));
            printWriter = this.getWriter(string, ".txt");
            fileStore = FileStore.open(null, string, "r");
            long l = fileStore.length();
            int n = 48;
            int n2 = 128;
            int n3 = (int)(l / (long)n2);
            this.blockCount = 1;
            int[] nArray = new int[n3 / 64];
            this.block = 0;
            while (this.block < n3) {
                block27: {
                    fileStore.seek((long)n + (long)this.block * (long)n2);
                    byte[] byArray = new byte[n2];
                    DataPage dataPage = DataPage.create((DataHandler)this, byArray);
                    fileStore.readFully(byArray, 0, n2);
                    this.blockCount = dataPage.readInt();
                    this.setStorage(-1);
                    this.recordLength = -1;
                    this.valueId = -1;
                    if (this.blockCount == 0) {
                        this.blockCount = 1;
                    } else if (this.blockCount < 0) {
                        this.writeDataError(printWriter, "blockCount<0", dataPage.getBytes(), 1);
                        this.blockCount = 1;
                    } else if ((long)this.blockCount * (long)n2 >= 0x1FFFFFFFL) {
                        this.writeDataError(printWriter, "blockCount=" + this.blockCount, dataPage.getBytes(), 1);
                        this.blockCount = 1;
                    } else {
                        try {
                            dataPage.checkCapacity(this.blockCount * n2);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), 1);
                            this.blockCount = 1;
                            break block27;
                        }
                        if (this.blockCount > 1) {
                            fileStore.readFully(dataPage.getBytes(), n2, this.blockCount * n2 - n2);
                        }
                        try {
                            dataPage.check(this.blockCount * n2);
                        }
                        catch (SQLException sQLException) {
                            this.writeDataError(printWriter, "wrong checksum", dataPage.getBytes(), 1);
                            this.blockCount = 1;
                            break block27;
                        }
                        this.setStorage(dataPage.readInt());
                        if (this.storageId < 0) {
                            this.writeDataError(printWriter, "storageId<0", dataPage.getBytes(), this.blockCount);
                        } else {
                            int n4 = this.block / 64;
                            if (nArray[n4] != 0 && nArray[n4] != this.storageId) {
                                this.writeDataError(printWriter, "double allocation, previous=" + nArray[n4] + " now=" + this.storageId, dataPage.getBytes(), this.blockCount);
                            } else {
                                nArray[n4] = this.storageId;
                            }
                            String string2 = "";
                            int n5 = dataPage.readByte();
                            switch (n5) {
                                case 76: {
                                    boolean bl = dataPage.readByte() == 80;
                                    int n6 = dataPage.readInt();
                                    string2 = "leaf(" + n6 + ")";
                                    if (!bl) break;
                                    string2 = string2 + " pos";
                                    break;
                                }
                                case 78: {
                                    int n7;
                                    int n6 = dataPage.readInt();
                                    string2 = "node ";
                                    for (n7 = 0; n7 < n6; ++n7) {
                                        string2 = string2 + "[" + dataPage.readInt() + "]";
                                    }
                                    break;
                                }
                                case 72: {
                                    int n7 = dataPage.readInt();
                                    string2 = "root [" + n7 + "]";
                                }
                            }
                            printWriter.println("// [" + this.block + "] page: " + n4 + " blocks: " + this.blockCount + " storage: " + this.storageId + " " + string2);
                        }
                    }
                }
                this.block += this.blockCount;
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            try {
                this.writeError(printWriter, throwable);
                throwable.printStackTrace();
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                IOUtils.closeSilently(printWriter);
                this.closeSilently(fileStore);
            }
        }
        IOUtils.closeSilently(printWriter);
        this.closeSilently(fileStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpPageStore(String string) {
        this.setDatabaseName(string.substring(0, string.length() - ".h2.db".length()));
        FileStore fileStore = null;
        PrintWriter printWriter = null;
        int n = 0;
        try {
            int n2;
            int n3;
            long l;
            int n4;
            printWriter = this.getWriter(string, ".sql");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
            this.resetSchema();
            fileStore = FileStore.open(null, string, this.remove ? "rw" : "r");
            long l2 = fileStore.length();
            try {
                fileStore.init();
            }
            catch (Exception exception) {
                this.writeError(printWriter, exception);
            }
            DataPage dataPage = DataPage.create((DataHandler)this, 128);
            fileStore.seek(0L);
            fileStore.readFully(dataPage.getBytes(), 0, 128);
            dataPage.setPos(48);
            int n5 = dataPage.readInt();
            int n6 = dataPage.readByte();
            int n7 = dataPage.readByte();
            printWriter.println("-- pageSize: " + n5 + " writeVersion: " + n6 + " readVersion: " + n7);
            if (n5 < 128 || n5 > 32768) {
                n5 = 1024;
                printWriter.println("-- ERROR: page size; using " + n5);
            }
            int n8 = (int)(l2 / (long)n5);
            dataPage = DataPage.create((DataHandler)this, n5);
            int n9 = 0;
            int n10 = 0;
            for (n4 = 1; n4 != 3; ++n4) {
                dataPage.reset();
                fileStore.seek(n4 * n5);
                fileStore.readFully(dataPage.getBytes(), 0, n5);
                l = dataPage.readLong();
                n3 = dataPage.readInt();
                n2 = dataPage.readInt();
                CRC32 cRC32 = new CRC32();
                cRC32.update(dataPage.getBytes(), 0, dataPage.length());
                long l3 = cRC32.getValue();
                long l4 = dataPage.readLong();
                if (l3 == l4 && n9 == 0) {
                    n9 = n3;
                    n10 = n2;
                }
                printWriter.println("-- head " + n4 + ": writeCounter: " + l + " trunk: " + n3 + "/" + n2 + " crc expected " + l3 + " got " + l4 + " (" + (l3 == l4 ? "ok" : "different") + ")");
            }
            printWriter.println("-- firstTrunkPage: " + n9 + " firstDataPage: " + n10);
            dataPage = DataPage.create((DataHandler)this, n5);
            n4 = 0;
            block22: for (l = 3L; l < (long)n8; ++l) {
                dataPage = DataPage.create((DataHandler)this, n5);
                fileStore.seek(l * (long)n5);
                fileStore.readFully(dataPage.getBytes(), 0, n5);
                n3 = dataPage.readInt();
                n2 = dataPage.readByte();
                switch (n2) {
                    case 0: {
                        if (n3 != 0) {
                            printWriter.println("-- ERROR empty page with parent: " + n3);
                        }
                        ++n;
                        continue block22;
                    }
                    default: {
                        boolean bl = (n2 & 0x10) != 0;
                        switch (n2 &= 0xFFFFFFEF) {
                            case 3: {
                                printWriter.println("-- page " + l + ": data overflow " + (bl ? "(last)" : ""));
                                continue block22;
                            }
                            case 2: {
                                int n11 = dataPage.readShortInt();
                                int n12 = dataPage.readInt();
                                printWriter.println("-- page " + l + ": data node " + (bl ? "(last)" : "") + " entries: " + n11 + " rowCount: " + n12);
                                continue block22;
                            }
                            case 1: {
                                this.setStorage(dataPage.readInt());
                                int n11 = dataPage.readShortInt();
                                printWriter.println("-- page " + l + ": data leaf " + (bl ? "(last)" : "") + " table: " + this.storageId + " entries: " + n11);
                                this.dumpPageDataLeaf(fileStore, n5, printWriter, dataPage, bl, l, n11);
                                continue block22;
                            }
                            case 5: {
                                printWriter.println("-- page " + l + ": btree node" + (bl ? "(last)" : ""));
                                if (!this.trace) continue block22;
                                this.dumpPageBtreeNode(printWriter, dataPage, !bl);
                                continue block22;
                            }
                            case 4: {
                                this.setStorage(dataPage.readInt());
                                int n11 = dataPage.readShortInt();
                                printWriter.println("-- page " + l + ": btree leaf " + (bl ? "(last)" : "") + " table: " + this.storageId + " entries: " + n11);
                                if (!this.trace) continue block22;
                                this.dumpPageBtreeLeaf(printWriter, dataPage, n11, !bl);
                                continue block22;
                            }
                            case 6: {
                                printWriter.println("-- page " + l + ": free list " + (bl ? "(last)" : ""));
                                n4 += this.dumpPageFreeList(printWriter, dataPage, n5, l, n8);
                                continue block22;
                            }
                            case 7: {
                                printWriter.println("-- page " + l + ": log trunk");
                                continue block22;
                            }
                            case 8: {
                                printWriter.println("-- page " + l + ": log data");
                                continue block22;
                            }
                            default: {
                                printWriter.println("-- page " + l + ": ERROR unknown type " + n2);
                            }
                        }
                    }
                }
            }
            printWriter.println("-- page count: " + n8 + " empty: " + n + " free: " + n4);
            this.writeSchema(printWriter);
            try {
                this.dumpPageLogStream(printWriter, fileStore, n9, n10, n5);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            try {
                this.writeError(printWriter, throwable);
            }
            catch (Throwable throwable2) {
                IOUtils.closeSilently(printWriter);
                this.closeSilently(fileStore);
                throw throwable2;
            }
            IOUtils.closeSilently(printWriter);
            this.closeSilently(fileStore);
        }
        IOUtils.closeSilently(printWriter);
        this.closeSilently(fileStore);
    }

    private void dumpPageLogStream(PrintWriter printWriter, FileStore fileStore, int n, int n2, int n3) throws IOException, SQLException {
        int n4;
        Data data = Data.create((DataHandler)this, n3);
        DataInputStream dataInputStream = new DataInputStream(new PageInputStream(printWriter, this, fileStore, n, n2, n3));
        while ((n4 = dataInputStream.read()) >= 0) {
            int n5;
            if (n4 == 1) {
                n5 = dataInputStream.readInt();
                dataInputStream.readFully(new byte[n3]);
                printWriter.println("-- undo page " + n5);
                continue;
            }
            if (n4 == 5 || n4 == 6) {
                n5 = dataInputStream.readInt();
                this.setStorage(dataInputStream.readInt());
                Row row = PageLog.readRow(dataInputStream, data);
                printWriter.println("-- session " + n5 + " table " + this.storageId + " " + (n4 == 5 ? "add" : "remove") + " " + row.toString());
                continue;
            }
            if (n4 == 2) {
                n5 = dataInputStream.readInt();
                printWriter.println("-- commit " + n5);
                continue;
            }
            if (n4 == 4) {
                n5 = dataInputStream.readInt();
                printWriter.println("-- rollback " + n5);
                continue;
            }
            if (n4 == 3) {
                n5 = dataInputStream.readInt();
                int n6 = dataInputStream.readInt();
                byte[] byArray = new byte[n6];
                dataInputStream.readFully(byArray);
                String string = StringUtils.utf8Decode(byArray);
                printWriter.println("-- prepare commit " + n5 + " " + string);
                continue;
            }
            if (n4 == 0) continue;
            if (n4 == 7) {
                printWriter.println("-- checkpoint");
                continue;
            }
            printWriter.println("-- end " + n4);
            break;
        }
    }

    private String setStorage(int n) {
        this.storageId = n;
        this.storageName = "O_" + String.valueOf(n).replace('-', 'M');
        return this.storageName;
    }

    private void dumpPageBtreeNode(PrintWriter printWriter, DataPage dataPage, boolean bl) {
        int n;
        int n2 = dataPage.readShortInt();
        int n3 = dataPage.readInt();
        int[] nArray = new int[n2 + 1];
        int[] nArray2 = new int[n2];
        nArray[n2] = dataPage.readInt();
        for (n = 0; n < n2; ++n) {
            nArray[n] = dataPage.readInt();
            nArray2[n] = dataPage.readInt();
        }
        for (n = 0; n < n2; ++n) {
            Value value;
            int n4 = nArray2[n];
            dataPage.setPos(n4);
            int n5 = dataPage.readInt();
            if (bl) {
                value = ValueInt.get(n5);
            } else {
                try {
                    value = dataPage.readValue();
                }
                catch (Throwable throwable) {
                    this.writeDataError(printWriter, "exception " + throwable, dataPage.getBytes(), this.blockCount);
                    continue;
                }
            }
            printWriter.println("-- [" + n + "] child: " + nArray[n] + " pos: " + n5 + " data: " + value);
        }
        printWriter.println("-- [" + n2 + "] child: " + nArray[n2] + " rowCount: " + n3);
    }

    private int dumpPageFreeList(PrintWriter printWriter, DataPage dataPage, int n, long l, long l2) {
        int n2;
        int n3 = PageFreeList.getPagesAddressed(n);
        BitField bitField = new BitField();
        for (n2 = 0; n2 < n3; n2 += 8) {
            bitField.setByte(n2, dataPage.readByte() & 0xFF);
        }
        n2 = 0;
        long l3 = 0L;
        for (long i = l; l3 < (long)n3 && i < l2; ++l3, ++i) {
            if (l3 == 0L || i % 100L == 0L) {
                if (l3 > 0L) {
                    printWriter.println();
                }
                printWriter.print("-- " + i + " ");
            } else if (i % 20L == 0L) {
                printWriter.print(" - ");
            } else if (i % 10L == 0L) {
                printWriter.print(' ');
            }
            printWriter.print(bitField.get((int)l3) ? (char)'1' : '0');
            if (bitField.get((int)l3)) continue;
            ++n2;
        }
        printWriter.println();
        return n2;
    }

    private void dumpPageBtreeLeaf(PrintWriter printWriter, DataPage dataPage, int n, boolean bl) {
        int n2;
        int[] nArray = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = dataPage.readShortInt();
        }
        for (n2 = 0; n2 < n; ++n2) {
            Value value;
            int n3 = nArray[n2];
            dataPage.setPos(n3);
            int n4 = dataPage.readInt();
            if (bl) {
                value = ValueInt.get(n4);
            } else {
                try {
                    value = dataPage.readValue();
                }
                catch (Throwable throwable) {
                    this.writeDataError(printWriter, "exception " + throwable, dataPage.getBytes(), this.blockCount);
                    continue;
                }
            }
            printWriter.println("-- [" + n2 + "] pos: " + n4 + " data: " + value);
        }
    }

    private void dumpPageDataLeaf(FileStore fileStore, int n, PrintWriter printWriter, DataPage dataPage, boolean bl, long l, int n2) throws SQLException {
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int[] nArray2;
        block9: {
            nArray2 = new int[n2];
            nArray = new int[n2];
            long l2 = 0L;
            if (!bl) {
                l2 = dataPage.readInt();
            }
            for (n5 = 0; n5 < n2; ++n5) {
                nArray2[n5] = dataPage.readInt();
                nArray[n5] = dataPage.readShortInt();
            }
            if (!bl) {
                DataPage dataPage2 = DataPage.create((DataHandler)this, n);
                dataPage.setPos(n);
                while (true) {
                    fileStore.seek((long)n * l2);
                    fileStore.readFully(dataPage2.getBytes(), 0, n);
                    dataPage2.setPos(4);
                    n4 = dataPage2.readByte();
                    if (n4 == 19) {
                        n3 = dataPage2.readShortInt();
                        printWriter.println("-- chain: " + l2 + " type: " + n4 + " size: " + n3);
                        dataPage.write(dataPage2.getBytes(), 7, n3);
                        break block9;
                    }
                    if (n4 != 3) break;
                    l2 = dataPage2.readInt();
                    if (l2 == 0L) {
                        this.writeDataError(printWriter, "next:0", dataPage2.getBytes(), 1);
                        break block9;
                    }
                    n3 = n - 9;
                    printWriter.println("-- chain: " + l2 + " type: " + n4 + " size: " + n3 + " next: " + l2);
                    dataPage.write(dataPage2.getBytes(), 9, n3);
                }
                this.writeDataError(printWriter, "type: " + n4, dataPage2.getBytes(), 1);
            }
        }
        for (n5 = 0; n5 < n2; ++n5) {
            int n6;
            String string;
            n4 = nArray2[n5];
            n3 = nArray[n5];
            printWriter.println("-- [" + n5 + "] storage: " + this.storageId + " key: " + n4 + " off: " + n3);
            dataPage.setPos(n3);
            Value[] valueArray = this.createRecord(printWriter, dataPage);
            if (valueArray == null) continue;
            this.createTemporaryTable(printWriter);
            this.writeRow(printWriter, dataPage, valueArray);
            if (!this.remove || this.storageId != 0 || !(string = valueArray[3].getString()).startsWith("CREATE USER ") || (n6 = ByteUtils.indexOf(dataPage.getBytes(), "SALT ".getBytes(), n3)) < 0) continue;
            String string2 = string.substring("CREATE USER ".length(), string.indexOf("SALT ") - 1);
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            SHA256 sHA256 = new SHA256();
            byte[] byArray = sHA256.getKeyPasswordHash(string2, "".toCharArray());
            byte[] byArray2 = RandomUtils.getSecureBytes(8);
            byte[] byArray3 = sHA256.getHashWithSalt(byArray, byArray2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SALT '").append(ByteUtils.convertBytesToString(byArray2)).append("' HASH '").append(ByteUtils.convertBytesToString(byArray3)).append('\'');
            byte[] byArray4 = stringBuilder.toString().getBytes();
            System.arraycopy(byArray4, 0, dataPage.getBytes(), n6, byArray4.length);
            fileStore.seek((long)n * l);
            fileStore.write(dataPage.getBytes(), 0, n);
            if (this.trace) {
                this.out.println("User: " + string2);
            }
            this.remove = false;
        }
    }

    private Value[] createRecord(PrintWriter printWriter, DataPage dataPage) {
        Value[] valueArray;
        this.recordLength = dataPage.readInt();
        if (this.recordLength <= 0) {
            this.writeDataError(printWriter, "recordLength<0", dataPage.getBytes(), this.blockCount);
            return null;
        }
        try {
            valueArray = new Value[this.recordLength];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), this.blockCount);
            return null;
        }
        return valueArray;
    }

    private void writeRow(PrintWriter printWriter, DataPage dataPage, Value[] valueArray) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO " + this.storageName + " VALUES(");
        this.valueId = 0;
        while (this.valueId < this.recordLength) {
            try {
                object = dataPage.readValue();
                valueArray[this.valueId] = object;
                if (this.valueId > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.getSQL((Value)object));
            }
            catch (Exception exception) {
                this.writeDataError(printWriter, "exception " + exception, dataPage.getBytes(), this.blockCount);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), this.blockCount);
            }
            ++this.valueId;
        }
        stringBuilder.append(");");
        printWriter.println(stringBuilder.toString());
        printWriter.flush();
        if (this.storageId == 0) {
            try {
                object = new SimpleRow(valueArray);
                MetaRecord metaRecord = new MetaRecord((SearchRow)object);
                this.schema.add(metaRecord);
                if (metaRecord.getObjectType() == 0) {
                    String string = valueArray[3].getString();
                    String string2 = this.extractTableOrViewName(string);
                    this.tableMap.put(metaRecord.getId(), string2);
                }
            }
            catch (Throwable throwable) {
                this.writeError(printWriter, throwable);
            }
        }
    }

    private void dumpData(String string) {
        this.setDatabaseName(string.substring(0, string.length() - ".data.db".length()));
        this.dumpData(string, string, 48);
    }

    private void resetSchema() {
        this.schema = ObjectArray.newInstance();
        this.objectIdSet = New.hashSet();
        this.tableMap = New.hashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void dumpData(String var1_1, String var2_2, int var3_3) {
        var4_4 = null;
        var5_5 = null;
        try {
            var4_4 = this.getWriter(var2_2, ".sql");
            var4_4.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
            var4_4.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
            this.resetSchema();
            var5_5 = FileStore.open(null, var1_1, "r");
            var6_6 = var5_5.length();
            var8_8 = 128;
            var9_9 = (int)(var6_6 / (long)var8_8);
            this.blockCount = 1;
            var10_10 = var9_9 / 64;
            var11_11 = new int[var10_10 + 1];
            this.block = 0;
            while (this.block < var9_9) {
                block20: {
                    block23: {
                        block22: {
                            block21: {
                                var5_5.seek((long)var3_3 + (long)this.block * (long)var8_8);
                                var12_12 = new byte[var8_8];
                                var13_13 = DataPage.create((DataHandler)this, var12_12);
                                try {
                                    var5_5.readFully(var12_12, 0, var8_8);
                                }
                                catch (SQLException var14_14) {
                                    var4_4.println("-- ERROR: can not read: " + var14_14);
                                    break;
                                }
                                this.blockCount = var13_13.readInt();
                                this.setStorage(-1);
                                this.recordLength = -1;
                                this.valueId = -1;
                                if (this.blockCount != 0) break block21;
                                this.blockCount = 1;
                                break block20;
                            }
                            if (this.blockCount >= 0) break block22;
                            this.writeDataError(var4_4, "blockCount<0", var13_13.getBytes(), 1);
                            this.blockCount = 1;
                            break block20;
                        }
                        if ((long)this.blockCount * (long)var8_8 < 0x1FFFFFFFL && this.blockCount * var8_8 >= 0) break block23;
                        this.writeDataError(var4_4, "blockCount=" + this.blockCount, var13_13.getBytes(), 1);
                        this.blockCount = 1;
                        break block20;
                    }
                    var4_4.println("-- block " + this.block + " - " + (this.block + this.blockCount - 1));
                    try {
                        var13_13.checkCapacity(this.blockCount * var8_8);
                    }
                    catch (OutOfMemoryError var14_15) {
                        this.writeDataError(var4_4, "out of memory", var13_13.getBytes(), 1);
                        this.blockCount = 1;
                        break block20;
                    }
                    if (this.blockCount <= 1) ** GOTO lbl66
                    if (this.blockCount * var8_8 < 0) {
                        this.writeDataError(var4_4, "wrong blockCount", var13_13.getBytes(), 1);
                        this.blockCount = 1;
                    } else {
                        try {
                            var5_5.readFully(var13_13.getBytes(), var8_8, this.blockCount * var8_8 - var8_8);
                        }
                        catch (Throwable var14_16) {
                            this.writeDataError(var4_4, "eof", var13_13.getBytes(), 1);
                            this.blockCount = 1;
                            var5_5 = FileStore.open(null, var1_1, "r");
                            break block20;
                        }
lbl66:
                        // 2 sources

                        try {
                            var13_13.check(this.blockCount * var8_8);
                        }
                        catch (SQLException var14_17) {
                            this.writeDataError(var4_4, "wrong checksum", var13_13.getBytes(), 1);
                            this.blockCount = 1;
                            break block20;
                        }
                        this.setStorage(var13_13.readInt());
                        if (this.storageId < 0) {
                            this.writeDataError(var4_4, "storageId<0", var13_13.getBytes(), this.blockCount);
                        } else {
                            var14_18 = this.block / 64;
                            if (var11_11[var14_18] != 0 && var11_11[var14_18] != this.storageId) {
                                this.writeDataError(var4_4, "double allocation, previous=" + var11_11[var14_18] + " now=" + this.storageId, var13_13.getBytes(), this.blockCount);
                            } else {
                                var11_11[var14_18] = this.storageId;
                            }
                            var15_19 = this.createRecord(var4_4, var13_13);
                            if (var15_19 != null) {
                                this.createTemporaryTable(var4_4);
                                this.writeRow(var4_4, var13_13, var15_19);
                            }
                        }
                    }
                }
                this.block += this.blockCount;
            }
            this.writeSchema(var4_4);
            var4_4.close();
        }
        catch (Throwable var6_7) {
            try {
                this.writeError(var4_4, var6_7);
            }
            catch (Throwable var16_20) {
                IOUtils.closeSilently(var4_4);
                this.closeSilently(var5_5);
                throw var16_20;
            }
            IOUtils.closeSilently(var4_4);
            this.closeSilently(var5_5);
        }
        IOUtils.closeSilently(var4_4);
        this.closeSilently(var5_5);
    }

    private void writeSchema(PrintWriter printWriter) {
        Object object;
        MetaRecord.sort(this.schema);
        for (MetaRecord object2 : this.schema) {
            object = object2.getSQL();
            if (!((String)object).startsWith("CREATE ")) continue;
            printWriter.println((String)object + ";");
        }
        for (Map.Entry entry : this.tableMap.entrySet()) {
            object = (Integer)entry.getKey();
            String string = (String)entry.getValue();
            if (!this.objectIdSet.contains(object)) continue;
            this.setStorage((Integer)object);
            printWriter.println("INSERT INTO " + string + " SELECT * FROM " + this.storageName + ";");
        }
        for (Integer n : this.objectIdSet) {
            this.setStorage(n);
            printWriter.println("DROP TABLE " + this.storageName + ";");
        }
        printWriter.println("DROP ALIAS READ_CLOB;");
        printWriter.println("DROP ALIAS READ_BLOB;");
        for (MetaRecord metaRecord : this.schema) {
            object = metaRecord.getSQL();
            if (((String)object).startsWith("CREATE ")) continue;
            printWriter.println((String)object + ";");
        }
    }

    private void createTemporaryTable(PrintWriter printWriter) {
        if (!this.objectIdSet.contains(this.storageId)) {
            this.objectIdSet.add(this.storageId);
            StatementBuilder statementBuilder = new StatementBuilder("CREATE TABLE ");
            statementBuilder.append(this.storageName).append('(');
            for (int i = 0; i < this.recordLength; ++i) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append('C').append(i).append(" VARCHAR");
            }
            printWriter.println(statementBuilder.append(");").toString());
            printWriter.flush();
        }
    }

    private String extractTableOrViewName(String string) {
        int n = string.indexOf(" TABLE ");
        int n2 = string.indexOf(" VIEW ");
        if (n > 0 && n2 > 0) {
            if (n < n2) {
                n2 = -1;
            } else {
                n = -1;
            }
        }
        if (n2 > 0) {
            string = string.substring(n2 + " VIEW ".length());
        } else if (n > 0) {
            string = string.substring(n + " TABLE ".length());
        } else {
            return "UNKNOWN";
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                bl = !bl;
                continue;
            }
            if (bl || c > ' ' && c != '(') continue;
            string = string.substring(0, i);
            return string;
        }
        return "UNKNOWN";
    }

    private void closeSilently(FileStore fileStore) {
        if (fileStore != null) {
            fileStore.closeSilently();
        }
    }

    private void writeError(PrintWriter printWriter, Throwable throwable) {
        if (printWriter != null) {
            printWriter.println("// error: " + throwable);
        }
        this.traceError("Error", throwable);
    }

    @Override
    public String getDatabasePath() {
        return this.databaseName;
    }

    @Override
    public FileStore openFile(String string, String string2, boolean bl) throws SQLException {
        return FileStore.open(this, string, "rw");
    }

    @Override
    public int getChecksum(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            n3 += byArray[n++];
        }
        return n3;
    }

    @Override
    public void checkPowerOff() {
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public void freeUpDiskSpace() {
    }

    @Override
    public void handleInvalidChecksum() throws SQLException {
        throw new SQLException("Invalid Checksum");
    }

    @Override
    public int compareTypeSave(Value value, Value value2) {
        throw Message.throwInternalError();
    }

    @Override
    public int getMaxLengthInplaceLob() {
        throw Message.throwInternalError();
    }

    @Override
    public int allocateObjectId(boolean bl, boolean bl2) {
        throw Message.throwInternalError();
    }

    @Override
    public String createTempFile() {
        throw Message.throwInternalError();
    }

    @Override
    public String getLobCompressionAlgorithm(int n) {
        return null;
    }

    @Override
    public Object getLobSyncObject() {
        return this;
    }

    @Override
    public boolean getLobFilesInDirectories() {
        return this.lobFilesInDirectories;
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return null;
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    @Override
    public Trace getTrace() {
        return null;
    }

    static class PageInputStream
    extends InputStream {
        private final PrintWriter writer;
        private final FileStore store;
        private final DataPage page;
        private final int pageSize;
        private int trunkPage;
        private int dataPage;
        private IntArray dataPages = new IntArray();
        private boolean endOfFile;
        private int remaining;

        public PageInputStream(PrintWriter printWriter, DataHandler dataHandler, FileStore fileStore, int n, int n2, int n3) {
            this.writer = printWriter;
            this.store = fileStore;
            this.pageSize = n3;
            this.trunkPage = n;
            this.dataPage = n2;
            this.page = DataPage.create(dataHandler, n3);
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            return n < 0 ? -1 : byArray[0] & 0xFF;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (n2 == 0) {
                return 0;
            }
            int n4 = 0;
            while (n2 > 0 && (n3 = this.readBlock(byArray, n, n2)) >= 0) {
                n4 += n3;
                n += n3;
                n2 -= n3;
            }
            return n4 == 0 ? -1 : n4;
        }

        private int readBlock(byte[] byArray, int n, int n2) throws IOException {
            this.fillBuffer();
            if (this.endOfFile) {
                return -1;
            }
            int n3 = Math.min(this.remaining, n2);
            this.page.read(byArray, n, n3);
            this.remaining -= n3;
            return n3;
        }

        private void fillBuffer() throws IOException {
            if (this.remaining > 0 || this.endOfFile) {
                return;
            }
            try {
                int n;
                int n2;
                int n3;
                if (this.dataPages.size() == 0) {
                    if (this.trunkPage == 0) {
                        this.endOfFile = true;
                        return;
                    }
                    this.store.seek((long)this.trunkPage * (long)this.pageSize);
                    this.store.readFully(this.page.getBytes(), 0, this.pageSize);
                    this.page.reset();
                    this.page.readInt();
                    n3 = this.page.readByte();
                    if (n3 != 7) {
                        this.writer.println("-- eof  page: " + this.trunkPage + " type: " + n3 + " expected type: " + 7);
                        this.endOfFile = true;
                        return;
                    }
                    this.trunkPage = this.page.readInt();
                    n2 = this.page.readInt();
                    for (n = 0; n < n2; ++n) {
                        int n4 = this.page.readInt();
                        if (this.dataPage != 0) {
                            if (n4 != this.dataPage) continue;
                            this.dataPage = 0;
                        }
                        this.dataPages.add(n4);
                    }
                }
                this.page.reset();
                n3 = this.dataPages.get(0);
                this.dataPages.remove(0);
                this.store.seek((long)n3 * (long)this.pageSize);
                this.store.readFully(this.page.getBytes(), 0, this.pageSize);
                this.page.reset();
                n2 = this.page.readInt();
                n = this.page.readByte();
                if (n != 8) {
                    this.writer.println("-- eof  page: " + n3 + " type: " + n + " parent: " + n2 + " expected type: " + 8);
                    this.endOfFile = true;
                    return;
                }
                this.remaining = this.page.readInt();
            }
            catch (SQLException sQLException) {
                throw Message.convertToIOException(sQLException);
            }
        }
    }
}

