/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.zip.CRC32;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageScanIndex;
import org.h2.log.InDoubtTransaction;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.PageFreeList;
import org.h2.store.PageLog;
import org.h2.store.Record;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.util.Cache;
import org.h2.util.CacheLRU;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.FileUtils;
import org.h2.util.New;
import org.h2.util.ObjectArray;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.ValueInt;
import org.h2.value.ValueString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageStore
implements CacheWriter {
    public static final int PAGE_SIZE_MIN = 128;
    public static final int PAGE_SIZE_MAX = 32768;
    public static final int PAGE_SIZE_DEFAULT = 1024;
    public static final boolean STORE_BTREE_ROWCOUNT = false;
    private static final int PAGE_ID_FREE_LIST_ROOT = 3;
    private static final int PAGE_ID_META_ROOT = 4;
    private static final int MIN_PAGE_COUNT = 6;
    private static final int INCREMENT_PAGES = 128;
    private static final int READ_VERSION = 0;
    private static final int WRITE_VERSION = 0;
    private static final int META_TYPE_SCAN_INDEX = 0;
    private static final int META_TYPE_BTREE_INDEX = 1;
    private static final int META_TABLE_ID = -1;
    private static final SearchRow[] EMPTY_SEARCH_ROW = new SearchRow[0];
    private Database database;
    private final Trace trace;
    private String fileName;
    private FileStore file;
    private String accessMode;
    private int pageSize;
    private int pageSizeShift;
    private long writeCount;
    private int logFirstTrunkPage;
    private int logFirstDataPage;
    private int cacheSize;
    private Cache cache;
    private int freeListPagesPerList;
    private boolean recoveryRunning;
    private long fileLength;
    private int pageCount;
    private PageLog log;
    private Schema metaSchema;
    private TableData metaTable;
    private PageScanIndex metaIndex;
    private HashMap<Integer, Index> metaObjects;
    private int systemTableHeadPos;
    private long maxLogSize = 0x333333L;
    private Session systemSession;

    public PageStore(Database database, String string, String string2, int n) throws SQLException {
        this.fileName = string;
        this.accessMode = string2;
        this.database = database;
        this.trace = database.getTrace("pageStore");
        this.cacheSize = n;
        String string3 = database.getCacheType();
        this.cache = CacheLRU.getCache(this, string3, this.cacheSize);
        this.systemSession = new Session(database, null, 0);
    }

    public int copyDirect(int n, OutputStream outputStream) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            byte[] byArray = new byte[this.pageSize];
            try {
                if (n >= this.pageCount) {
                    return -1;
                }
                this.file.seek((long)n << this.pageSizeShift);
                this.file.readFullyDirect(byArray, 0, this.pageSize);
                outputStream.write(byArray, 0, this.pageSize);
                return n + 1;
            }
            catch (IOException iOException) {
                throw Message.convertIOException(iOException, this.fileName);
            }
        }
    }

    public void open() throws SQLException {
        try {
            if (FileUtils.exists(this.fileName)) {
                if (FileUtils.length(this.fileName) < 768L) {
                    this.openNew();
                } else {
                    this.openExisting();
                }
            } else {
                this.openNew();
            }
        }
        catch (SQLException sQLException) {
            this.close();
            throw sQLException;
        }
    }

    private void openNew() throws SQLException {
        this.setPageSize(1024);
        this.freeListPagesPerList = PageFreeList.getPagesAddressed(this.pageSize);
        this.file = this.database.openFile(this.fileName, this.accessMode, false);
        this.recoveryRunning = true;
        this.writeStaticHeader();
        this.writeVariableHeader();
        this.log = new PageLog(this);
        this.increaseFileSize(6);
        this.openMetaIndex();
        this.logFirstTrunkPage = this.allocatePage();
        this.log.openForWriting(this.logFirstTrunkPage);
        this.systemTableHeadPos = -1;
        this.recoveryRunning = false;
        this.increaseFileSize(128);
    }

    private void openExisting() throws SQLException {
        this.file = this.database.openFile(this.fileName, this.accessMode, true);
        this.readStaticHeader();
        this.freeListPagesPerList = PageFreeList.getPagesAddressed(this.pageSize);
        this.fileLength = this.file.length();
        this.pageCount = (int)(this.fileLength / (long)this.pageSize);
        if (this.pageCount < 6) {
            this.close();
            this.openNew();
            return;
        }
        this.readVariableHeader();
        this.log = new PageLog(this);
        this.log.openForReading(this.logFirstTrunkPage, this.logFirstDataPage);
        this.recover();
        if (!this.database.isReadOnly()) {
            this.recoveryRunning = true;
            this.log.free();
            this.logFirstTrunkPage = this.allocatePage();
            this.log.openForWriting(this.logFirstTrunkPage);
            this.recoveryRunning = false;
            this.checkpoint();
        }
    }

    private void writeBack() throws SQLException {
        ObjectArray<CacheObject> objectArray = this.cache.getAllChanged();
        CacheObject.sort(objectArray);
        for (CacheObject cacheObject : objectArray) {
            this.writeBack(cacheObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() throws SQLException {
        this.trace.debug("checkpoint");
        if (this.log == null || this.database.isReadOnly()) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            this.database.checkPowerOff();
            this.writeBack();
            this.log.checkpoint();
            this.switchLog();
            this.writeBack();
            byte[] byArray = new byte[this.pageSize];
            for (int i = 3; i < this.pageCount; ++i) {
                if (this.isUsed(i)) continue;
                this.file.seek((long)i << this.pageSizeShift);
                this.file.write(byArray, 0, this.pageSize);
                ++this.writeCount;
            }
        }
    }

    private void switchLog() throws SQLException {
        this.trace.debug("switchLog");
        Session[] sessionArray = this.database.getSessions(true);
        int n = this.log.getLogId();
        for (int i = 0; i < sessionArray.length; ++i) {
            Session session = sessionArray[i];
            int n2 = session.getFirstUncommittedLog();
            if (n2 == -1 || n2 >= n) continue;
            n = n2;
        }
        this.log.removeUntil(n);
    }

    private void readStaticHeader() throws SQLException {
        long l = this.file.length();
        this.database.notifyFileSize(l);
        this.file.seek(48L);
        Data data = Data.create((DataHandler)this.database, new byte[80]);
        this.file.readFully(data.getBytes(), 0, 80);
        this.setPageSize(data.readInt());
        int n = data.readByte();
        int n2 = data.readByte();
        if (n2 != 0) {
            throw Message.getSQLException(90048, this.fileName);
        }
        if (n != 0) {
            this.close();
            this.database.setReadOnly(true);
            this.accessMode = "r";
            this.file = this.database.openFile(this.fileName, this.accessMode, true);
        }
    }

    private void readVariableHeader() throws SQLException {
        Data data = Data.create((DataHandler)this.database, this.pageSize);
        int n = 1;
        while (true) {
            if (n == 3) {
                throw Message.getSQLException(90030, this.fileName);
            }
            data.reset();
            this.readPage(n, data);
            this.writeCount = data.readLong();
            this.logFirstTrunkPage = data.readInt();
            this.logFirstDataPage = data.readInt();
            CRC32 cRC32 = new CRC32();
            cRC32.update(data.getBytes(), 0, data.length());
            long l = cRC32.getValue();
            long l2 = data.readLong();
            if (l == l2) break;
            ++n;
        }
    }

    private void setPageSize(int n) throws SQLException {
        if (n < 128 || n > 32768) {
            throw Message.getSQLException(90030, this.fileName);
        }
        boolean bl = false;
        int n2 = 0;
        for (int i = 1; i <= n; i += i) {
            if (n == i) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            throw Message.getSQLException(90030, this.fileName);
        }
        this.pageSize = n;
        this.pageSizeShift = n2;
    }

    private void writeStaticHeader() throws SQLException {
        Data data = Data.create((DataHandler)this.database, new byte[this.pageSize - 48]);
        data.writeInt(this.pageSize);
        data.writeByte((byte)0);
        data.writeByte((byte)0);
        this.file.seek(48L);
        this.file.write(data.getBytes(), 0, this.pageSize - 48);
    }

    void setLogFirstPage(int n, int n2) throws SQLException {
        this.logFirstTrunkPage = n;
        this.logFirstDataPage = n2;
        this.writeVariableHeader();
    }

    private void writeVariableHeader() throws SQLException {
        Data data = Data.create((DataHandler)this.database, this.pageSize);
        data.writeLong(this.writeCount);
        data.writeInt(this.logFirstTrunkPage);
        data.writeInt(this.logFirstDataPage);
        CRC32 cRC32 = new CRC32();
        cRC32.update(data.getBytes(), 0, data.length());
        data.writeLong(cRC32.getValue());
        this.file.seek(this.pageSize);
        this.file.write(data.getBytes(), 0, this.pageSize);
        this.file.seek(this.pageSize + this.pageSize);
        this.file.write(data.getBytes(), 0, this.pageSize);
        ++this.writeCount;
    }

    public void close() throws SQLException {
        this.trace.debug("close");
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                throw Message.convert(iOException);
            }
            finally {
                this.file = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushLog() throws SQLException {
        if (this.file != null) {
            Database database = this.database;
            synchronized (database) {
                this.log.flush();
            }
        }
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBack(CacheObject cacheObject) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            Record record = (Record)cacheObject;
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("writeBack " + record);
            }
            record.write(null);
            record.setChanged(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(Record record, boolean bl, Data data) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            if (this.trace.isDebugEnabled() && !record.isChanged()) {
                this.trace.debug("updateRecord " + record.toString());
            }
            this.checkOpen();
            this.database.checkWritingAllowed();
            record.setChanged(true);
            int n = record.getPos();
            this.allocatePage(n);
            this.cache.update(n, record);
            if (bl && !this.recoveryRunning) {
                if (data == null) {
                    data = this.readPage(n);
                }
                this.log.addUndo(n, data);
            }
        }
    }

    private PageFreeList getFreeListForPage(int n) throws SQLException {
        return this.getFreeList((n - 3) / this.freeListPagesPerList);
    }

    private PageFreeList getFreeList(int n) throws SQLException {
        int n2 = 3 + n * this.freeListPagesPerList;
        while (n2 >= this.pageCount) {
            this.increaseFileSize(128);
        }
        PageFreeList pageFreeList = (PageFreeList)this.getRecord(n2);
        if (pageFreeList == null) {
            pageFreeList = new PageFreeList(this, n2);
            if (n2 < this.pageCount) {
                pageFreeList.read();
            }
            this.cache.put(pageFreeList);
        }
        return pageFreeList;
    }

    private void freePage(int n) throws SQLException {
        PageFreeList pageFreeList = this.getFreeListForPage(n);
        pageFreeList.free(n);
    }

    void allocatePage(int n) throws SQLException {
        PageFreeList pageFreeList = this.getFreeListForPage(n);
        pageFreeList.allocate(n);
    }

    private boolean isUsed(int n) throws SQLException {
        return this.getFreeListForPage(n).isUsed(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocatePage() throws SQLException {
        Database database = this.database;
        synchronized (database) {
            PageFreeList pageFreeList;
            int n;
            int n2 = 0;
            while ((n = (pageFreeList = this.getFreeList(n2)).allocate()) < 0) {
                ++n2;
            }
            if (n >= this.pageCount) {
                this.increaseFileSize(128);
            }
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("allocatePage " + n);
            }
            return n;
        }
    }

    private void increaseFileSize(int n) throws SQLException {
        this.pageCount += n;
        long l = (long)this.pageCount << this.pageSizeShift;
        this.file.setLength(l);
        ++this.writeCount;
        this.fileLength = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freePage(int n, boolean bl, Data data) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("freePage " + n);
        }
        Database database = this.database;
        synchronized (database) {
            this.cache.remove(n);
            this.freePage(n);
            if (this.recoveryRunning) {
                this.writePage(n, this.createData());
            } else if (bl) {
                if (data == null) {
                    data = this.readPage(n);
                }
                this.log.addUndo(n, data);
            }
        }
    }

    public Data createData() {
        return Data.create((DataHandler)this.database, new byte[this.pageSize]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record getRecord(int n) {
        Database database = this.database;
        synchronized (database) {
            CacheObject cacheObject = this.cache.find(n);
            return (Record)cacheObject;
        }
    }

    public Data readPage(int n) throws SQLException {
        Data data = this.createData();
        this.readPage(n, data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readPage(int n, Data data) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            if (n >= this.pageCount) {
                throw Message.getSQLException(90030, n + " of " + this.pageCount);
            }
            this.file.seek((long)n << this.pageSizeShift);
            this.file.readFully(data.getBytes(), 0, this.pageSize);
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePage(int n, Data data) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            this.file.seek((long)n << this.pageSizeShift);
            this.file.write(data.getBytes(), 0, this.pageSize);
            ++this.writeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecord(int n) {
        Database database = this.database;
        synchronized (database) {
            this.cache.remove(n);
        }
    }

    Database getDatabase() {
        return this.database;
    }

    private void recover() throws SQLException {
        PageScanIndex pageScanIndex;
        this.trace.debug("log recover");
        this.recoveryRunning = true;
        this.log.recover(0);
        this.log.recover(1);
        this.openMetaIndex();
        this.readMetaData();
        this.log.recover(2);
        if (!this.database.isReadOnly()) {
            if (this.log.getInDoubtTransactions().size() == 0) {
                this.log.recoverEnd();
                this.switchLog();
            } else {
                this.database.setReadOnly(true);
            }
        }
        this.systemTableHeadPos = (pageScanIndex = (PageScanIndex)this.metaObjects.get(0)) == null ? -1 : pageScanIndex.getHeadPos();
        for (Index index : this.metaObjects.values()) {
            index.close(this.systemSession);
        }
        this.recoveryRunning = false;
        this.trace.debug("log recover done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAddOrRemoveRow(Session session, int n, Row row, boolean bl) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            if (!this.recoveryRunning) {
                this.log.logAddOrRemoveRow(session, n, row, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Session session) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            this.checkOpen();
            this.log.commit(session.getId());
            if (this.log.getSize() > this.maxLogSize) {
                this.checkpoint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCommit(Session session, String string) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            this.log.prepareCommit(session, string);
        }
    }

    public int getSystemTableHeadPos() {
        return this.systemTableHeadPos;
    }

    void redo(int n, Row row, boolean bl) throws SQLException {
        PageScanIndex pageScanIndex;
        if (n == -1) {
            if (bl) {
                this.addMeta(row, this.systemSession, true);
            } else {
                this.removeMeta(row);
            }
        }
        if ((pageScanIndex = (PageScanIndex)this.metaObjects.get(n)) == null) {
            throw Message.throwInternalError("Table not found: " + n + " " + row + " " + bl);
        }
        Table table = pageScanIndex.getTable();
        if (bl) {
            table.addRow(this.systemSession, row);
        } else {
            table.removeRow(this.systemSession, row);
        }
    }

    private void openMetaIndex() throws SQLException {
        ObjectArray<Column> objectArray = ObjectArray.newInstance();
        objectArray.add(new Column("ID", 4));
        objectArray.add(new Column("TYPE", 4));
        objectArray.add(new Column("PARENT", 4));
        objectArray.add(new Column("HEAD", 4));
        objectArray.add(new Column("OPTIONS", 13));
        objectArray.add(new Column("COLUMNS", 13));
        this.metaSchema = new Schema(this.database, 0, "", null, true);
        int n = 4;
        this.metaTable = new TableData(this.metaSchema, "PAGE_INDEX", -1, objectArray, true, true, false, n, this.systemSession);
        this.metaIndex = (PageScanIndex)this.metaTable.getScanIndex(this.systemSession);
        this.metaObjects = New.hashMap();
        this.metaObjects.put(-1, this.metaIndex);
    }

    private void readMetaData() throws SQLException {
        Cursor cursor = this.metaIndex.find(this.systemSession, null, null);
        while (cursor.next()) {
            Row row = cursor.get();
            this.addMeta(row, this.systemSession, false);
        }
    }

    private void removeMeta(Row row) throws SQLException {
        int n = row.getValue(0).getInt();
        Index index = this.metaObjects.remove(n);
        index.getTable().removeIndex(index);
        if (index instanceof PageBtreeIndex) {
            index.getSchema().remove(index);
        }
        index.remove(this.systemSession);
    }

    private void addMeta(Row row, Session session, boolean bl) throws SQLException {
        Index index;
        int n = row.getValue(0).getInt();
        int n2 = row.getValue(1).getInt();
        int n3 = row.getValue(2).getInt();
        int n4 = row.getValue(3).getInt();
        String string = row.getValue(4).getString();
        String string2 = row.getValue(5).getString();
        String[] stringArray = StringUtils.arraySplit(string2, ',', false);
        IndexType indexType = IndexType.createNonUnique(true);
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("addMeta id=" + n + " type=" + n2 + " parent=" + n3 + " columns=" + string2);
        }
        if (bl) {
            this.writePage(n4, this.createData());
            this.allocatePage(n4);
        }
        if (n2 == 0) {
            String[] stringArray2;
            ObjectArray<Column> objectArray = ObjectArray.newInstance();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2 = new Column("C" + i, 4);
                objectArray.add((Column)stringArray2);
            }
            TableData tableData = new TableData(this.metaSchema, "T" + n, n, objectArray, true, true, false, n4, session);
            stringArray2 = StringUtils.arraySplit(string, ',', true);
            CompareMode compareMode = CompareMode.getInstance(stringArray2[0], Integer.parseInt(stringArray2[1]));
            tableData.setCompareMode(compareMode);
            index = tableData.getScanIndex(session);
        } else {
            PageScanIndex pageScanIndex = (PageScanIndex)this.metaObjects.get(n3);
            if (pageScanIndex == null) {
                throw Message.throwInternalError("parent not found:" + n3);
            }
            TableData tableData = (TableData)pageScanIndex.getTable();
            Column[] columnArray = tableData.getColumns();
            IndexColumn[] indexColumnArray = new IndexColumn[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                String string3 = stringArray[i];
                IndexColumn indexColumn = new IndexColumn();
                int n5 = string3.indexOf(47);
                if (n5 >= 0) {
                    object = string3.substring(n5 + 1);
                    indexColumn.sortType = Integer.parseInt((String)object);
                    string3 = string3.substring(0, n5);
                }
                indexColumn.column = object = columnArray[Integer.parseInt(string3)];
                indexColumnArray[i] = indexColumn;
            }
            index = tableData.addIndex(session, "I" + n, n, indexColumnArray, indexType, n4, null);
        }
        this.metaObjects.put(n, index);
    }

    public void addMeta(Index index, Session session, int n) throws SQLException {
        int n2 = index instanceof PageScanIndex ? 0 : 1;
        IndexColumn[] indexColumnArray = index.getIndexColumns();
        StatementBuilder statementBuilder = new StatementBuilder();
        for (IndexColumn indexColumn : indexColumnArray) {
            statementBuilder.appendExceptFirst(",");
            int n3 = indexColumn.column.getColumnId();
            statementBuilder.append(n3);
            int n4 = indexColumn.sortType;
            if (n4 == 0) continue;
            statementBuilder.append('/');
            statementBuilder.append(n4);
        }
        String string = statementBuilder.toString();
        Table table = index.getTable();
        CompareMode compareMode = table.getCompareMode();
        String string2 = compareMode.getName() + "," + compareMode.getStrength();
        Row row = this.metaTable.getTemplateRow();
        row.setValue(0, ValueInt.get(index.getId()));
        row.setValue(1, ValueInt.get(n2));
        row.setValue(2, ValueInt.get(table.getId()));
        row.setValue(3, ValueInt.get(n));
        row.setValue(4, ValueString.get(string2));
        row.setValue(5, ValueString.get(string));
        row.setPos(index.getId() + 1);
        this.metaIndex.add(session, row);
    }

    public void removeMeta(Index index, Session session) throws SQLException {
        if (!this.recoveryRunning) {
            Row row = this.metaIndex.getRow(session, index.getId() + 1);
            this.metaIndex.remove(session, row);
        }
    }

    public void setMaxLogSize(long l) {
        this.maxLogSize = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInDoubtTransactionState(int n, int n2, boolean bl) throws SQLException {
        boolean bl2 = this.database.isReadOnly();
        try {
            this.database.setReadOnly(false);
            this.log.setInDoubtTransactionState(n, n2, bl);
        }
        finally {
            this.database.setReadOnly(bl2);
        }
    }

    public ObjectArray<InDoubtTransaction> getInDoubtTransactions() {
        return this.log.getInDoubtTransactions();
    }

    public boolean isRecoveryRunning() {
        return this.recoveryRunning;
    }

    private void checkOpen() throws SQLException {
        if (this.file == null) {
            throw Message.getSQLException(90098);
        }
    }

    public static SearchRow[] newSearchRows(int n) {
        if (n == 0) {
            return EMPTY_SEARCH_ROW;
        }
        return new SearchRow[n];
    }

    public long getWriteCount() {
        return this.writeCount;
    }
}

