/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import org.h2.engine.Session;
import org.h2.log.InDoubtTransaction;
import org.h2.log.LogSystem;
import org.h2.log.SessionState;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.store.DataPage;
import org.h2.store.PageInputStream;
import org.h2.store.PageOutputStream;
import org.h2.store.PageStore;
import org.h2.store.PageStreamData;
import org.h2.store.PageStreamTrunk;
import org.h2.util.BitField;
import org.h2.util.IntIntHashMap;
import org.h2.util.New;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageLog {
    public static final int NOOP = 0;
    public static final int UNDO = 1;
    public static final int COMMIT = 2;
    public static final int PREPARE_COMMIT = 3;
    public static final int ROLLBACK = 4;
    public static final int ADD = 5;
    public static final int REMOVE = 6;
    public static final int CHECKPOINT = 7;
    static final int RECOVERY_STAGE_UNDO = 0;
    static final int RECOVERY_STAGE_ALLOCATE = 1;
    static final int RECOVERY_STAGE_REDO = 2;
    private final PageStore store;
    private int pos;
    private Trace trace;
    private DataOutputStream out;
    private ByteArrayOutputStream buffer;
    private PageInputStream pageIn;
    private PageOutputStream pageOut;
    private DataInputStream in;
    private int firstTrunkPage;
    private int firstDataPage;
    private DataPage data;
    private int logId;
    private int logPos;
    private int firstLogId;
    private BitField undo = new BitField();
    private IntIntHashMap logIdPageMap = new IntIntHashMap();
    private HashMap<Integer, SessionState> sessionStates = New.hashMap();

    PageLog(PageStore pageStore) {
        this.store = pageStore;
        this.data = pageStore.createDataPage();
        this.trace = pageStore.getTrace();
    }

    void openForWriting(int n) throws SQLException {
        this.trace.debug("log openForWriting firstPage:" + n);
        this.firstTrunkPage = n;
        this.pageOut = new PageOutputStream(this.store, n);
        this.pageOut.reserve(1);
        this.store.setLogFirstPage(n, this.pageOut.getCurrentDataPageId());
        this.buffer = new ByteArrayOutputStream();
        this.out = new DataOutputStream(this.buffer);
    }

    void free() throws SQLException {
        if (this.firstTrunkPage != 0) {
            PageStreamTrunk pageStreamTrunk = new PageStreamTrunk(this.store, this.firstTrunkPage);
            pageStreamTrunk.read();
            pageStreamTrunk.free();
        }
    }

    void openForReading(int n, int n2) {
        this.firstTrunkPage = n;
        this.firstDataPage = n2;
    }

    void recover(int n) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log recover stage:" + n);
        }
        if (n == 1) {
            PageInputStream pageInputStream = new PageInputStream(this.store, this.firstTrunkPage, this.firstDataPage);
            pageInputStream.allocateAllPages();
            return;
        }
        this.pageIn = new PageInputStream(this.store, this.firstTrunkPage, this.firstDataPage);
        this.in = new DataInputStream(this.pageIn);
        int n2 = 0;
        DataPage dataPage = this.store.createDataPage();
        try {
            int n3;
            this.pos = 0;
            while ((n3 = this.in.read()) >= 0) {
                Object object;
                int n4;
                int n5;
                ++this.pos;
                if (n3 == 1) {
                    n5 = this.in.readInt();
                    this.in.readFully(dataPage.getBytes(), 0, this.store.getPageSize());
                    if (n != 0) continue;
                    if (this.trace.isDebugEnabled()) {
                        this.trace.debug("log undo " + n5);
                    }
                    this.store.writePage(n5, dataPage);
                    continue;
                }
                if (n3 == 5 || n3 == 6) {
                    n5 = this.in.readInt();
                    n4 = this.in.readInt();
                    object = PageLog.readRow(this.in, dataPage);
                    if (n != 2) continue;
                    if (this.isSessionCommitted(n5, n2, this.pos)) {
                        if (this.trace.isDebugEnabled()) {
                            this.trace.debug("log redo " + (n3 == 5 ? "+" : "-") + " table:" + n4 + " " + object);
                        }
                        this.store.redo(n4, (Row)object, n3 == 5);
                        continue;
                    }
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log ignore s:" + n5 + " " + (n3 == 5 ? "+" : "-") + " table:" + n4 + " " + object);
                    continue;
                }
                if (n3 == 3) {
                    n5 = this.in.readInt();
                    n4 = this.in.readInt();
                    object = new byte[n4];
                    this.in.readFully((byte[])object);
                    String string = StringUtils.utf8Decode((byte[])object);
                    if (this.trace.isDebugEnabled()) {
                        this.trace.debug("log prepare commit " + n5 + " " + string + " pos:" + this.pos);
                    }
                    if (n != 0) continue;
                    int n6 = this.pageIn.getDataPage();
                    this.setPrepareCommit(n5, n6, string);
                    continue;
                }
                if (n3 == 4) {
                    n5 = this.in.readInt();
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log rollback " + n5 + " pos:" + this.pos);
                    continue;
                }
                if (n3 == 2) {
                    n5 = this.in.readInt();
                    if (this.trace.isDebugEnabled()) {
                        this.trace.debug("log commit " + n5 + " pos:" + this.pos);
                    }
                    if (n != 0) continue;
                    this.setLastCommitForSession(n5, n2, this.pos);
                    continue;
                }
                if (n3 == 0) continue;
                if (n3 == 7) {
                    ++n2;
                    continue;
                }
                if (!this.trace.isDebugEnabled()) continue;
                this.trace.debug("log end");
                break;
            }
            if (n == 2) {
                this.sessionStates = New.hashMap();
            }
        }
        catch (EOFException eOFException) {
            this.trace.debug("log recovery stopped: " + eOFException.toString());
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, "recover");
        }
    }

    private void setPrepareCommit(int n, int n2, String string) {
        SessionState sessionState = this.getOrAddSessionState(n);
        InDoubtTransaction inDoubtTransaction = string == null ? null : new InDoubtTransaction(this.store, null, n, n2, string, 0);
        sessionState.inDoubtTransaction = inDoubtTransaction;
    }

    public static Row readRow(DataInputStream dataInputStream, DataPage dataPage) throws IOException, SQLException {
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        dataPage.reset();
        dataPage.checkCapacity(n2);
        dataInputStream.readFully(dataPage.getBytes(), 0, n2);
        int n3 = dataPage.readInt();
        Value[] valueArray = new Value[n3];
        for (int i = 0; i < n3; ++i) {
            valueArray[i] = dataPage.readValue();
        }
        Row row = new Row(valueArray, 0);
        row.setPos(n);
        return row;
    }

    void addUndo(int n, DataPage dataPage) throws SQLException {
        try {
            if (this.undo.get(n)) {
                return;
            }
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log undo " + n);
            }
            this.undo.set(n);
            this.out.write(1);
            this.out.writeInt(n);
            this.out.write(dataPage.getBytes(), 0, this.store.getPageSize());
            this.flushOut();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    private void flushOut() throws IOException {
        this.out.flush();
        this.pageOut.write(this.buffer.toByteArray());
        this.buffer.reset();
    }

    void commit(int n) throws SQLException {
        try {
            LogSystem logSystem;
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log commit s:" + n);
            }
            if ((logSystem = this.store.getDatabase().getLog()) == null) {
                return;
            }
            this.out.write(2);
            this.out.writeInt(n);
            this.flushOut();
            if (logSystem.getFlushOnEachCommit()) {
                this.flush();
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    void prepareCommit(Session session, String string) throws SQLException {
        try {
            LogSystem logSystem;
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log prepare commit s:" + session.getId() + " " + string);
            }
            if ((logSystem = this.store.getDatabase().getLog()) == null) {
                return;
            }
            int n = this.store.getPageSize();
            byte[] byArray = StringUtils.utf8Encode(string);
            int n2 = byArray.length;
            if (9 + n2 >= PageStreamData.getCapacity(n)) {
                throw Message.getInvalidValueException("transaction name too long", string);
            }
            this.pageOut.fillDataPage();
            this.out.write(3);
            this.out.writeInt(session.getId());
            this.out.writeInt(n2);
            this.out.write(byArray);
            this.flushOut();
            this.pageOut.fillDataPage();
            if (logSystem.getFlushOnEachCommit()) {
                this.flush();
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    void rollbackPrepared(int n) throws SQLException {
        try {
            LogSystem logSystem;
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log rollback prepared s:" + n);
            }
            if ((logSystem = this.store.getDatabase().getLog()) == null) {
                return;
            }
            this.out.write(4);
            this.out.writeInt(n);
            this.flushOut();
            if (logSystem.getFlushOnEachCommit()) {
                this.flush();
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    void logAddOrRemoveRow(Session session, int n, Row row, boolean bl) throws SQLException {
        try {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log " + (bl ? "+" : "-") + " s:" + session.getId() + " table:" + n + " row:" + row);
            }
            session.addLogPos(this.logId, this.logPos);
            row.setLastLog(this.logId, this.logPos);
            this.data.reset();
            row.write(this.data);
            this.out.write(bl ? 5 : 6);
            this.out.writeInt(session.getId());
            this.out.writeInt(n);
            this.out.writeInt(row.getPos());
            this.out.writeInt(this.data.length());
            this.out.write(this.data.getBytes(), 0, this.data.length());
            this.flushOut();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    void flush() throws SQLException {
        try {
            this.pageOut.flush();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    void checkpoint() throws SQLException {
        try {
            this.out.write(7);
            this.flushOut();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
        this.undo = new BitField();
        ++this.logId;
        this.pageOut.fillDataPage();
        int n = this.pageOut.getCurrentDataPageId();
        this.logIdPageMap.put(this.logId, n);
    }

    int getLogId() {
        return this.logId;
    }

    int getLogPos() {
        return this.logPos;
    }

    void removeUntil(int n) throws SQLException {
        if (n == 0) {
            return;
        }
        int n2 = this.logIdPageMap.get(n);
        this.firstTrunkPage = this.pageOut.removeUntil(this.firstTrunkPage, n2);
        this.store.setLogFirstPage(this.firstTrunkPage, n2);
        while (this.firstLogId < n) {
            if (this.firstLogId > 0) {
                this.logIdPageMap.remove(this.firstLogId);
            }
            ++this.firstLogId;
        }
    }

    void close() throws SQLException {
        try {
            this.trace.debug("log close");
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    private boolean isSessionCommitted(int n, int n2, int n3) {
        SessionState sessionState = this.sessionStates.get(n);
        if (sessionState == null) {
            return false;
        }
        return sessionState.isCommitted(n2, n3);
    }

    private void setLastCommitForSession(int n, int n2, int n3) {
        SessionState sessionState = this.getOrAddSessionState(n);
        sessionState.lastCommitLog = n2;
        sessionState.lastCommitPos = n3;
        sessionState.inDoubtTransaction = null;
    }

    SessionState getOrAddSessionState(int n) {
        Integer n2 = n;
        SessionState sessionState = this.sessionStates.get(n2);
        if (sessionState == null) {
            sessionState = new SessionState();
            this.sessionStates.put(n2, sessionState);
            sessionState.sessionId = n;
        }
        return sessionState;
    }

    long getSize() {
        return this.pageOut.getSize();
    }

    ObjectArray<InDoubtTransaction> getInDoubtTransactions() {
        ObjectArray<InDoubtTransaction> objectArray = ObjectArray.newInstance();
        for (SessionState sessionState : this.sessionStates.values()) {
            InDoubtTransaction inDoubtTransaction = sessionState.inDoubtTransaction;
            if (inDoubtTransaction == null) continue;
            objectArray.add(inDoubtTransaction);
        }
        return objectArray;
    }

    void setInDoubtTransactionState(int n, int n2, boolean bl) throws SQLException {
        PageStreamData pageStreamData = new PageStreamData(this.store, n2, 0);
        pageStreamData.read();
        pageStreamData.initWrite();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.write(bl ? 2 : 4);
            dataOutputStream.writeInt(n);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, "");
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        pageStreamData.write(byteArrayOutputStream.toByteArray(), 0, byArray.length);
        byArray = new byte[pageStreamData.getRemaining()];
        pageStreamData.write(byArray, 0, byArray.length);
        pageStreamData.write(null);
    }
}

