/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageData;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageDataNode;
import org.h2.index.RowIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.store.PageStore;
import org.h2.store.Record;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueLob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageScanIndex
extends BaseIndex
implements RowIndex {
    private PageStore store;
    private TableData tableData;
    private final int headPos;
    private int lastKey;
    private long rowCount;
    private HashSet<Row> delta;
    private int rowCountDiff;
    private HashMap<Integer, Integer> sessionRowCount;

    public PageScanIndex(TableData tableData, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2, Session session) throws SQLException {
        this.initBaseIndex(tableData, n, tableData.getName() + "_TABLE_SCAN", indexColumnArray, indexType);
        if (this.database.isMultiVersion()) {
            this.sessionRowCount = New.hashMap();
            this.isMultiVersion = true;
        }
        this.tableData = tableData;
        this.store = this.database.getPageStore();
        if (!this.database.isPersistent()) {
            this.headPos = 0;
            return;
        }
        if (n2 == -1) {
            this.headPos = n2 = this.store.allocatePage();
            this.store.addMeta(this, session);
            PageDataLeaf pageDataLeaf = new PageDataLeaf(this, n2, 0, this.store.createDataPage());
            this.store.updateRecord(pageDataLeaf, true, pageDataLeaf.data);
        } else {
            this.headPos = n2;
            PageData pageData = this.getPage(n2);
            this.lastKey = pageData.getLastKey();
            this.rowCount = pageData.getRowCount();
            if (!this.database.isReadOnly()) {
                this.store.updateRecord(pageData, false, null);
            }
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("opened " + this.getName() + " rows:" + this.rowCount);
        }
        tableData.setRowCount(this.rowCount);
    }

    @Override
    public int getHeadPos() {
        return this.headPos;
    }

    @Override
    public void add(Session session, Row row) throws SQLException {
        PageData pageData;
        int n;
        if (row.getPos() == 0) {
            row.setPos(++this.lastKey);
        } else {
            this.lastKey = Math.max(this.lastKey, row.getPos() + 1);
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("add table:" + this.table.getId() + " " + row);
        }
        if (this.tableData.getContainsLargeObject()) {
            for (int i = 0; i < row.getColumnCount(); ++i) {
                Value value = row.getValue(i);
                Value value2 = value.link(this.database, this.getId());
                if (value2.isLinked()) {
                    session.unlinkAtCommitStop(value2);
                }
                if (value == value2) continue;
                row.setValue(i, value2);
            }
        }
        while ((n = (pageData = this.getPage(this.headPos)).addRowTry(row)) != 0) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("split " + n);
            }
            int n2 = pageData.getKey(n - 1);
            PageData pageData2 = pageData;
            PageData pageData3 = pageData.split(n);
            int n3 = pageData.getPageId();
            int n4 = this.store.allocatePage();
            pageData2.setPageId(n4);
            pageData2.setParentPageId(this.headPos);
            pageData3.setParentPageId(this.headPos);
            PageDataNode pageDataNode = new PageDataNode(this, n3, 0, this.store.createDataPage());
            pageDataNode.init(pageData2, n2, pageData3);
            this.store.updateRecord(pageData2, true, pageData2.data);
            this.store.updateRecord(pageData3, true, pageData3.data);
            this.store.updateRecord(pageDataNode, true, null);
            pageData = pageDataNode;
        }
        if (this.database.isMultiVersion()) {
            boolean bl;
            if (this.delta == null) {
                this.delta = New.hashSet();
            }
            if (!(bl = this.delta.remove(row))) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), 1);
        }
        ++this.rowCount;
        this.store.logAddOrRemoveRow(session, this.tableData.getId(), row, true);
    }

    PageData getPage(int n) throws SQLException {
        PageData pageData;
        Record record = this.store.getRecord(n);
        if (record != null) {
            return (PageData)record;
        }
        DataPage dataPage = this.store.readPage(n);
        dataPage.reset();
        int n2 = dataPage.readInt();
        int n3 = dataPage.readByte() & 0xFF;
        switch (n3 & 0xFFFFFFEF) {
            case 1: {
                pageData = new PageDataLeaf(this, n, n2, dataPage);
                break;
            }
            case 2: {
                pageData = new PageDataNode(this, n, n2, dataPage);
                break;
            }
            case 0: {
                PageDataLeaf pageDataLeaf = new PageDataLeaf(this, n, n2, dataPage);
                return pageDataLeaf;
            }
            default: {
                throw Message.getSQLException(90030, "page=" + n + " type=" + n3);
            }
        }
        pageData.read();
        return pageData;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        PageData pageData = this.getPage(this.headPos);
        return pageData.find(session);
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        throw Message.getUnsupportedException("PAGE");
    }

    @Override
    public double getCost(Session session, int[] nArray) {
        long l = 10L * (this.tableData.getRowCountApproximation() + 1000L);
        return l;
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void remove(Session session, Row row) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove " + row.getPos());
        }
        if (this.tableData.getContainsLargeObject()) {
            for (int i = 0; i < row.getColumnCount(); ++i) {
                Value value = row.getValue(i);
                if (!value.isLinked()) continue;
                session.unlinkAtCommit((ValueLob)value);
            }
        }
        if (this.rowCount == 1L) {
            this.removeAllRows();
        } else {
            int n = row.getPos();
            PageData pageData = this.getPage(this.headPos);
            pageData.remove(n);
            --this.rowCount;
        }
        if (this.database.isMultiVersion()) {
            boolean bl;
            row.setDeleted(true);
            if (this.delta == null) {
                this.delta = New.hashSet();
            }
            if (!(bl = this.delta.remove(row))) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), -1);
        }
        this.store.logAddOrRemoveRow(session, this.tableData.getId(), row, false);
    }

    @Override
    public void remove(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove");
        }
        this.store.removeMeta(this, session);
    }

    @Override
    public void truncate(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("truncate");
        }
        this.removeAllRows();
        if (this.tableData.getContainsLargeObject() && this.tableData.isPersistData()) {
            ValueLob.removeAllForTable(this.database, this.table.getId());
        }
        if (this.database.isMultiVersion()) {
            this.sessionRowCount.clear();
        }
        this.tableData.setRowCount(0L);
    }

    private void removeAllRows() throws SQLException {
        this.store.removeRecord(this.headPos);
        PageDataLeaf pageDataLeaf = new PageDataLeaf(this, this.headPos, 0, this.store.createDataPage());
        this.store.updateRecord(pageDataLeaf, true, null);
        this.rowCount = 0L;
        this.lastKey = 0;
    }

    @Override
    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException("PAGE");
    }

    @Override
    public Row getRow(Session session, int n) throws SQLException {
        PageData pageData = this.getPage(this.headPos);
        return pageData.getRow(n);
    }

    PageStore getPageStore() {
        return this.store;
    }

    Row readRow(DataPage dataPage) throws SQLException {
        return this.tableData.readRow(dataPage);
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            Integer n = this.sessionRowCount.get(session.getId());
            long l = n == null ? 0L : (long)n.intValue();
            l += this.rowCount;
            return l -= (long)this.rowCountDiff;
        }
        return this.rowCount;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public int getColumnIndex(Column column) {
        return -1;
    }

    @Override
    public void close(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("close");
        }
    }

    Iterator<Row> getDelta() {
        if (this.delta == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.delta.iterator();
    }

    private void incrementRowCount(int n, int n2) {
        if (this.database.isMultiVersion()) {
            Integer n3 = n;
            Integer n4 = this.sessionRowCount.get(n3);
            int n5 = n4 == null ? 0 : n4;
            this.sessionRowCount.put(n3, n5 + n2);
            this.rowCountDiff += n2;
        }
    }

    @Override
    public void commit(int n, Row row) {
        if (this.database.isMultiVersion()) {
            if (this.delta != null) {
                this.delta.remove(row);
            }
            this.incrementRowCount(row.getSessionId(), n == 1 ? 1 : -1);
        }
    }
}

