/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.index.PageBtree;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeNode;
import org.h2.message.Message;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.store.PageStore;

class PageBtreeLeaf
extends PageBtree {
    private static final int OFFSET_LENGTH = 2;
    private static final int OFFSET_START = 11;

    PageBtreeLeaf(PageBtreeIndex pageBtreeIndex, int n, int n2, DataPage dataPage) {
        super(pageBtreeIndex, n, n2, dataPage);
        this.start = 11;
    }

    void read() throws SQLException {
        this.data.setPos(4);
        int n = this.data.readByte();
        this.onlyPosition = (n & 0x10) == 0;
        int n2 = this.data.readInt();
        if (n2 != this.index.getId()) {
            throw Message.getSQLException(90030, "page:" + this.getPageId() + " expected table:" + this.index.getId() + "got:" + n2);
        }
        this.entryCount = this.data.readShortInt();
        this.offsets = new int[this.entryCount];
        this.rows = new SearchRow[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.offsets[i] = this.data.readShortInt();
        }
        this.start = this.data.length();
    }

    int addRowTry(SearchRow searchRow) throws SQLException {
        int n;
        int n2;
        int n3 = this.index.getRowSize(this.data, searchRow, this.onlyPosition);
        int n4 = this.index.getPageStore().getPageSize();
        int n5 = n2 = this.entryCount == 0 ? n4 : this.offsets[this.entryCount - 1];
        if (n2 - n3 < this.start + 2) {
            if (this.entryCount > 1) {
                return this.entryCount / 2 + 1;
            }
            this.onlyPosition = true;
            n3 = this.index.getRowSize(this.data, searchRow, this.onlyPosition);
        }
        this.written = false;
        int n6 = n2 - n3;
        int[] nArray = new int[this.entryCount + 1];
        SearchRow[] searchRowArray = new SearchRow[this.entryCount + 1];
        if (this.entryCount == 0) {
            n = 0;
        } else {
            this.readAllRows();
            n = this.find(searchRow, false, true);
            System.arraycopy(this.offsets, 0, nArray, 0, n);
            System.arraycopy(this.rows, 0, searchRowArray, 0, n);
            if (n < this.entryCount) {
                for (int i = n; i < this.entryCount; ++i) {
                    nArray[i + 1] = this.offsets[i] - n3;
                }
                n6 = (n == 0 ? n4 : this.offsets[n - 1]) - n3;
                System.arraycopy(this.rows, n, searchRowArray, n + 1, this.entryCount - n);
            }
        }
        ++this.entryCount;
        this.start += 2;
        nArray[n] = n6;
        searchRowArray[n] = searchRow;
        this.offsets = nArray;
        this.rows = searchRowArray;
        this.index.getPageStore().updateRecord(this, true, this.data);
        return 0;
    }

    private void removeRow(int n) throws SQLException {
        this.readAllRows();
        --this.entryCount;
        this.written = false;
        if (this.entryCount <= 0) {
            Message.throwInternalError();
        }
        int[] nArray = new int[this.entryCount];
        SearchRow[] searchRowArray = new SearchRow[this.entryCount];
        System.arraycopy(this.offsets, 0, nArray, 0, n);
        System.arraycopy(this.rows, 0, searchRowArray, 0, n);
        int n2 = n > 0 ? this.offsets[n - 1] : this.index.getPageStore().getPageSize();
        int n3 = n2 - this.offsets[n];
        for (int i = n; i < this.entryCount; ++i) {
            nArray[i] = this.offsets[i + 1] + n3;
        }
        System.arraycopy(this.rows, n + 1, searchRowArray, n, this.entryCount - n);
        this.start -= 2;
        this.offsets = nArray;
        this.rows = searchRowArray;
    }

    int getEntryCount() {
        return this.entryCount;
    }

    PageBtree split(int n) throws SQLException {
        int n2 = this.index.getPageStore().allocatePage();
        PageBtreeLeaf pageBtreeLeaf = new PageBtreeLeaf(this.index, n2, this.parentPageId, this.index.getPageStore().createDataPage());
        int n3 = n;
        while (n3 < this.entryCount) {
            pageBtreeLeaf.addRowTry(this.getRow(n));
            this.removeRow(n);
        }
        return pageBtreeLeaf;
    }

    PageBtreeLeaf getFirstLeaf() {
        return this;
    }

    PageBtreeLeaf getLastLeaf() {
        return this;
    }

    boolean remove(SearchRow searchRow) throws SQLException {
        int n = this.find(searchRow, false, false);
        if (this.index.compareRows(searchRow, this.getRow(n)) != 0) {
            throw Message.getSQLException(90112, this.index.getSQL() + ": " + searchRow);
        }
        if (this.entryCount == 1) {
            return true;
        }
        this.removeRow(n);
        this.index.getPageStore().updateRecord(this, true, this.data);
        return false;
    }

    int getRowCount() {
        return this.entryCount;
    }

    void setRowCountStored(int n) {
    }

    public int getByteCount(DataPage dataPage) {
        return this.index.getPageStore().getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.write();
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    PageStore getPageStore() {
        return this.index.getPageStore();
    }

    private void write() throws SQLException {
        int n;
        if (this.written) {
            return;
        }
        this.readAllRows();
        this.data.reset();
        this.data.writeInt(this.parentPageId);
        this.data.writeByte((byte)(4 | (this.onlyPosition ? 0 : 16)));
        this.data.writeInt(this.index.getId());
        this.data.writeShortInt(this.entryCount);
        for (n = 0; n < this.entryCount; ++n) {
            this.data.writeShortInt(this.offsets[n]);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.index.writeRow(this.data, this.offsets[n], this.rows[n], this.onlyPosition);
        }
        this.written = true;
    }

    DataPage getDataPage() throws SQLException {
        this.write();
        return this.data;
    }

    void find(PageBtreeCursor pageBtreeCursor, SearchRow searchRow, boolean bl) throws SQLException {
        int n = this.find(searchRow, bl, false);
        if (n > this.entryCount) {
            if (this.parentPageId == 0) {
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.find(pageBtreeCursor, searchRow, bl);
            return;
        }
        pageBtreeCursor.setCurrent(this, n);
    }

    void last(PageBtreeCursor pageBtreeCursor) {
        pageBtreeCursor.setCurrent(this, this.entryCount - 1);
    }

    void remapChildren() {
    }

    void nextPage(PageBtreeCursor pageBtreeCursor) throws SQLException {
        if (this.parentPageId == 0) {
            pageBtreeCursor.setCurrent(null, 0);
            return;
        }
        PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
        pageBtreeNode.nextPage(pageBtreeCursor, this.getPos());
    }

    void previousPage(PageBtreeCursor pageBtreeCursor) throws SQLException {
        if (this.parentPageId == 0) {
            pageBtreeCursor.setCurrent(null, 0);
            return;
        }
        PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
        pageBtreeNode.previousPage(pageBtreeCursor, this.getPos());
    }

    public String toString() {
        return "page[" + this.getPos() + "] btree leaf table:" + this.index.getId() + " entries:" + this.entryCount;
    }
}

