/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.command.Parser;
import org.h2.server.web.DbSchema;
import org.h2.util.New;
import org.h2.util.StringUtils;

public class DbContents {
    DbSchema[] schemas;
    DbSchema defaultSchema;
    boolean isOracle;
    boolean isH2;
    boolean isH2ModeMySQL;
    boolean isPostgreSQL;
    boolean isMySQL;
    boolean isDerby;
    boolean isFirebird;
    boolean isSQLite;

    static int findColumn(ResultSet resultSet, String string, int n) {
        try {
            return resultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            return n;
        }
    }

    void readContents(DatabaseMetaData databaseMetaData) throws SQLException {
        Object object;
        String string = StringUtils.toLowerEnglish(databaseMetaData.getDatabaseProductName());
        this.isSQLite = string.indexOf("sqlite") >= 0;
        String string2 = databaseMetaData.getURL();
        if (string2 != null) {
            this.isH2 = string2.startsWith("jdbc:h2:");
            if (this.isH2) {
                object = databaseMetaData.getConnection().createStatement().executeQuery("SELECT UPPER(VALUE) FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME='MODE'");
                object.next();
                if ("MYSQL".equals(object.getString(1))) {
                    this.isH2ModeMySQL = true;
                }
            }
            this.isOracle = string2.startsWith("jdbc:oracle:");
            this.isPostgreSQL = string2.startsWith("jdbc:postgresql:");
            this.isMySQL = string2.startsWith("jdbc:mysql:");
            this.isDerby = string2.startsWith("jdbc:derby:");
            this.isFirebird = string2.startsWith("jdbc:firebirdsql:");
        }
        object = this.getDefaultSchemaName(databaseMetaData);
        String[] stringArray = this.getSchemaNames(databaseMetaData);
        this.schemas = new DbSchema[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            DbSchema[] dbSchemaArray = stringArray[i];
            int n = object == null || ((String)object).equals(dbSchemaArray) ? 1 : 0;
            DbSchema dbSchema = new DbSchema(this, (String)dbSchemaArray, n != 0);
            if (dbSchema.isDefault) {
                this.defaultSchema = dbSchema;
            }
            this.schemas[i] = dbSchema;
            String[] stringArray2 = new String[]{"TABLE", "SYSTEM TABLE", "VIEW", "SYSTEM VIEW", "TABLE LINK", "SYNONYM"};
            dbSchema.readTables(databaseMetaData, stringArray2);
        }
        if (this.defaultSchema == null) {
            String string3 = null;
            for (DbSchema dbSchema : this.schemas) {
                if ("dbo".equals(dbSchema.name)) {
                    this.defaultSchema = dbSchema;
                    break;
                }
                if (this.defaultSchema != null && string3 != null && dbSchema.name.length() >= string3.length()) continue;
                string3 = dbSchema.name;
                this.defaultSchema = dbSchema;
            }
        }
    }

    private String[] getSchemaNames(DatabaseMetaData databaseMetaData) throws SQLException {
        Object object;
        if (this.isMySQL) {
            return new String[]{""};
        }
        if (this.isFirebird) {
            return new String[]{null};
        }
        ResultSet resultSet = databaseMetaData.getSchemas();
        ArrayList<String> arrayList = New.arrayList();
        while (resultSet.next()) {
            object = resultSet.getString(DbContents.findColumn(resultSet, "TABLE_SCHEM", 1));
            if (object == null) continue;
            arrayList.add((String)object);
        }
        resultSet.close();
        object = new String[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    private String getDefaultSchemaName(DatabaseMetaData databaseMetaData) {
        String string = "";
        try {
            if (this.isOracle) {
                return databaseMetaData.getUserName();
            }
            if (this.isPostgreSQL) {
                return "public";
            }
            if (this.isMySQL) {
                return "";
            }
            if (this.isDerby) {
                return StringUtils.toUpperEnglish(databaseMetaData.getUserName());
            }
            if (this.isFirebird) {
                return null;
            }
            ResultSet resultSet = databaseMetaData.getSchemas();
            int n = resultSet.findColumn("IS_DEFAULT");
            while (resultSet.next()) {
                if (!resultSet.getBoolean(n)) continue;
                string = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    String quoteIdentifier(String string) {
        if (string == null) {
            return null;
        }
        if (this.isH2 && !this.isH2ModeMySQL) {
            return Parser.quoteIdentifier(string);
        }
        return StringUtils.toUpperEnglish(string);
    }
}

