/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.Cache;
import org.h2.util.CacheHead;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;

class CacheTQ
implements Cache {
    static final String TYPE_NAME = "TQ";
    private static final int MAIN = 1;
    private static final int IN = 2;
    private static final int OUT = 3;
    private static final int PERCENT_IN = 20;
    private static final int PERCENT_OUT = 50;
    private final CacheWriter writer;
    private final CacheObject headMain = new CacheHead();
    private final CacheObject headIn = new CacheHead();
    private final CacheObject headOut = new CacheHead();
    private final int len;
    private final int mask;
    private int maxSize;
    private int maxMain;
    private int maxIn;
    private int maxOut;
    private int sizeMain;
    private int sizeIn;
    private int sizeOut;
    private int recordCount;
    private CacheObject[] values;

    CacheTQ(CacheWriter cacheWriter, int n) {
        int n2 = n * 1024 / 4;
        this.writer = cacheWriter;
        this.maxSize = n2;
        this.len = MathUtils.nextPowerOf2(n2 / 64);
        this.mask = this.len - 1;
        MathUtils.checkPowerOf2(this.len);
        this.recalculateMax();
        this.clear();
    }

    public void clear() {
        this.headMain.next = this.headMain.previous = this.headMain;
        this.headIn.next = this.headIn.previous = this.headIn;
        this.headOut.next = this.headOut.previous = this.headOut;
        this.values = null;
        this.values = new CacheObject[this.len];
        this.sizeMain = 0;
        this.sizeOut = 0;
        this.sizeIn = 0;
        this.recordCount = 0;
    }

    private void recalculateMax() {
        this.maxMain = this.maxSize;
        this.maxIn = this.maxSize * 20 / 100;
        this.maxOut = this.maxSize * 50 / 100;
    }

    private void addToFront(CacheObject cacheObject, CacheObject cacheObject2) {
        if (SysProperties.CHECK) {
            if (cacheObject2 == cacheObject) {
                Message.throwInternalError("try to move head");
            }
            if (cacheObject2.next != null || cacheObject2.previous != null) {
                Message.throwInternalError("already linked");
            }
        }
        cacheObject2.next = cacheObject;
        cacheObject2.previous = cacheObject.previous;
        cacheObject2.previous.next = cacheObject2;
        cacheObject.previous = cacheObject2;
    }

    private void removeFromList(CacheObject cacheObject) {
        if (SysProperties.CHECK && cacheObject instanceof CacheHead && cacheObject.cacheQueue != 3) {
            Message.throwInternalError();
        }
        cacheObject.previous.next = cacheObject.next;
        cacheObject.next.previous = cacheObject.previous;
        cacheObject.next = null;
        cacheObject.previous = null;
    }

    public CacheObject get(int n) {
        CacheObject cacheObject = this.findCacheObject(n);
        if (cacheObject == null) {
            return null;
        }
        if (cacheObject.cacheQueue == 1) {
            this.removeFromList(cacheObject);
            this.addToFront(this.headMain, cacheObject);
        } else {
            if (cacheObject.cacheQueue == 3) {
                return null;
            }
            if (cacheObject.cacheQueue == 2) {
                this.removeFromList(cacheObject);
                this.sizeIn -= cacheObject.getMemorySize();
                this.sizeMain += cacheObject.getMemorySize();
                cacheObject.cacheQueue = 1;
                this.addToFront(this.headMain, cacheObject);
            }
        }
        return cacheObject;
    }

    private CacheObject findCacheObject(int n) {
        CacheObject cacheObject = this.values[n & this.mask];
        while (cacheObject != null && cacheObject.getPos() != n) {
            cacheObject = cacheObject.chained;
        }
        return cacheObject;
    }

    private CacheObject removeCacheObject(int n) {
        int n2 = n & this.mask;
        CacheObject cacheObject = this.values[n2];
        if (cacheObject == null) {
            return null;
        }
        if (cacheObject.getPos() == n) {
            this.values[n2] = cacheObject.chained;
        } else {
            do {
                CacheObject cacheObject2 = cacheObject;
                cacheObject = cacheObject.chained;
                if (cacheObject != null) continue;
                return null;
            } while (cacheObject.getPos() != n);
            cacheObject2.chained = cacheObject.chained;
        }
        --this.recordCount;
        if (SysProperties.CHECK) {
            cacheObject.chained = null;
        }
        return cacheObject;
    }

    public void remove(int n) {
        CacheObject cacheObject = this.removeCacheObject(n);
        if (cacheObject != null) {
            this.removeFromList(cacheObject);
            if (cacheObject.cacheQueue == 1) {
                this.sizeMain -= cacheObject.getMemorySize();
            } else if (cacheObject.cacheQueue == 2) {
                this.sizeIn -= cacheObject.getMemorySize();
            }
        }
    }

    private void removeOldIfRequired() throws SQLException {
        if (this.sizeIn >= this.maxIn || this.sizeOut >= this.maxOut || this.sizeMain >= this.maxMain) {
            this.removeOld();
        }
    }

    private void removeOld() throws SQLException {
        CacheObject cacheObject;
        int n = 0;
        ObjectArray objectArray = new ObjectArray();
        while ((this.sizeIn * 4 > this.maxIn * 3 || this.sizeOut * 4 > this.maxOut * 3 || this.sizeMain * 4 > this.maxMain * 3) && this.recordCount > 16) {
            if (++n == this.recordCount) {
                this.writer.flushLog();
            }
            if (n >= this.recordCount * 2) {
                this.writer.getTrace().info("Cannot remove records, cache size too small?");
                break;
            }
            if (this.sizeIn > this.maxIn) {
                cacheObject = this.headIn.next;
                if (!cacheObject.canRemove()) {
                    this.removeFromList(cacheObject);
                    this.addToFront(this.headIn, cacheObject);
                    continue;
                }
                this.sizeIn -= cacheObject.getMemorySize();
                int n2 = cacheObject.getPos();
                this.removeCacheObject(n2);
                this.removeFromList(cacheObject);
                if (cacheObject.isChanged()) {
                    objectArray.add(cacheObject);
                }
                cacheObject = new CacheHead();
                cacheObject.setPos(n2);
                cacheObject.cacheQueue = 3;
                this.putCacheObject(cacheObject);
                this.addToFront(this.headOut, cacheObject);
                ++this.sizeOut;
                if (this.sizeOut < this.maxOut) continue;
                cacheObject = this.headOut.next;
                --this.sizeOut;
                this.removeCacheObject(cacheObject.getPos());
                this.removeFromList(cacheObject);
                continue;
            }
            if (this.sizeMain <= 0) continue;
            cacheObject = this.headMain.next;
            if (!cacheObject.canRemove() && !(cacheObject instanceof CacheHead)) {
                this.removeFromList(cacheObject);
                this.addToFront(this.headMain, cacheObject);
                continue;
            }
            this.sizeMain -= cacheObject.getMemorySize();
            this.removeCacheObject(cacheObject.getPos());
            this.removeFromList(cacheObject);
            if (!cacheObject.isChanged()) continue;
            objectArray.add(cacheObject);
        }
        if (objectArray.size() > 0) {
            CacheObject.sort(objectArray);
            for (n = 0; n < objectArray.size(); ++n) {
                cacheObject = (CacheObject)objectArray.get(n);
                this.writer.writeBack(cacheObject);
            }
        }
    }

    public ObjectArray getAllChanged() {
        ObjectArray objectArray = new ObjectArray();
        CacheObject cacheObject = this.headMain.next;
        while (cacheObject != this.headMain) {
            if (cacheObject.isChanged()) {
                objectArray.add(cacheObject);
            }
            cacheObject = cacheObject.next;
        }
        cacheObject = this.headIn.next;
        while (cacheObject != this.headIn) {
            if (cacheObject.isChanged()) {
                objectArray.add(cacheObject);
            }
            cacheObject = cacheObject.next;
        }
        CacheObject.sort(objectArray);
        return objectArray;
    }

    public CacheObject find(int n) {
        CacheObject cacheObject = this.findCacheObject(n);
        if (cacheObject != null && cacheObject.cacheQueue != 3) {
            return cacheObject;
        }
        return null;
    }

    private void putCacheObject(CacheObject cacheObject) {
        int n;
        if (SysProperties.CHECK) {
            for (n = 0; n < cacheObject.getBlockCount(); ++n) {
                CacheObject cacheObject2 = this.find(cacheObject.getPos() + n);
                if (cacheObject2 == null) continue;
                Message.throwInternalError("try to add a record twice i=" + n);
            }
        }
        n = cacheObject.getPos() & this.mask;
        cacheObject.chained = this.values[n];
        this.values[n] = cacheObject;
        ++this.recordCount;
    }

    public void put(CacheObject cacheObject) throws SQLException {
        int n = cacheObject.getPos();
        CacheObject cacheObject2 = this.findCacheObject(n);
        if (cacheObject2 != null) {
            if (cacheObject2.cacheQueue == 3) {
                this.removeCacheObject(n);
                this.removeFromList(cacheObject2);
                this.removeOldIfRequired();
                cacheObject.cacheQueue = 1;
                this.putCacheObject(cacheObject);
                this.addToFront(this.headMain, cacheObject);
                this.sizeMain += cacheObject.getMemorySize();
            }
        } else if (this.sizeMain < this.maxMain) {
            this.removeOldIfRequired();
            cacheObject.cacheQueue = 1;
            this.putCacheObject(cacheObject);
            this.addToFront(this.headMain, cacheObject);
            this.sizeMain += cacheObject.getMemorySize();
        } else {
            this.removeOldIfRequired();
            cacheObject.cacheQueue = 2;
            this.putCacheObject(cacheObject);
            this.addToFront(this.headIn, cacheObject);
            this.sizeIn += cacheObject.getMemorySize();
        }
    }

    public CacheObject update(int n, CacheObject cacheObject) throws SQLException {
        CacheObject cacheObject2 = this.find(n);
        if (cacheObject2 == null || cacheObject2.cacheQueue == 3) {
            this.put(cacheObject);
        } else if (cacheObject2 == cacheObject && cacheObject.cacheQueue == 1) {
            this.removeFromList(cacheObject);
            this.addToFront(this.headMain, cacheObject);
        }
        return cacheObject2;
    }

    public void setMaxSize(int n) throws SQLException {
        int n2 = n * 1024 / 4;
        this.maxSize = n2 < 0 ? 0 : n2;
        this.recalculateMax();
        this.removeOldIfRequired();
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getSize() {
        return this.sizeIn + this.sizeOut + this.sizeMain;
    }
}

